/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.jalbum.undo.EditGroup;
import net.jalbum.util.MonitoredWorkQueue;
import net.jalbum.util.Operation;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.SmartFlowLayout;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.LambdaAction;

public abstract class JAlbumObjectsPanel
extends JPanel {
    final JAlbumExplorer context;
    static final int SMALL_OBJECT_SIZE = 96;
    static final Dimension THUMBNAIL_DIMENSION = new Dimension(160, 160);
    public ExplorerSelectionModel selectionModel = new ExplorerSelectionModel(this);
    protected Dimension iconBounds;
    SmartFlowLayout explorerThumbsLayout = new SmartFlowLayout();
    JAlbumObject closestObject;

    public JAlbumObjectsPanel(JAlbumExplorer context) {
        this.context = context;
    }

    public Config.LabelType getLabelType() {
        return Config.getConfig().getLabelType();
    }

    public Dimension getIconBounds() {
        return this.iconBounds;
    }

    public void setIconScale(double scale) {
        this.iconBounds = new Dimension((int)((double)JAlbumObjectsPanel.THUMBNAIL_DIMENSION.width * scale), (int)((double)JAlbumObjectsPanel.THUMBNAIL_DIMENSION.height * scale));
        this.explorerThumbsLayout.setHgap(Math.min(32, (int)(scale * 32.0)));
        this.explorerThumbsLayout.setVgap(Math.min(26, (int)(scale * 26.0)));
        JAlbumObjectsPanel.invalidateTree(this);
        this.validate();
        List<JAlbumObject> selected = this.selectionModel.getSelectedObjects();
        if (selected.size() > 0) {
            JAlbumObject center = selected.get(selected.size() / 2);
            Rectangle visible = this.getVisibleRect();
            this.scrollRectToVisible(new Rectangle(center.getX() - visible.width / 2, center.getY() - visible.height / 2, visible.width, visible.height));
        }
    }

    public JAlbumObject getJAlbumObject(AlbumObject ao) {
        Component[] comps;
        for (Component element : comps = this.getComponents()) {
            JAlbumObject jao = (JAlbumObject)element;
            if (!jao.ao.equals(ao)) continue;
            return jao;
        }
        return null;
    }

    public int indexOf(JAlbumObject jao) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (jao != this.getComponents()[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(AlbumObject ao) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (ao != ((JAlbumObject)this.getComponents()[i]).ao) continue;
            return i;
        }
        return -1;
    }

    public Stream<JAlbumObject> objects() {
        return Stream.of(this.getComponents()).map(e -> (JAlbumObject)e);
    }

    public List<AlbumObject> listSelectedAlbumObjects() {
        return this.objects().filter(jao -> jao.isSelected()).map(jao -> jao.ao).collect(Collectors.toList());
    }

    public AlbumObject[] getSelectedAlbumObjects() {
        List<AlbumObject> selected = this.listSelectedAlbumObjects();
        return selected.toArray(new AlbumObject[selected.size()]);
    }

    JAlbumObject getNearestObject(Point p) {
        Component[] comps;
        Component nearestComp = null;
        Rectangle smallest = null;
        for (Component comp : comps = this.getComponents()) {
            if (!comp.isVisible()) continue;
            Rectangle bounds = comp.getBounds();
            if (bounds.contains(p)) {
                return (JAlbumObject)comp;
            }
            bounds.add(p);
            if (smallest != null && bounds.width * bounds.height >= smallest.width * smallest.height) continue;
            smallest = bounds;
            nearestComp = comp;
        }
        return (JAlbumObject)nearestComp;
    }

    protected void forSelected(String editName, Operation<JAlbumObject> op) {
        try (EditGroup _v = new EditGroup(editName);){
            MonitoredWorkQueue queue = new MonitoredWorkQueue(this.context, editName);
            for (JAlbumObject jao : this.selectionModel.getSelectedObjects()) {
                queue.submit(() -> op.accept(jao));
            }
            queue.awaitCompletion();
        }
        catch (Exception ex) {
            Debug.showFriendlyErrorDialog(this, ex);
        }
    }

    public void setRating(int rating) {
        this.forSelected(Msg.get("ui.ratingToolTip", rating), jao -> jao.ao.setRating(rating));
    }

    public void setFlag(Flag flag) {
        this.forSelected(Msg.get("edit.flag", new Object[]{flag}), jao -> jao.ao.setFlag(flag));
    }

    public void toggleIncluded() {
        boolean include = !this.selectionModel.getSelectedObjects().get(0).isIncluded();
        AlbumSynchronizer sync = new AlbumSynchronizer(this.context.parent.engine);
        this.forSelected(Msg.get("edit.exclude"), jao -> {
            if (!include) {
                sync.delete(jao.ao);
            }
            jao.setIncluded(include);
        });
    }

    protected void go(ExplorerSelectionModel.Direction dir, ActionEvent e) {
        JAlbumObject jao;
        JAlbumObject focused = this.selectionModel.getFocusedObject();
        if (focused != null && this.getComponentCount() > 0 && (jao = this.selectionModel.getNeighbourObject(focused, dir)) != null) {
            MouseEvent me = new MouseEvent(jao, 0, e.getWhen(), e.getModifiers(), 0, 0, 1, false);
            this.scrollRectToVisible(jao.getBounds());
            this.getMouseOnComponentAdapter().mousePressed(me);
        }
    }

    private void go(int i, ActionEvent e) {
        JAlbumObject jao;
        if (i >= 0 && i < this.getComponentCount() && (jao = (JAlbumObject)this.getComponent(i)) != null) {
            MouseEvent me = new MouseEvent(jao, 0, e.getWhen(), e.getModifiers(), 0, 0, 1, false);
            this.scrollRectToVisible(jao.getBounds());
            this.getMouseOnComponentAdapter().mousePressed(me);
        }
    }

    public void configureKeys(JScrollPane explorerScrollPane) {
        InputMap im = explorerScrollPane.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(38, 64), "unitScrollUp");
        im.put(KeyStroke.getKeyStroke(40, 64), "unitScrollDown");
        im.put(KeyStroke.getKeyStroke(37, 64), "unitScrollLeft");
        im.put(KeyStroke.getKeyStroke(39, 64), "unitScrollRight");
        im.put(KeyStroke.getKeyStroke(36, 0), "home");
        im.put(KeyStroke.getKeyStroke(35, 0), "end");
        im.put(KeyStroke.getKeyStroke(33, 0), "pageUp");
        im.put(KeyStroke.getKeyStroke(34, 0), "pageDown");
        ActionMap am = explorerScrollPane.getActionMap();
        am.put("unitScrollUp", new LambdaAction(ae -> this.go(ExplorerSelectionModel.Direction.NORTH, ae)));
        am.put("unitScrollDown", new LambdaAction(ae -> this.go(ExplorerSelectionModel.Direction.SOUTH, ae)));
        am.put("unitScrollLeft", new LambdaAction(ae -> this.go(ExplorerSelectionModel.Direction.PREVIOUS, ae)));
        am.put("unitScrollRight", new LambdaAction(ae -> this.go(ExplorerSelectionModel.Direction.NEXT, ae)));
        am.put("home", new LambdaAction(ae -> this.go(0, ae)));
        am.put("end", new LambdaAction(ae -> this.go(this.getComponentCount() - 1, ae)));
        am.put("pageUp", new LambdaAction(ae -> this.go(ExplorerSelectionModel.Direction.PAGE_UP, ae)));
        am.put("pageDown", new LambdaAction(ae -> this.go(ExplorerSelectionModel.Direction.PAGE_DOWN, ae)));
        im.put(KeyStroke.getKeyStroke(48, 64), "unrated");
        im.put(KeyStroke.getKeyStroke(49, 64), "1rated");
        im.put(KeyStroke.getKeyStroke(50, 64), "2rated");
        im.put(KeyStroke.getKeyStroke(51, 64), "3rated");
        im.put(KeyStroke.getKeyStroke(52, 64), "4rated");
        im.put(KeyStroke.getKeyStroke(53, 64), "5rated");
        im.put(KeyStroke.getKeyStroke(54, 64), "select");
        im.put(KeyStroke.getKeyStroke(55, 64), "second");
        im.put(KeyStroke.getKeyStroke(56, 64), "approved");
        im.put(KeyStroke.getKeyStroke(57, 64), "review");
        am.put("unrated", new LambdaAction(() -> this.setRating(0)));
        am.put("1rated", new LambdaAction(() -> this.setRating(1)));
        am.put("2rated", new LambdaAction(() -> this.setRating(2)));
        am.put("3rated", new LambdaAction(() -> this.setRating(3)));
        am.put("4rated", new LambdaAction(() -> this.setRating(4)));
        am.put("5rated", new LambdaAction(() -> this.setRating(5)));
        am.put("select", new LambdaAction(() -> this.setFlag(Flag.Select)));
        am.put("second", new LambdaAction(() -> this.setFlag(Flag.Second)));
        am.put("approved", new LambdaAction(() -> this.setFlag(Flag.Approved)));
        am.put("review", new LambdaAction(() -> this.setFlag(Flag.Review)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateTree(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] children;
            for (Component child : children = container.getComponents()) {
                if (child instanceof Container) {
                    JAlbumObjectsPanel.invalidateTree((Container)child);
                    continue;
                }
                if (!child.isValid()) continue;
                child.invalidate();
            }
            if (container.isValid()) {
                container.invalidate();
            }
        }
    }

    protected abstract MouseAdapter getMouseOnComponentAdapter();

    public List<JAlbumObject> getVisibleObjects() {
        return this.objects().filter(jao -> !jao.getVisibleRect().isEmpty()).collect(Collectors.toList());
    }
}

