/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import com.adobe.internal.xmp.XMPException;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.stage.Screen;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.JAlbumImageFilter;
import net.jalbum.views.View;
import se.datadosen.component.JFadePanel;
import se.datadosen.component.JSilentLabel;
import se.datadosen.component.WordList;
import se.datadosen.explorer.CaptionEditor;
import se.datadosen.explorer.DetailsEditor;
import se.datadosen.explorer.FileNameEditor;
import se.datadosen.explorer.JAlbumObjectsPanel;
import se.datadosen.explorer.KeywordsEditor;
import se.datadosen.explorer.NullEditor;
import se.datadosen.explorer.ScaledIcon;
import se.datadosen.explorer.Stamp;
import se.datadosen.explorer.TemporaryFileNameEditor;
import se.datadosen.explorer.TitleEditor;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.JAudioClipPanel;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.NamedThreadFactory;
import se.datadosen.util.Platform;
import se.datadosen.util.StringUtil;
import se.datadosen.util.annotations.ToolTipText;

public class JAlbumObject
extends JComponent {
    static boolean tabCycling;
    private static Icon warningIcon;
    private static Icon isFolderThumbnailIcon;
    private static Icon isMediaFileIcon;
    private static Icon hasImageFiltersIcon;
    private static Icon excludedEffectsIcon;
    private static Icon hasOriginalIcon;
    private static Icon infoIcon;
    private static Icon collaborativeIcon;
    private static Icon audioClipIcon;
    private static Icon paperClipIcon;
    private static final double SCALE_X;
    private static final double SCALE_Y;
    private static final ImageIcon excludedImage;
    private static final ImageIcon faintFolderIcon;
    private static final ImageIcon weblocIcon;
    private static final ImageIcon playIcon;
    private static ImageIcon defaultImageIcon;
    private static Icon[] stars;
    private static Icon linkImage;
    private boolean cut = false;
    Future<ImageIcon> iconLoader = null;
    Future<ImageIcon> hqIconLoader = null;
    private static final ExecutorService metadataLoaderPool;
    Future<Object> metadataLoader = null;
    public final AlbumObject ao;
    final JAlbumObjectsPanel context;
    private boolean selected;
    private boolean rubberbanded;
    private NorthPanel northPanel;
    private JPanel imagePanel = new JPanel();
    LabelEditor editor;
    private JPanel buttonPanel = new JPanel(new FlowLayout(0, 1, 1));
    private final JLabel image;
    private FileFilters.BasicImageInfo imageInfo;
    private boolean hasDisplayableImage;

    public boolean isCut() {
        return this.cut;
    }

    public void setCut(boolean cut) {
        boolean oldCut = this.cut;
        this.cut = cut;
        if (cut != oldCut) {
            this.repaint();
        }
    }

    private static JLabel createStatusLabel(Icon icon) {
        JSilentLabel label = new JSilentLabel(icon);
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        label.setVisible(false);
        return label;
    }

    private static JLabel createClickableStatusLabel(Icon icon) {
        JLabel label = new JLabel(icon);
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        label.setVisible(false);
        return label;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("JAlbum Objects are not serializable");
    }

    private static boolean mouseOverComponent(MouseEvent e, JComponent comp) {
        try {
            Rectangle bounds = comp.getBounds(null);
            bounds.setLocation(comp.getLocationOnScreen());
            return bounds.contains(e.getLocationOnScreen());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            return false;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setSelected(false);
        }
    }

    @Override
    public void invalidate() {
        if (!(this.editor instanceof DetailsEditor)) {
            this.editor.setVisible(this.context.getIconBounds().width >= 96);
        }
        super.invalidate();
    }

    public JAlbumObject(AlbumObject ao, final JAlbumObjectsPanel context) {
        this.ao = ao;
        this.context = context;
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.image = new JLabel(this, (Icon)defaultImageIcon){
            final /* synthetic */ JAlbumObject this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public Dimension getPreferredSize() {
                return context.getIconBounds();
            }

            @Override
            protected void paintComponent(Graphics g2d) {
                if (this.this$0.cut) {
                    Graphics2D g = (Graphics2D)g2d;
                    AlphaComposite composite = AlphaComposite.getInstance(3, 0.3f);
                    g.setComposite(composite);
                }
                super.paintComponent(g2d);
            }
        };
        this.image.setLayout(new BorderLayout());
        this.buttonPanel.setOpaque(false);
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.setOpaque(false);
        this.imagePanel.add((Component)this.image, "Center");
        this.setupViewMode();
        this.imagePanel.setBorder(JAlbumBorders.createImageBorder());
        this.validate();
    }

    void setupViewMode() {
        this.removeAll();
        if (this.context.getLabelType() != Config.LabelType.details) {
            this.add((Component)this.imagePanel, "North");
            this.editor = new NullEditor(this);
        } else {
            this.add((Component)this.imagePanel, "West");
            this.editor = new DetailsEditor(this);
        }
        this.add((Component)this.editor, "Center");
        this.iconLoader = null;
        this.hqIconLoader = null;
        this.metadataLoader = null;
        this.validate();
    }

    private void installNorthPanel() {
        this.northPanel = new NorthPanel();
        this.image.add((Component)this.northPanel, "North");
        this.validate();
    }

    void attachGlassButton(JButton glassButton) {
        if (this.buttonPanel.getComponentCount() > 0 && glassButton == this.buttonPanel.getComponent(0)) {
            glassButton.setVisible(true);
            return;
        }
        Container c = glassButton.getParent();
        if (c != null) {
            NorthPanel np = (NorthPanel)c.getParent();
            c.remove(glassButton);
            if (np != null) {
                np.infoPanel.setVisible(false);
            }
        }
        this.buttonPanel.add(glassButton);
        glassButton.setVisible(true);
        if (!TipOfTheDay.isPendingNotification() && !TipOfTheDay.isShowingNotification()) {
            TipOfTheDay.showInBackground(Msg.get("tip.editMode"));
        }
    }

    public void paintDragImage(Graphics g2d) {
        Border backup = this.imagePanel.getBorder();
        boolean selected = this.isSelected();
        this.setSelected(false);
        this.imagePanel.setBorder(null);
        this.buttonPanel.setVisible(false);
        this.paintComponent(g2d);
        this.paintChildren(g2d);
        this.buttonPanel.setVisible(true);
        this.imagePanel.setBorder(backup);
        this.setSelected(selected);
    }

    void refresh() {
        this.ao.invalidate();
        this.iconLoader = null;
        this.hqIconLoader = null;
        this.metadataLoader = null;
        this.repaint();
    }

    private boolean isHQRecommended() {
        if (Config.getConfig().getThumbnailQuality() == Config.ThumbnailQuality.HQ) {
            int iw = this.image.getIcon().getIconWidth();
            int ih = this.image.getIcon().getIconHeight();
            return (double)iw * SCALE_X > (double)Config.ThumbnailQuality.NORMAL.getBounds().width || (double)ih * SCALE_Y > (double)Config.ThumbnailQuality.NORMAL.getBounds().height;
        }
        return false;
    }

    private final void setIcon(Icon icon) {
        JAlbumUtilities.runOnAWT(() -> this.image.setIcon(icon));
    }

    private void render() {
        if (this.northPanel == null) {
            this.installNorthPanel();
        }
        if (this.iconLoader == null) {
            this.iconLoader = AlbumObject.iconLoaderPool.submit(() -> {
                ImageIcon icon;
                if (this.isHQRecommended() && ((AlbumObjectImpl)this.ao).isCached(Config.ThumbnailQuality.HQ)) {
                    icon = this.ao.getRepresentingIcon(Config.ThumbnailQuality.HQ.getBounds(), false);
                    SwingUtilities.invokeLater(() -> this.setIcon(new ScaledIcon(icon, this.image)));
                    this.hqIconLoader = this.iconLoader;
                } else {
                    icon = this.ao.getRepresentingIcon(Config.ThumbnailQuality.NORMAL.getBounds(), false);
                    SwingUtilities.invokeLater(() -> this.setIcon(new ScaledIcon(icon, this.image)));
                    if (this.isHQRecommended()) {
                        JAlbumUtilities.schedule(() -> SwingUtilities.invokeLater(() -> this.repaint()), 500L, TimeUnit.MILLISECONDS);
                    }
                }
                return icon;
            });
        } else if (this.iconLoader.isDone() && this.hqIconLoader == null && this.isHQRecommended()) {
            this.hqIconLoader = AlbumObject.iconLoaderPool.submit(() -> {
                ImageIcon hq = this.ao.getRepresentingIcon(Config.ThumbnailQuality.HQ.getBounds(), false);
                SwingUtilities.invokeLater(() -> this.setIcon(new ScaledIcon(hq, this.image)));
                return hq;
            });
        }
        if (this.editor instanceof NullEditor || this.editor instanceof DetailsEditor && !((DetailsEditor)this.editor).isRefreshed()) {
            this.remove(this.editor);
            switch (this.context.getLabelType()) {
                case details: {
                    this.remove(this.imagePanel);
                    this.add((Component)this.imagePanel, "West");
                    break;
                }
                case fileName: {
                    this.editor = new FileNameEditor(this);
                    break;
                }
                case title: {
                    this.editor = new TitleEditor(this);
                    break;
                }
                case caption: {
                    this.editor = new CaptionEditor(this);
                    break;
                }
                case keywords: {
                    this.editor = new KeywordsEditor(this);
                }
            }
            if (this.context.getLabelType() != Config.LabelType.details) {
                this.remove(this.imagePanel);
                this.add((Component)this.imagePanel, "North");
            }
            this.add((Component)this.editor, "Center");
            this.editor.setSelected(this.selected);
            this.validate();
            this.repaint();
        }
        if (this.metadataLoader == null) {
            this.metadataLoader = metadataLoaderPool.submit(() -> {
                Rectangle vr = this.getVisibleRect();
                if (vr.width > 0 && vr.height > 0) {
                    this.editor.refresh();
                    SwingUtilities.invokeLater(() -> this.northPanel.updateToolTip());
                    WordList knownKeywords = this.context.context.knownKeywords;
                    knownKeywords.addAll(StringUtil.stringToSet(this.ao.getKeywords()));
                    SwingUtilities.invokeLater(() -> this.northPanel.updateStatusIcons());
                } else {
                    this.metadataLoader = null;
                }
                return null;
            });
        }
    }

    private boolean inPathOf(AlbumObject ao) {
        for (AlbumObject current = ao; current != null; current = current.getParent()) {
            if (current != this.ao) continue;
            return true;
        }
        return false;
    }

    public Point getImageCenter() {
        Rectangle b = this.image.getBounds();
        return new Point(b.x + b.width / 2, b.y + b.height / 2);
    }

    @Override
    public void paintChildren(Graphics g) {
        this.render();
        Graphics2D g2d = (Graphics2D)g;
        super.paintChildren(g);
        boolean isFolderThumbnail = false;
        if (this.context.context.currentFolder != null) {
            AlbumObject rep = this.context.context.currentFolder.getRepresentingAlbumObject();
            isFolderThumbnail = this.inPathOf(rep);
        }
        this.northPanel.isFolderThumbnailStatus.setVisible(isFolderThumbnail);
        if (this.imageInfo != null) {
            Dimension boundingBox = this.context.context.parent.engine.getImageDim();
            int scale = this.context.context.parent.engine.getImageScale();
            double widthScale = (double)this.imageInfo.width / (double)(boundingBox.width * scale);
            double heightScale = (double)this.imageInfo.height / (double)(boundingBox.height * scale);
            double maxScale = Math.max(widthScale, heightScale);
            this.northPanel.isTooSmallStatus.setVisible(scale > 1 && maxScale < 1.0);
        }
        if (this.ao.isLink()) {
            int ypos = this.image.getHeight() - linkImage.getIconHeight();
            linkImage.paintIcon(this, g, 2, ypos);
        }
        switch (this.ao.getCategory()) {
            case folder: {
                Stamp.press(this.imagePanel, g, faintFolderIcon.getImage());
                break;
            }
            case video: {
                Stamp.press(this.imagePanel, g, playIcon.getImage());
                break;
            }
            case webLocation: {
                Stamp.press(this.imagePanel, g, weblocIcon.getImage());
                break;
            }
            case view: {
                try {
                    Stamp.press(this.imagePanel, g, ((View)this.ao.getProperties().get("view")).getIcon().getImage());
                }
                catch (NullPointerException ypos) {}
                break;
            }
            case other: 
            case audio: {
                if (!this.hasDisplayableImage) break;
                try {
                    ImageIcon icon = new ImageIcon(FileFilters.getIconFor(this.ao.getFile(), this.ao.getEngine()).toURI().toURL());
                    Stamp.press(this.imagePanel, g, icon.getImage(), 0.5f);
                    break;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (!this.ao.isIncluded()) {
            Stamp.press(this.imagePanel, g, excludedImage.getImage());
        }
    }

    public boolean isSelected() {
        return this.selected && this.isVisible();
    }

    public boolean isEditing() {
        return this.editor.isEditing();
    }

    public void setEditing(boolean editing) {
        this.render();
        this.editor.setEditing(editing);
    }

    private static DateFormat getFormatter() {
        return Config.getConfig().getDateFormatter();
    }

    public void setRubberbanded(boolean rubberbanded) {
        if (this.isVisible() && this.rubberbanded != rubberbanded) {
            this.setSelected(!this.selected);
        }
        this.rubberbanded = rubberbanded;
    }

    public void resetRubberbanded() {
        this.rubberbanded = false;
    }

    public boolean isIncluded() {
        return this.ao.isIncluded();
    }

    public void setIncluded(boolean included) throws IOException {
        this.ao.setIncluded(included);
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.editor.setSelected(selected);
        if (selected) {
            this.imagePanel.setBorder(JAlbumBorders.createSelectedImageBorder());
        } else {
            this.editor.setEditing(false);
            this.imagePanel.setBorder(JAlbumBorders.createImageBorder());
        }
        if (selected != oldSelected) {
            this.context.selectionModel.objectSelected(this, selected);
        }
    }

    public void setRenaming() {
        if (!(this.editor instanceof FileNameEditor)) {
            TemporaryFileNameEditor editor = new TemporaryFileNameEditor(this);
            editor.install();
        }
        this.setEditing(true);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " [name=" + this.ao.getName() + "]";
    }

    public void focusLost() {
        this.northPanel.infoPanel.setVisible(false);
    }

    static {
        warningIcon = Icons.small("warning-1");
        isFolderThumbnailIcon = Icons.small("folderthumb-status");
        isMediaFileIcon = Icons.small("film");
        hasImageFiltersIcon = Icons.small("edited");
        excludedEffectsIcon = Icons.small("no-filter");
        hasOriginalIcon = Icons.small("original");
        infoIcon = Icons.small("status-info");
        collaborativeIcon = Icons.small("collaborative");
        audioClipIcon = Icons.small("music-note-status");
        paperClipIcon = Icons.small("paper-clip-status");
        SCALE_X = Screen.getPrimary().getOutputScaleX();
        SCALE_Y = Screen.getPrimary().getOutputScaleY();
        excludedImage = (ImageIcon)Icons.get("exclude-64", 128);
        faintFolderIcon = (ImageIcon)Icons.get("folder_closed_faint_1", 224);
        weblocIcon = (ImageIcon)Icons.get("weblocation", 192);
        playIcon = (ImageIcon)Icons.get("play-30", 96);
        stars = new Icon[5];
        for (int i = 1; i <= 5; ++i) {
            JAlbumObject.stars[i - 1] = Icons.small("star-gray-" + i);
        }
        try {
            defaultImageIcon = new ImageIcon(new File(Config.getConfig().progDir, "res/image-small.png").toURI().toURL());
            linkImage = Platform.isMac() ? Icons.get("link-osx", 16) : Icons.get("link-windows", 16);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        metadataLoaderPool = new ThreadPoolExecutor(0, 20, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Metadata loader"));
    }

    static abstract class LabelEditor
    extends JPanel {
        protected final JAlbumObject jao;

        LabelEditor(JAlbumObject jao) {
            this.jao = jao;
        }

        abstract void refresh();

        abstract void setEditing(boolean var1);

        abstract boolean isEditing();

        abstract void setSelected(boolean var1);
    }

    private class NorthPanel
    extends JPanel
    implements PropertyChangeListener {
        private JPanel statusPanel;
        @ToolTipText(value="ui.isWebSafeToolTip")
        private JLabel isWebSafeStatus;
        @ToolTipText(value="ui.isTooSmallStatusToolTip")
        private JLabel isTooSmallStatus;
        @ToolTipText(value="ui.isFolderThumbnailToolTip")
        private JLabel isFolderThumbnailStatus;
        @ToolTipText(value="ui.isMediaFileToolTip")
        private JLabel isMediaFileStatus;
        @ToolTipText(value="ui.hasImageFiltersToolTip")
        private JLabel hasImageFiltersStatus;
        @ToolTipText(value="ui.hasExcludedEffectsToolTip")
        private JLabel hasExcludedEffectsStatus;
        @ToolTipText(value="ui.hasOriginaToolTip")
        private JLabel hasOriginalStatus;
        @ToolTipText(value="ui.notReEncodedToolTip")
        private JLabel notReEncodedStatus;
        private JLabel ratingStatus;
        private JLabel flagStatus;
        private JLabel infoStatus;
        private JLabel collaborativeStatus;
        @ToolTipText(value="ui.hasAudioClipToolTip")
        private JLabel hasAudioClipStatus;
        @ToolTipText(value="ui.hasAttachedImageToolTip")
        private JLabel hasAttachedImageStatus;
        private JPanel infoPanel;

        public NorthPanel() {
            super(new BorderLayout());
            this.statusPanel = new JPanel(new FlowLayout(2, 0, 1));
            this.isWebSafeStatus = JAlbumObject.createClickableStatusLabel(warningIcon);
            this.isTooSmallStatus = JAlbumObject.createStatusLabel(warningIcon);
            this.isFolderThumbnailStatus = JAlbumObject.createStatusLabel(isFolderThumbnailIcon);
            this.isMediaFileStatus = JAlbumObject.createStatusLabel(isMediaFileIcon);
            this.hasImageFiltersStatus = new JFiltersLabel();
            this.hasExcludedEffectsStatus = JAlbumObject.createStatusLabel(excludedEffectsIcon);
            this.hasOriginalStatus = JAlbumObject.createStatusLabel(hasOriginalIcon);
            this.notReEncodedStatus = JAlbumObject.createStatusLabel(hasOriginalIcon);
            this.ratingStatus = JAlbumObject.createStatusLabel(null);
            this.flagStatus = JAlbumObject.createStatusLabel(null);
            this.infoStatus = JAlbumObject.createStatusLabel(infoIcon);
            this.collaborativeStatus = JAlbumObject.createStatusLabel(collaborativeIcon);
            this.hasAudioClipStatus = JAlbumObject.createClickableStatusLabel(audioClipIcon);
            this.hasAttachedImageStatus = JAlbumObject.createClickableStatusLabel(paperClipIcon);
            this.infoPanel = new JFadePanel(this.infoStatus);
            this.init();
        }

        private void init() {
            this.statusPanel.setOpaque(false);
            JAlbumObject.this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!JAlbumObject.mouseOverComponent(e, JAlbumObject.this)) {
                        NorthPanel.this.infoPanel.setVisible(false);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    NorthPanel.this.infoPanel.setVisible(true);
                }
            });
            this.infoStatus.setVisible(true);
            this.infoPanel.setVisible(false);
            this.statusPanel.add(this.infoPanel);
            this.statusPanel.add(this.isWebSafeStatus);
            this.statusPanel.add(this.isTooSmallStatus);
            this.statusPanel.add(this.isFolderThumbnailStatus);
            this.statusPanel.add(this.isMediaFileStatus);
            this.statusPanel.add(this.hasImageFiltersStatus);
            this.statusPanel.add(this.hasExcludedEffectsStatus);
            this.statusPanel.add(this.ratingStatus);
            this.statusPanel.add(this.flagStatus);
            this.statusPanel.add(this.hasOriginalStatus);
            this.statusPanel.add(this.notReEncodedStatus);
            this.statusPanel.add(this.collaborativeStatus);
            this.statusPanel.add(this.hasAudioClipStatus);
            this.statusPanel.add(this.hasAttachedImageStatus);
            this.statusPanel.add(Box.createHorizontalStrut(1));
            this.setOpaque(false);
            this.add((Component)JAlbumObject.this.buttonPanel, "West");
            this.add((Component)this.statusPanel, "East");
            this.isWebSafeStatus.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JAlbumObject.this.setRenaming();
                }
            });
            this.hasAudioClipStatus.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JAudioClipPanel panel = new JAudioClipPanel(JAlbumObject.this.ao, JAlbumObject.this.context.context.parent);
                    panel.activate();
                    panel.prepareForPlay();
                }
            });
            this.hasAttachedImageStatus.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.handle(e);
                }

                private void handle(MouseEvent e) {
                    JAlbumObject.this.setSelected(true);
                    JPopupMenu popup = new JPopupMenu(Msg.get("ui.hasAttachedImageToolTip"));
                    popup.add(JAlbumObject.this.context.context.attachImageAction);
                    popup.add(JAlbumObject.this.context.context.deleteAttachedImageAction);
                    popup.show(JAlbumObject.this, e.getX(), e.getY());
                }
            });
            Msg.setTexts(this);
            JAlbumObject.this.ao.addPropertyChangeListener(this);
        }

        private void updateStatusIcons() {
            AlbumObjectProperties props;
            FilterList filterList;
            XmpManager mgr;
            int rating;
            JAlbumObject.this.hasDisplayableImage = JAlbumObject.this.ao.hasDisplayableImage();
            this.isWebSafeStatus.setVisible(!JAlbumObject.this.ao.getWebName().equals(IO.webSafe(JAlbumObject.this.ao.getWebName())));
            if (JAlbumObject.this.ao.getCategory() == Category.image) {
                try {
                    JAlbumObject.this.imageInfo = JAlbumObject.this.ao.getImageInfo();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((rating = JAlbumObject.this.ao.getRating()) > 0 && rating <= 5) {
                if (this.ratingStatus.getIcon() != stars[rating - 1]) {
                    this.ratingStatus.setIcon(stars[rating - 1]);
                    this.ratingStatus.setToolTipText(Msg.get("ui.ratingToolTip", rating));
                }
                this.ratingStatus.setVisible(true);
            } else {
                this.ratingStatus.setVisible(false);
            }
            Flag flag = JAlbumObject.this.ao.getFlag();
            if (flag != Flag.NoFlag) {
                this.flagStatus.setIcon(flag.getSelectedIcon());
                this.flagStatus.setToolTipText(flag.toString());
                this.flagStatus.setVisible(true);
            } else {
                this.flagStatus.setVisible(false);
            }
            if (JAlbumObject.this.ao.getCategory() == Category.image && (mgr = JAlbumObject.this.ao.getXmpManager()) != null) {
                try {
                    String from = mgr.getJAlbumProperty("from");
                    this.collaborativeStatus.setVisible(from != null);
                    this.collaborativeStatus.setToolTipText(Msg.get("ui.fromToolTip", from));
                }
                catch (XMPException from) {
                    // empty catch block
                }
            }
            boolean hasFilters = (filterList = (FilterList)(props = JAlbumObject.this.ao.getProperties()).get("filterList")) != null && filterList.getPosition() > 0;
            this.hasImageFiltersStatus.setVisible(hasFilters);
            this.hasExcludedEffectsStatus.setVisible(props.containsKey("excludedFilters") || JAlbumObject.this.ao.getParent().getProperties().containsKey("excludedFilters"));
            this.isMediaFileStatus.setVisible(JAlbumObject.this.ao.getCategory() == Category.video);
            if (JAlbumObject.this.ao.getCategory() == Category.video) {
                this.notReEncodedStatus.setVisible(JAlbumObject.this.ao.isIncludeOriginal());
            } else {
                this.hasOriginalStatus.setVisible(JAlbumObject.this.ao.isIncludeOriginal());
            }
            this.hasAudioClipStatus.setVisible(JAlbumObject.this.ao.getAttachments().isPresent(Attachments.Type.AUDIO));
            this.hasAttachedImageStatus.setVisible(JAlbumObject.this.ao.getAttachments().isPresent(Attachments.Type.IMAGE));
            if (this.hasAttachedImageStatus.isVisible()) {
                this.hasAttachedImageStatus.setToolTipText(Msg.get("ui.fileAttached", JAlbumObject.this.ao.getAttachments().get(Attachments.Type.IMAGE).getName()));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String type = evt.getPropertyName();
            if (null != type) {
                switch (type) {
                    case "invalidated": {
                        this.updateToolTip();
                        break;
                    }
                    case "comment": {
                        this.updateToolTip();
                        JAlbumObject.this.editor.refresh();
                        break;
                    }
                    case "name": {
                        JAlbumObject.this.editor.refresh();
                        this.updateStatusIcons();
                        this.updateToolTip();
                        break;
                    }
                    case "keywords": 
                    case "title": {
                        JAlbumObject.this.editor.refresh();
                        break;
                    }
                    case "orientation": {
                        JAlbumObject.this.iconLoader = null;
                        JAlbumObject.this.hqIconLoader = null;
                        JAlbumObject.this.repaint();
                        break;
                    }
                    case "imageUpdated": {
                        JAlbumObject.this.iconLoader = null;
                        JAlbumObject.this.hqIconLoader = null;
                        JAlbumObject.this.repaint();
                        break;
                    }
                    case "hidden": {
                        JAlbumObject.this.iconLoader = null;
                        JAlbumObject.this.hqIconLoader = null;
                        JAlbumObject.this.repaint();
                        break;
                    }
                    case "linkRepaired": {
                        JAlbumObject.this.iconLoader = null;
                        JAlbumObject.this.hqIconLoader = null;
                        JAlbumObject.this.repaint();
                        this.updateToolTip();
                        break;
                    }
                    case "properties": 
                    case "audioClipPath": {
                        this.updateStatusIcons();
                        JAlbumObject.this.context.context.applyFilter(JAlbumObject.this);
                        break;
                    }
                    case "included": {
                        JAlbumObject.this.repaint();
                        break;
                    }
                }
            }
        }

        private void updateToolTip() {
            File file = LinkFile.getResolvedTarget(JAlbumObject.this.ao);
            if (!file.exists()) {
                JAlbumObject.this.setToolTipText(Msg.get("edit.brokenLinkError", JAlbumObject.this.ao.getFile()));
                this.infoStatus.setToolTipText(null);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("<html><table>");
                sb.append("<tr><td align=\"right\">").append(Msg.get("info.category")).append(":").append("</td><td>").append(JAlbumObject.this.ao.getCategory().getPrintableName()).append("</td></tr>");
                if (JAlbumObject.this.ao.isView()) {
                    AlbumObjectProperties props = JAlbumObject.this.ao.getProperties();
                    View view = (View)props.get("view");
                    sb.append("<tr><td align=\"right\">").append(Msg.get("info.type")).append(":").append("</td><td>").append(view.getName()).append("</td></tr>");
                    sb.append("<tr><td align=\"right\">").append(Msg.get("info.source")).append(":").append("</td><td>/").append(props.get("viewSource", "")).append("</td></tr>");
                } else if (!JAlbumObject.this.ao.isFolder()) {
                    sb.append("<tr><td align=\"right\">").append(Msg.get("info.size")).append(":").append("</td><td>").append(DataSizeFormatter.groupByThousands(file.length())).append(" bytes (").append(DataSizeFormatter.formatBytes(file.length())).append(")</td></tr>");
                    try {
                        if (JAlbumObject.this.ao.getCategory() == Category.image) {
                            FileFilters.BasicImageInfo ii = JAlbumObject.this.ao.getImageInfo();
                            sb.append("<tr><td align=\"right\">").append(Msg.get("info.dim")).append(":").append("</td><td>").append(ii.width).append(" x ").append(ii.height).append("</td></tr>");
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                sb.append("<tr><td align=\"right\">").append(Msg.get("info.location")).append(":").append("</td><td>").append(LinkFile.targetOf(file)).append("</td></tr>");
                if (JAlbumObject.this.ao.getCameraDate() != 0L) {
                    sb.append("<tr><td align=\"right\">").append(Msg.get("edit.cameraDateOrdering")).append(":").append("</td><td>").append(JAlbumObject.getFormatter().format(new Date(JAlbumObject.this.ao.getCameraDate()))).append("</td></tr>");
                }
                if (JAlbumObject.this.ao.getWhenAdded() != 0L) {
                    sb.append("<tr><td align=\"right\">").append(Msg.get("info.added")).append(":").append("</td><td>").append(JAlbumObject.getFormatter().format(new Date(JAlbumObject.this.ao.getWhenAdded()))).append("</td></tr>");
                }
                sb.append("<tr><td align=\"right\">").append(Msg.get("info.modified")).append(":").append("</td><td>").append(JAlbumObject.getFormatter().format(new Date(file.lastModified()))).append("</td></tr>");
                sb.append("</table></html>");
                this.infoStatus.setToolTipText(sb.toString());
                JAlbumObject.this.setToolTipText(null);
            }
        }

        class JFiltersLabel
        extends JSilentLabel {
            public JFiltersLabel() {
                super(hasImageFiltersIcon);
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.setVisible(false);
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                FilterList filterList = (FilterList)JAlbumObject.this.ao.getProperties().get("filterList");
                boolean hasFilters = filterList != null && filterList.getPosition() > 0;
                NorthPanel.this.hasImageFiltersStatus.setVisible(hasFilters);
                if (hasFilters) {
                    List<JAlbumImageFilter> filters = filterList.getFilters();
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < filterList.getPosition(); ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(filters.get(i).getName());
                    }
                    return Msg.get("ui.hasImageFiltersToolTip") + " (" + buf.toString() + ")";
                }
                return "";
            }
        }
    }
}

