/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javax.imageio.metadata.IIOMetadata;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jalbum.browser.BrowserPanel;
import net.jalbum.component.JCardPanel;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterPipeline;
import net.jalbum.filterManager.JAlbumImageFilter;
import net.jalbum.jlibraw.RAWImageReadParam;
import net.jalbum.jprint.JPrintDialog;
import net.jalbum.projectgroups.JProjectGroupsPanel;
import net.jalbum.review.ReviewMode;
import net.jalbum.undo.EditGroup;
import net.jalbum.undo.UndoHandler;
import net.jalbum.undo.UndoableNamedEdit;
import net.jalbum.util.MonitoredWorkQueue;
import net.jalbum.util.Work;
import net.jalbum.views.AlphabeticalView;
import net.jalbum.views.CustomFilterView;
import net.jalbum.views.DateView;
import net.jalbum.views.KeywordView;
import net.jalbum.views.PlaceView;
import net.jalbum.views.RecentlyAddedView;
import net.jalbum.views.View;
import se.datadosen.component.AutoSelectingTreeCellEditor;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.FileChooser;
import se.datadosen.component.Hour;
import se.datadosen.component.JCleanToolBar;
import se.datadosen.component.JFadingText;
import se.datadosen.component.JGlassButton;
import se.datadosen.component.JMenuButton;
import se.datadosen.component.JNotification;
import se.datadosen.component.JOnOffButton;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JPlainSlider;
import se.datadosen.component.JRoundedToggleButtonGroup;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JTabButtonBar;
import se.datadosen.component.JWorkFlow;
import se.datadosen.component.JWorkFlowStep;
import se.datadosen.component.NonCollapsableJTree;
import se.datadosen.component.SmartAction;
import se.datadosen.component.ToggleAction;
import se.datadosen.component.WaitCursor;
import se.datadosen.component.WordList;
import se.datadosen.component.search.UITarget;
import se.datadosen.component.tags.JTagPicker;
import se.datadosen.explorer.AlbumObjectTransferable;
import se.datadosen.explorer.DetailsEditor;
import se.datadosen.explorer.DragGestureButtonFilter;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.ExplorerTreeTransferHandler;
import se.datadosen.explorer.FileReceivingServer;
import se.datadosen.explorer.FolderTreeNode;
import se.datadosen.explorer.HistoryNavigator;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAddressBar;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JEditPanel;
import se.datadosen.explorer.JEffectsMenu;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.JFilterBar;
import se.datadosen.explorer.JFolderPropertyPanel;
import se.datadosen.explorer.JPeekPanel;
import se.datadosen.explorer.JPreviewWindow;
import se.datadosen.explorer.JSharePanel;
import se.datadosen.explorer.JWelcomePanel;
import se.datadosen.explorer.KeywordsEditor;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.ActionTracker;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.ImageEditor;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumManager;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.JAudioClipPanel;
import se.datadosen.jalbum.JNotificationsPopup;
import se.datadosen.jalbum.JRenameDialog;
import se.datadosen.jalbum.JWebLocationEditPanel;
import se.datadosen.jalbum.LinkFileAlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.MyDesktop;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.TextEditor;
import se.datadosen.jalbum.ThumbnailFileView;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.WebLocation;
import se.datadosen.jalbum.structure.JAlphabeticalGroupingDialog;
import se.datadosen.jalbum.structure.JCalendarGroupingDialog;
import se.datadosen.jalbum.structure.JCreatorGroupingDialog;
import se.datadosen.jalbum.structure.JDateGroupingDialog;
import se.datadosen.jalbum.structure.JFlattenDialog;
import se.datadosen.jalbum.structure.JKeywordGroupingDialog;
import se.datadosen.jalbum.structure.JPlaceGroupingDialog;
import se.datadosen.jalbum.videoplayer.VideoPlayer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.AliasAction;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.MappedAction;
import se.datadosen.util.Orientation;
import se.datadosen.util.Platform;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.StringUtil;
import se.datadosen.util.WindowUtilities;
import se.datadosen.util.annotations.ActionCommand;
import se.datadosen.util.annotations.Shortcut;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JAlbumExplorer
extends JPanel
implements PropertyChangeListener,
ClipboardOwner {
    public static final int IMAGE_CACHE_SIZE = 10;
    static final KeyStroke backspace = KeyStroke.getKeyStroke(8, 0);
    static final KeyStroke cmdBackspace = KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final KeyStroke space = KeyStroke.getKeyStroke(32, 0);
    static final KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
    static final KeyStroke f2 = KeyStroke.getKeyStroke(113, 0);
    static final KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
    static final KeyStroke ctrlA = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final KeyStroke ctrlL = KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
    static final KeyStroke altEnter = KeyStroke.getKeyStroke(10, 512);
    static final KeyStroke shiftEnter = KeyStroke.getKeyStroke(10, 64);
    static final KeyStroke altGrEnter = KeyStroke.getKeyStroke(10, 128);
    static final KeyStroke ctrlAltW = KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200);
    static final KeyStroke ctrlAltF = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200);
    static final KeyStroke ctrlAltA = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200);
    static final KeyStroke ctrlAltG = KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200);
    static final KeyStroke ctrlAltP = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200);
    static final KeyStroke ctrlAltK = KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200);
    static final KeyStroke ctrlAltC = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200);
    static final KeyStroke ctrlShiftN = KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40);
    static final KeyStroke ctrlShiftA = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40);
    static final KeyStroke plus = KeyStroke.getKeyStroke('+');
    static final KeyStroke minus = KeyStroke.getKeyStroke('-');
    static final KeyStroke ctrlPlus = KeyStroke.getKeyStroke(521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final KeyStroke ctrlMinus = KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final KeyStroke ctrlNumPlus = KeyStroke.getKeyStroke(107, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final KeyStroke ctrlNumMinus = KeyStroke.getKeyStroke(109, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final KeyStroke ctrlZero = KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final KeyStroke ctrlNumZero = KeyStroke.getKeyStroke(96, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    static final int zoomStep = 10;
    public final JAlbumFrame parent;
    AlbumObject rootFolder;
    AlbumObject currentFolder;
    private List<AlbumObject> children;
    ImageCache imageCache;
    MouseAdapter mouseOnComponentAdapter;
    private FocusListener componentFocusListener;
    private MouseMotionListener mouseMotionOnComponentListener;
    private MouseAdapter mouseOnTreeAdapter;
    private Point startingPoint;
    private ScheduledFuture delayedRedraw;
    private JPrintDialog printDialog;
    Consumer<JMenu> contextMenuListener;
    private HistoryNavigator historyNavigator;
    @ToolTipText(value="ui.zoom")
    JSlider thumbZoomSlider;
    private final PropertyChangeListener orderingListener;
    private final PropertyChangeListener modelChangedListener;
    private RAWImageReadParam rawSettingsClipboard;
    private final ActionListener templateListener;
    @Text(value="add")
    @ToolTipText(value="ui.addImagesTooltip")
    @se.datadosen.util.annotations.Icon(value="16x16/add_images.svg")
    @Shortcut(value="cmd shift A")
    public Action addAction;
    @Text(value="ui.addFromDisk", postfix="...")
    @se.datadosen.util.annotations.Icon(value="16x16/disk.svg")
    Action addFromDiskAction;
    @Text(value="ui.addFromPhone", postfix="...")
    @se.datadosen.util.annotations.Icon(value="16x16/smartphone.svg")
    Action addFromPhoneAction;
    @Text(value="ui.up")
    @se.datadosen.util.annotations.Icon(value="16x16/folder-up.svg")
    public Action parentFolderAction;
    @Text(value="edit.update")
    @ActionCommand(value="browserRefresh")
    @Shortcut(value="F5")
    public Action refreshAction;
    @Text(value="edit.addressBar")
    public Action addressBarAction;
    @se.datadosen.util.annotations.Icon(value="16x16/filter.svg")
    @Text(value="edit.filterBar")
    public Action filterBarAction;
    @Text(value="ui.folderProperties")
    @se.datadosen.util.annotations.Icon(value="16x16/properties-right.svg")
    public Action folderPropertiesAction;
    public Action closeFilterBarAction;
    public Action hideExcludedAction;
    private Action renameAction;
    public Action repairLinkAction;
    public Action openAction;
    public Action showInFilesystemAction;
    @Text(value="ui.showTarget")
    public Action showTargetAction;
    private JMenuItem showTargetMenuItem;
    @Text(value="ui.explore")
    @se.datadosen.util.annotations.Icon(value="16x16/view-explore.svg")
    public Action explorerAction;
    @se.datadosen.util.annotations.Icon(value="16x16/view-edit.svg")
    public Action editModeAction;
    public Action previewAction;
    public Action shareModeAction;
    public Action reviewModeAction;
    @Text(value="ui.notifications")
    @ToolTipText(value="ui.notifications")
    public Action notificationButtonAction;
    JNotificationsPopup notificationsPopup;
    @Text(value="ui.edit")
    @se.datadosen.util.annotations.Icon(value="16x16/view-edit.svg")
    public Action propertiesAction;
    @Text(value="edit.folderThumbnail")
    @se.datadosen.util.annotations.Icon(value="16x16/folderthumb.svg")
    private Action useAsFolderThumbnailAction;
    private Action convertLinkToCopyAction;
    public Action deleteAction;
    public Action saveCopyAsAction;
    @Text(value="edit.emptyPage")
    public Action newEmptyPageAction;
    @Text(value="edit.webLocation")
    @se.datadosen.util.annotations.Icon(value="16x16/view-earth.svg")
    public Action newWebLocationAction;
    @se.datadosen.util.annotations.Icon(value="16x16/new-folder.svg")
    public Action newFolderAction;
    public Action includeSelectedAction;
    @Text(value="ui.zoomIn")
    public Action zoomInAction;
    @Text(value="ui.zoomOut")
    public Action zoomOutAction;
    @Text(value="ui.reset")
    public Action resetZoomAction;
    public ToggleAction includeOriginalAction;
    @Text(value="edit.useOriginal")
    @ToolTipText(value="edit.useOriginalToolTip")
    public ToggleAction useOriginalAction;
    public ToggleAction hideAction;
    @Text(value="edit.rotateLeftToolTip")
    @ToolTipText(value="edit.rotateLeftToolTip")
    @se.datadosen.util.annotations.Icon(value="16x16/rotate-left.svg")
    public Action rotateLeftAction;
    @Text(value="edit.rotateRightToolTip")
    @ToolTipText(value="edit.rotateRightToolTip")
    @se.datadosen.util.annotations.Icon(value="16x16/rotate-right.svg")
    public Action rotateRightAction;
    @Text(value="edit.flipCameraToolTip")
    @ToolTipText(value="edit.flipCameraToolTip")
    @se.datadosen.util.annotations.Icon(value="16x16/camera-flip.svg")
    public Action flipAction;
    @Text(value="edit.cut")
    @se.datadosen.util.annotations.Icon(value="16x16/cut.svg")
    public Action cutAction;
    @Text(value="ui.copy")
    @se.datadosen.util.annotations.Icon(value="16x16/copy.svg")
    public Action copyAction;
    @Text(value="ui.backward")
    @se.datadosen.util.annotations.Icon(value="16x16/previous.svg")
    public Action backAction;
    @Text(value="ui.forward")
    @se.datadosen.util.annotations.Icon(value="16x16/next.svg")
    public Action forwardAction;
    @Text(value="edit.paste")
    @se.datadosen.util.annotations.Icon(value="16x16/paste.svg")
    public Action pasteAction;
    @Text(value="ui.attachFile", postfix="...")
    Action attachAudioClipAction;
    @Text(value="ui.record", postfix="...")
    Action recordAudioClipAction;
    @Text(value="ui.play")
    Action playAudioClipAction;
    @Text(value="edit.delete", postfix="...")
    Action deleteAudioClipAction;
    @Text(value="ui.attachFile", postfix="...")
    Action attachImageAction;
    @Text(value="edit.delete", postfix="...")
    Action deleteAttachedImageAction;
    @Text(value="edit.showInFilesystem")
    Action revealAudioAttachment;
    @Text(value="edit.showInFilesystem")
    Action revealImageAttachment;
    @Text(value="edit.copy")
    @Shortcut(override=true)
    Action copyRAWSettingsAction;
    @Text(value="edit.paste")
    @Shortcut(override=true)
    Action pasteRAWSettingsAction;
    @Text(value="ui.reset")
    @Shortcut(override=true)
    Action resetRAWSettingsAction;
    public Action selectAllAction;
    @Text(value="ui.selectExcluded")
    public Action selectExcludedAction;
    public Action copyFiltersAction;
    public Action pasteFiltersAction;
    public Action removeFiltersAction;
    public Action invertSelectionAction;
    @Text(value="ui.details")
    @ToolTipText(value="ui.doubleClickToEdit")
    public ToggleAction detailsLabelTypeAction;
    @Text(value="ui.caption")
    public ToggleAction captionLabelTypeAction;
    @Text(value="edit.titleLabel")
    public ToggleAction titleLabelTypeAction;
    @Text(value="ui.fileName")
    public ToggleAction fileNameLabelTypeAction;
    @Text(value="edit.keywords")
    public ToggleAction keywordsLabelTypeAction;
    @Text(value="ui.applyToSubFolders")
    @ToolTipText(value="ui.applyToSubFoldersToolTip")
    public Action applyOrderingToSubFoldersAction;
    JRoundedToggleButtonGroup labelTypeButtonGroup;
    public ToggleAction orderByNameAction;
    public ToggleAction orderByLastModifiedDateAction;
    public ToggleAction orderByAddedDateAction;
    public ToggleAction orderByCameraDateAction;
    public ToggleAction orderByRatingAction;
    public ToggleAction orderByTitleAction;
    public ToggleAction orderByCommentAction;
    public ToggleAction orderByCategoryAction;
    public ToggleAction orderByExtensionAction;
    public ToggleAction customOrderingAction;
    public ToggleAction useJAlbumOrderingAction;
    public ToggleAction reverseOrderingAction;
    public ToggleAction foldersFirstAction;
    public ToggleAction orderFoldersByNameAction;
    public ToggleAction orderFoldersByLastModifiedDateAction;
    public ToggleAction orderFoldersByAddedDateAction;
    public ToggleAction reverseFolderOrderingAction;
    public Action shuffleAction;
    @Text(value="ui.attachments")
    @se.datadosen.util.annotations.Icon(value="16x16/paper-clip.svg")
    private JMenu attachementsMenu;
    @Text(value="ui.representingImage")
    @se.datadosen.util.annotations.Icon(value="16x16/paper-clip.svg")
    private JMenu representingImageMenu;
    @Text(value="ui.audioClip")
    @se.datadosen.util.annotations.Icon(value="16x16/music-note.svg")
    private JMenu audioClipMenu;
    private JMenu imageFiltersMenu;
    @Text(value="ui.rawSettings")
    private JMenu rawSettingsMenu;
    private Action includeNodeAction;
    private Action excludeNodeAction;
    private Action deleteNodeAction;
    private Action renameNodeAction;
    @Text(value="ui.labelType")
    private JMenu labelTypeSubMenu;
    @Text(value="edit.rating")
    private JMenu ratingSubMenu;
    @Text(value="edit.flag")
    private JMenu flagSubMenu;
    private JMenu orderingSubMenu;
    private JMenu folderOrderingSubMenu;
    public final JSplitPane splitPane;
    private final JScrollPane treeScrollPane;
    private final JScrollPane explorerScrollPane;
    private FileChooser addFileChooser;
    final JTree tree;
    public JProjectGroupsPanel projectGroupsPanel;
    public final JAlbumManager albumManager;
    public JCardPanel viewPanel;
    private JTabButtonBar viewModeBar;
    private final JToggleButton previewButton;
    public JPanel notificationPanel;
    public JPanel explorerCard;
    private JPreviewWindow previewWindow;
    public BrowserPanel browserPanel;
    public JSharePanel sharePanel;
    public JPanel leftPanel;
    public final WordList knownKeywords;
    public final JTagPicker tagPicker;
    public final JCleanToolBar toolBar;
    JFilterBar filterBar;
    public JFolderPropertyPanel folderPropertyPanel;
    JAddressBar addressBar;
    public JSplitPane explorerSplitPane;
    public JPanel albumsPanel;
    private JComponent notification;
    public JPanel rightPanel;
    public JPanel topPanel;
    private final JWelcomePanel welcomePanel;
    public JExplorerPanel explorer;
    final JPeekPanel peekPanel;
    public JEditPanel editor;
    JPopupMenu explorerPopup;
    JPopupMenu componentPopup;
    JPopupMenu brokenLinkPopup;
    JPopupMenu treeNodePopup;
    JMenu templatesMenu;
    @se.datadosen.util.annotations.Icon(value="16x16/eye.svg")
    @Text(value="ui.newView")
    JMenu viewsMenu;
    @Text(value="view.date", postfix="...")
    Action newDateViewAction;
    @Text(value="view.recentlyAdded", postfix="...")
    Action newRecentlyAddedViewAction;
    @Text(value="view.alphabetical")
    Action newAlphabeticalViewAction;
    @Text(value="view.keyword")
    Action newKeywordsViewAction;
    @Text(value="view.place", postfix="...")
    Action newPlaceViewAction;
    @Text(value="view.customFilter", postfix="...")
    Action newCustomFilterViewAction;
    public JCheckBoxMenuItem hideExcludedMenuItem;
    public JCheckBoxMenuItem addressBarMenuItem;
    JCheckBoxMenuItem filterBarMenuItem;
    JCheckBoxMenuItem useAsFolderThumbnailMenuItem;
    private FilterList imageFilterClipboard;
    @Text(value="ui.effectsPanel")
    private JEffectsMenu effectsMenu;
    @Text(value="edit.organize")
    private JMenu componentOrganizeMenu;
    @Text(value="edit.orderSelectedBy")
    private JMenu orderSelectedByMenu;
    @Text(value="edit.organize")
    private JMenu explorerOrganizeMenu;
    @Text(value="ui.extensions")
    public final JMenu extensionsMenu;
    public final JMenu skinContextMenu;
    @Text(value="ui.more", postfix="...")
    @se.datadosen.util.annotations.Icon(value="16x16/menu-white.svg")
    JButton glassButton;
    final RenderThread renderThread;
    Future longClickFuture;
    @Text(value="edit.exclude")
    @ToolTipText(value="edit.excludeToolTip")
    @se.datadosen.util.annotations.Icon(value="16x16/exclude.svg")
    public Action excludeSelectedAction;
    @Text(value="edit.wrapInFolder")
    public SmartAction wrapInFolderAction;
    @Text(value="edit.flatten", postfix="...")
    public SmartAction flattenAction;
    @Text(value="edit.groupAlpha", postfix="...")
    public SmartAction groupAlphabeticallyAction;
    @Text(value="edit.groupByDate", postfix="...")
    public SmartAction groupByDateAction;
    @Text(value="edit.groupByPlace", postfix="...")
    public SmartAction groupByPlaceAction;
    @Text(value="edit.groupByKeywords", postfix="...")
    public SmartAction groupByKeywordsAction;
    @Text(value="edit.groupByCreator", postfix="...")
    public SmartAction groupByCreatorAction;
    @Text(value="edit.groupByCalendar", postfix="...")
    public SmartAction groupByCalendarAction;
    @Text(value="edit.shuffleOrdering")
    public SmartAction shuffleSelectedAction;
    @Text(value="print.print", postfix="...")
    @se.datadosen.util.annotations.Icon(value="16x16/printer.svg")
    @Shortcut(value="cmd P")
    public SmartAction printAction;
    JMenuButton addButton;
    @ToolTipText(value="edit.newPage")
    @se.datadosen.util.annotations.Icon(value="16x16/new-page.svg")
    JMenuButton newPageButton;
    private boolean draggingObjects;
    private Transferable clipboardContents;
    private PropertyChangeListener rootNameChangeListener;
    private static final String LAST_LOCATION_KEY = "lastLocation";
    private PropertyChangeListener representingAlbumObjectListener;

    public void setRAWSettingsClipboard(RAWImageReadParam param) {
        this.rawSettingsClipboard = param;
        this.pasteRAWSettingsAction.setEnabled(param != null);
    }

    private void convertLinkToCopyFolder(List<AlbumObject> list, MonitoredWorkQueue queue) {
        for (AlbumObject ao : list) {
            if (!ao.isLink()) {
                if (!ao.isFolder()) continue;
                this.convertLinkToCopyFolder(ao.getChildren(), queue);
                continue;
            }
            queue.submit(() -> {
                File src = LinkFile.getResolvedTarget(ao);
                queue.setMessage(ao.getName());
                File target = new File(ao.getParent().getFile(), ao.getFile().getName());
                if (src.isDirectory()) {
                    target.mkdir();
                }
                IO.copyFile(src, target, true, Config.getConfig().isUseHardLinks());
            });
        }
    }

    private int getClosestIndex(List<JAlbumObject> list) {
        int insertIndex = -1;
        JAlbumObject head = list.get(0);
        Component[] comps = this.explorer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != head) continue;
            insertIndex = i;
            break;
        }
        if (insertIndex == -1) {
            insertIndex = comps.length;
        }
        return insertIndex;
    }

    private List<JAlbumObject> getSelectedOrAll() {
        List<JAlbumObject> selected = this.explorer.selectionModel.getSelectedObjects();
        if (selected.isEmpty()) {
            for (Component comp : this.explorer.getComponents()) {
                selected.add((JAlbumObject)comp);
            }
        }
        return selected;
    }

    public void animateWorkflow() {
        JWorkFlow workFlow = new JWorkFlow(this.welcomePanel.promptPanel);
        workFlow.addStep(new JWorkFlowStep(1, this.welcomePanel.promptPanel));
        workFlow.addStep(new JWorkFlowStep(2, this.parent.mainSettingsPanel, "makeAlbumButton"));
        workFlow.addStep(new JWorkFlowStep(3, this.parent.mainSettingsPanel, "publishButton"));
        workFlow.install(this.parent);
        workFlow.setAnimate(true);
    }

    private void createView(View view, String suggestedName) {
        int result;
        JComponent ui = view.getUserInterface(null, this);
        if (ui != null && (result = JOptionPane.showConfirmDialog(this, ui, Msg.get("ui.newView"), 2, -1)) != 0) {
            return;
        }
        try {
            int insertIndex = this.explorer.findInsertIndex();
            AlbumObject ao = this.currentFolder.createView(view, insertIndex, suggestedName);
            JAlbumObject jao = this.addJAO(insertIndex, ao);
            this.explorer.validate();
            this.explorer.repaint();
            jao.setRenaming();
            SwingUtilities.invokeLater(() -> this.explorer.scrollRectToVisible(jao.getBounds()));
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    public JAlbumExplorer(JAlbumFrame parent) {
        JAlbumContext.getInstance().setExplorer(this);
        this.startingPoint = new Point(0, 0);
        this.historyNavigator = new HistoryNavigator(this);
        this.thumbZoomSlider = new JPlainSlider(30, 170, 100);
        this.orderingListener = evt -> {
            JFadingText fadingText = new JFadingText(Msg.get("ui.orderingHint", this.currentFolder.getOrdering().toString()), this);
            fadingText.install(JAlbumContext.getInstance().getFrame());
            this.updateOrderingMenus();
        };
        this.modelChangedListener = evt -> this.redraw();
        this.templateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File skinDir = Config.getConfig().chainedSkinsDir.getFile(JAlbumExplorer.this.parent.engine.getSkin());
                File templatesDir = new File(skinDir, "templates");
                File templateFile = new File(templatesDir, ((JMenuItem)e.getSource()).getName());
                try {
                    int insertIndex = JAlbumExplorer.this.explorer.findInsertIndex();
                    AlbumObject ao = JAlbumExplorer.this.currentFolder.createPage(insertIndex, templateFile.getName(), templateFile);
                    JAlbumObject jao = JAlbumExplorer.this.addJAO(insertIndex, ao);
                    JAlbumExplorer.this.explorer.validate();
                    JAlbumExplorer.this.explorer.repaint();
                    JAlbumExplorer.this.explorer.scrollRectToVisible(jao.getBounds());
                    jao.setRenaming();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
            }
        };
        this.addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(() -> {
                    Tracer.getInstance().trace("add button clicked");
                    JAlbumExplorer.this.explorer.closestObject = null;
                    JAlbumExplorer.this.addFileChooser = ChooserFactory.createFilesChooser(JAlbumExplorer.this.parent);
                    ChooserFactory.getMyPicturesDirectory().ifPresent(dir -> JAlbumExplorer.this.addFileChooser.setCurrentDirectory((File)dir));
                    JAlbumExplorer.this.addFileChooser.setDialogTitle(Msg.get("ui.addImagesTooltip"));
                    JAlbumExplorer.this.addFileChooser.setDialogType(2);
                    JAlbumExplorer.this.addFileChooser.setFileSelectionMode(2);
                    JAlbumExplorer.this.addFileChooser.addActionListener(e1 -> {
                        if (e1.getActionCommand().equals("ApproveSelection")) {
                            Preferences prefs = Preferences.userNodeForPackage(JAlbum.class);
                            prefs.put("initialPicturesPath", JAlbumExplorer.this.addFileChooser.getCurrentDirectory().getAbsolutePath());
                            File[] selectedFiles = JAlbumExplorer.this.addFileChooser.getSelectedFiles();
                            if (selectedFiles != null && selectedFiles.length > 0) {
                                List<File> files = Arrays.asList(selectedFiles);
                                JAlbumExplorer.this.explorer.closestObject = null;
                                SwingUtilities.invokeLater(() -> JAlbumExplorer.this.explorer.handleFileAdd(files));
                                return;
                            }
                        }
                    });
                    JAlbumExplorer.this.addFileChooser.setFileView(JAlbumExplorer.this.parent.preferencesWindow.thumbnailsInFileChooser.isSelected() ? new ThumbnailFileView() : null);
                    JAlbumExplorer.this.addFileChooser.showDialog(JAlbumExplorer.this.parent, Msg.get("add"));
                }, "File chooser thread").start();
            }
        };
        this.addFromDiskAction = new AliasAction(this.addAction);
        this.addFromPhoneAction = new LambdaAction(() -> FileReceivingServer.show(this));
        this.parentFolderAction = new AbstractAction(){
            {
                this.setEnabled(false);
                this.putValue("AcceleratorKey", backspace);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JAlbumExplorer.this.currentFolder != null && JAlbumExplorer.this.currentFolder.getParent() != null) {
                    try {
                        JAlbumExplorer.this.tree.setSelectionPath(JAlbumExplorer.this.tree.getSelectionPath().getParentPath());
                    }
                    catch (Exception ex) {
                        JAlbumExplorer.this.selectNode(JAlbumExplorer.this.currentFolder.getParent());
                    }
                }
            }
        };
        this.filterBarAction = new AbstractAction(){
            {
                this.putValue("SwingSelectedKey", false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.filterBar.setVisible((Boolean)this.getValue("SwingSelectedKey"));
                if (JAlbumExplorer.this.filterBar.isVisible()) {
                    JAlbumExplorer.this.filterBar.keywordsField.requestFocusInWindow();
                }
                JAlbumExplorer.this.applyFilters();
                JAlbumExplorer.this.updateStatusBar();
            }
        };
        this.folderPropertiesAction = new AbstractAction(){
            {
                this.putValue("SwingSelectedKey", true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.getValue("SwingSelectedKey") == Boolean.TRUE) {
                    JAlbumExplorer.this.explorerSplitPane.resetToPreferredSizes();
                } else {
                    BasicSplitPaneUI ui = (BasicSplitPaneUI)JAlbumExplorer.this.explorerSplitPane.getUI();
                    JButton oneClick = (JButton)ui.getDivider().getComponent(1);
                    oneClick.doClick();
                }
            }
        };
        this.showTargetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkFileAlbumObject link;
                AlbumObject target;
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != null && selected.ao instanceof LinkFileAlbumObject && (target = (link = (LinkFileAlbumObject)selected.ao).getInternalTarget()) != null) {
                    JAlbumExplorer.this.gotoPath(target.getPathFromRoot());
                }
            }
        };
        this.showTargetMenuItem = new JMenuItem(this.showTargetAction);
        this.explorerAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setExplorerView();
            }
        };
        this.previewAction = new AbstractAction(){
            {
                Config.getConfig().addPropertyChangeListener("previewMode", evt -> {
                    this.setEnabled(Config.PreviewMode.integrated == evt.getNewValue());
                    JAlbumExplorer.this.setPreviewMode((Config.PreviewMode)((Object)((Object)evt.getNewValue())));
                });
                this.setEnabled(true);
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(JAlbumExplorer.this.isProjectLoaded() && Config.getConfig().getPreviewMode() == Config.PreviewMode.integrated);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.parent.actions.viewAlbumAction.actionPerformed(e);
            }
        };
        this.propertiesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (jao != null) {
                    if (jao.ao.getCategory() == Category.webPage && e != null) {
                        int answer;
                        if (jao.ao.getFile() instanceof LinkFile && ((LinkFile)jao.ao.getFile()).isDynamic() && (answer = JOptionPane.showConfirmDialog(JAlbumExplorer.this.parent, Msg.get("ui.editingSkinFilesWarning"), Msg.get("ui.edit"), 2, 2)) != 0) {
                            return;
                        }
                        TextEditor.openDocument(LinkFile.getResolvedTarget(jao.ao));
                    } else {
                        JAlbumExplorer.this.setEditView(jao.ao);
                    }
                } else {
                    JAlbumExplorer.this.setEditView(JAlbumExplorer.this.currentFolder);
                }
            }
        };
        this.useAsFolderThumbnailAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getFocusedObject();
                if (jao.ao == JAlbumExplorer.this.currentFolder.getRepresentingAlbumObject()) {
                    JAlbumExplorer.this.currentFolder.setRepresentingAlbumObject(null);
                } else {
                    JAlbumExplorer.this.currentFolder.setRepresentingAlbumObject(jao.ao);
                }
            }
        };
        this.convertLinkToCopyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitoredWorkQueue queue = new MonitoredWorkQueue(JAlbumExplorer.this, Msg.get("edit.convertLinkToCopy"));
                JAlbumExplorer.this.convertLinkToCopyFolder(JAlbumExplorer.this.explorer.listSelectedAlbumObjects(), queue);
                queue.awaitCompletion();
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.refreshCurrentNode();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.newEmptyPageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int insertIndex = JAlbumExplorer.this.explorer.findInsertIndex();
                    AlbumObject ao = JAlbumExplorer.this.currentFolder.createPage(insertIndex, Msg.get("edit.newPage") + ".htt");
                    JAlbumObject jao = JAlbumExplorer.this.addJAO(insertIndex, ao);
                    JAlbumExplorer.this.explorer.validate();
                    JAlbumExplorer.this.explorer.repaint();
                    JAlbumExplorer.this.explorer.scrollRectToVisible(jao.getBounds());
                    jao.setRenaming();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
            }
        };
        this.newWebLocationAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JWebLocationEditPanel.openDialog(JAlbumExplorer.this.parent, JAlbumExplorer.this.currentFolder, JAlbumExplorer.this.explorer.findInsertIndex());
            }
        };
        this.newFolderAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", ctrlShiftN);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int insertIndex = JAlbumExplorer.this.explorer.findInsertIndex();
                    int ii = !JAlbumExplorer.this.currentFolder.getOrdering().equals((Object)AlbumObject.Ordering.custom) && (e.getModifiers() & 1) != 0 ? -1 : insertIndex;
                    AlbumObject ao = JAlbumExplorer.this.currentFolder.createFolder(ii, Msg.get("edit.newFolder"));
                    JAlbumObject jao = JAlbumExplorer.this.addJAO(insertIndex, ao);
                    JAlbumExplorer.this.explorer.validate();
                    JAlbumExplorer.this.explorer.repaint();
                    JAlbumExplorer.this.refreshCurrentNode();
                    jao.setRenaming();
                    SwingUtilities.invokeLater(() -> JAlbumExplorer.this.explorer.scrollRectToVisible(jao.getBounds()));
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
            }
        };
        this.zoomInAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", ctrlPlus);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.thumbZoomSlider.setValue(JAlbumExplorer.this.thumbZoomSlider.getValue() + 10);
            }
        };
        this.zoomOutAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", ctrlMinus);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.thumbZoomSlider.setValue(JAlbumExplorer.this.thumbZoomSlider.getValue() - 10);
            }
        };
        this.resetZoomAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", ctrlZero);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.thumbZoomSlider.setValue(100);
            }
        };
        this.useOriginalAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.isSelected()) {
                    JAlbumExplorer.this.includeOriginalAction.setSelected(false);
                    JAlbumExplorer.this.includeOriginalAction.actionPerformed(e);
                }
                List<JAlbumObject> list = JAlbumExplorer.this.getSelectJAlbumObjects();
                for (JAlbumObject jao : list) {
                    Category cat = jao.ao.getCategory();
                    if (cat != Category.image && cat != Category.video) continue;
                    try {
                        jao.ao.setUseOriginal(this.isSelected());
                    }
                    catch (IOException ex) {
                        Debug.showFriendlyErrorDialog(JAlbumExplorer.this, ex);
                    }
                }
            }
        };
        this.rotateLeftAction = new LambdaAction(e -> this.adjustOrientation(false)).track();
        this.rotateRightAction = new LambdaAction(e -> this.adjustOrientation(true)).track();
        this.flipAction = new LambdaAction(e -> this.flip()).track();
        this.cutAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                List<JAlbumObject> selected = JAlbumExplorer.this.getSelectJAlbumObjects();
                JAlbumExplorer.this.explorer.initiateMove(selected);
                if (selected.size() > 0) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new AlbumObjectTransferable(JAlbumExplorer.this.explorer.listSelectedAlbumObjects()), JAlbumExplorer.this);
                }
            }
        };
        this.copyAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.resetMove();
                List<JAlbumObject> selected = JAlbumExplorer.this.getSelectJAlbumObjects();
                if (selected.size() > 0) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new AlbumObjectTransferable(JAlbumExplorer.this.explorer.listSelectedAlbumObjects()), JAlbumExplorer.this);
                }
            }
        };
        this.backAction = new AliasAction(this.historyNavigator.backAction){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 512));
            }
        };
        this.forwardAction = new AliasAction(this.historyNavigator.forwardAction){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 512));
            }
        };
        this.pasteAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.addFlavorListener(fl -> JAlbumExplorer.this.flavorChange());
                SwingUtilities.invokeLater(() -> {
                    try {
                        JAlbumExplorer.this.flavorChange();
                    }
                    catch (IllegalStateException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                });
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable t = clipboard.getContents(JAlbumExplorer.this.explorer);
                try {
                    if (JAlbumExplorer.this.explorer.isMoveInitiated()) {
                        JAlbumExplorer.this.explorer.completeMove();
                    } else if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        JAlbumExplorer.this.explorer.handleFileAdd(files);
                    } else if (clipboard.isDataFlavorAvailable(DetailsEditor.fieldFlavor)) {
                        int answer;
                        DetailsEditor.FieldClip clip = (DetailsEditor.FieldClip)t.getTransferData(DetailsEditor.fieldFlavor);
                        DetailsEditor.ReadWriteField field = clip.field;
                        int selectionCount = JAlbumExplorer.this.explorer.selectionModel.getSelectionCount();
                        if (selectionCount > 1 && (answer = JOptionPane.showConfirmDialog(JAlbumExplorer.this, Msg.get("ui.multipleOperationConfirmation", (String)this.getValue("Name"), selectionCount), (String)this.getValue("Name"), 0, 3)) != 0) {
                            return;
                        }
                        JAlbumExplorer.this.explorer.forSelected(field.type.toString(), jao -> field.saver.accept(jao.ao, clip.stringValue));
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Debug.showStackTraceDialog(JAlbumExplorer.this, ex);
                    ex.printStackTrace();
                }
            }
        };
        this.attachAudioClipAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != null) {
                    JAudioClipPanel panel = new JAudioClipPanel(selected.ao, JAlbumExplorer.this.parent);
                    panel.attachAudioClip();
                }
            }
        };
        this.recordAudioClipAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != null) {
                    JAudioClipPanel panel = new JAudioClipPanel(selected.ao, JAlbumExplorer.this.parent);
                    panel.activate();
                    panel.prepareForRecord();
                }
            }
        };
        this.playAudioClipAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != null) {
                    JAudioClipPanel panel = new JAudioClipPanel(selected.ao, JAlbumExplorer.this.parent);
                    panel.activate();
                    panel.play();
                }
            }
        };
        this.deleteAudioClipAction = new LambdaAction(() -> this.deleteAttachements(Attachments.Type.AUDIO));
        this.attachImageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != null) {
                    Attachments att = selected.ao.getAttachments();
                    FileChooser chooser = ChooserFactory.createFileChooser(JAlbumExplorer.this.parent);
                    ChooserFactory.getMyPicturesDirectory().ifPresent(dir -> chooser.setCurrentDirectory((File)dir));
                    chooser.setFileFilter(new FileNameExtensionFilter("Images", "jpg", "jpeg", "png", "gif", "avif", "heic", "webp", "tif", "tiff"));
                    int answer = chooser.showOpenDialog(JAlbumExplorer.this.parent);
                    if (answer == 0) {
                        File f = chooser.getSelectedFile();
                        File dest = new File(att.getAttachmentsDir(true), f.getName());
                        try {
                            new AlbumImage(f, JAlbumExplorer.this.parent.engine).scaleToFit(new Dimension(2000, 2000)).saveImage(dest);
                            att.set(dest, Attachments.Type.IMAGE);
                        }
                        catch (IOException ex) {
                            Debug.showErrorDialog(JAlbumExplorer.this.parent, ex);
                        }
                    }
                }
            }
        };
        this.deleteAttachedImageAction = new LambdaAction(() -> this.deleteAttachements(Attachments.Type.IMAGE));
        this.revealAudioAttachment = new LambdaAction(() -> this.revealAttachment(Attachments.Type.AUDIO));
        this.revealImageAttachment = new LambdaAction(() -> this.revealAttachment(Attachments.Type.IMAGE));
        this.copyRAWSettingsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (jao != null) {
                    try {
                        if (jao.ao.getCategory() == Category.image && jao.ao.getImageInfo().isRaw()) {
                            JAlbumExplorer.this.setRAWSettingsClipboard(((AlbumObjectImpl)jao.ao).getRAWSettings());
                        }
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JAlbumExplorer.this.parent, ex);
                    }
                }
            }
        };
        this.pasteRAWSettingsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.forSelected(Msg.get("ui.pasteRAWSettings"), jao -> {
                    if (jao.ao.getCategory() == Category.image && jao.ao.getImageInfo().isRaw()) {
                        ((AlbumObjectImpl)jao.ao).setRAWSettings(JAlbumExplorer.this.rawSettingsClipboard);
                    }
                });
                JAlbumExplorer.this.imageCache.clear();
            }
        };
        this.resetRAWSettingsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.forSelected(Msg.get("ui.pasteRAWSettings"), jao -> {
                    if (jao.ao.getCategory() == Category.image && jao.ao.getImageInfo().isRaw()) {
                        ((AlbumObjectImpl)jao.ao).setRAWSettings(null);
                    }
                });
                JAlbumExplorer.this.imageCache.clear();
            }
        };
        this.selectExcludedAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.selectionModel.selectExcluded();
            }
        };
        this.detailsLabelTypeAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.getConfig().setLabelType(Config.LabelType.details);
            }
        };
        this.captionLabelTypeAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.getConfig().setLabelType(Config.LabelType.caption);
            }
        };
        this.titleLabelTypeAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.getConfig().setLabelType(Config.LabelType.title);
            }
        };
        this.fileNameLabelTypeAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.getConfig().setLabelType(Config.LabelType.fileName);
            }
        };
        this.keywordsLabelTypeAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.getConfig().setLabelType(Config.LabelType.keywords);
            }
        };
        this.applyOrderingToSubFoldersAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlbumObject cf = JAlbumExplorer.this.getCurrentFolder();
                Work.on(JAlbumExplorer.this.currentFolder.getDescendants().parallelStream()).filter(ao -> ao.isFolder() && ao.getFile().exists()).titled(Msg.get("ui.applyToSubFolders")).forEach(ao -> {
                    ao.setOrdering(cf.getOrdering());
                    ao.setFolderOrdering(cf.getFolderOrdering());
                    ao.setFoldersFirst(cf.isFoldersFirst());
                    ao.setReverseOrdering(cf.isReverseOrdering());
                    ao.setReverseFolderOrdering(cf.isReverseFolderOrdering());
                    ao.invalidate();
                }).showResult();
            }
        };
        this.labelTypeButtonGroup = new JRoundedToggleButtonGroup(this.detailsLabelTypeAction, this.fileNameLabelTypeAction, this.titleLabelTypeAction, this.captionLabelTypeAction, this.keywordsLabelTypeAction);
        this.attachementsMenu = new JMenu();
        this.representingImageMenu = new JMenu();
        this.audioClipMenu = new JMenu();
        this.rawSettingsMenu = new JMenu();
        this.labelTypeSubMenu = new JMenu();
        this.ratingSubMenu = new JMenu();
        this.flagSubMenu = new JMenu();
        this.splitPane = new JSplitPane(1);
        this.treeScrollPane = new JScrollPane();
        this.explorerScrollPane = new JScrollPane();
        this.tree = new NonCollapsableJTree((TreeModel)null);
        this.viewPanel = new JCardPanel();
        this.viewModeBar = new JTabButtonBar();
        this.previewButton = this.viewModeBar.createToggleButton(this.previewAction);
        this.notificationPanel = new JPanel(new BorderLayout());
        this.explorerCard = new JPanel(new BorderLayout());
        this.previewWindow = new JPreviewWindow();
        this.sharePanel = new JSharePanel(JAlbumContext.getInstance());
        this.leftPanel = new JPanel(new BorderLayout());
        this.knownKeywords = new WordList();
        this.tagPicker = new JTagPicker(this.knownKeywords.getModel());
        this.toolBar = new JCleanToolBar();
        this.filterBar = new JFilterBar(this);
        this.folderPropertyPanel = new JFolderPropertyPanel(this);
        this.addressBar = new JAddressBar(this);
        this.explorerSplitPane = new JSplitPane(1, this.explorerScrollPane, this.folderPropertyPanel);
        this.albumsPanel = new JPanel(new BorderLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        this.topPanel = new JPanel(new BorderLayout());
        this.explorerPopup = new JPopupMenu();
        this.componentPopup = new JPopupMenu();
        this.brokenLinkPopup = new JPopupMenu();
        this.treeNodePopup = new JPopupMenu();
        this.templatesMenu = new JMenu();
        this.viewsMenu = new JMenu();
        this.newDateViewAction = new LambdaAction(e -> this.createView(new DateView(), Msg.get("view.dateFolderName")));
        this.newRecentlyAddedViewAction = new LambdaAction(e -> this.createView(new RecentlyAddedView(), Msg.get("view.recentlyAddedFolderName")));
        this.newAlphabeticalViewAction = new LambdaAction(e -> this.createView(new AlphabeticalView(), Msg.get("view.alphabeticalFolderName")));
        this.newKeywordsViewAction = new LambdaAction(e -> this.createView(new KeywordView(), Msg.get("view.keywordFolderName")));
        this.newPlaceViewAction = new LambdaAction(e -> this.createView(new PlaceView(), Msg.get("view.placeFolderName")));
        this.newCustomFilterViewAction = new LambdaAction(e -> this.createView(new CustomFilterView(), Msg.get("view.customFilter")));
        this.componentOrganizeMenu = new JMenu();
        this.orderSelectedByMenu = new JMenu();
        this.explorerOrganizeMenu = new JMenu();
        this.extensionsMenu = new JMenu();
        this.skinContextMenu = new JMenu();
        this.glassButton = new JGlassButton();
        this.longClickFuture = null;
        this.excludeSelectedAction = ((SmartAction)new LambdaAction(e -> {
            List<JAlbumObject> list = this.getSelectJAlbumObjects();
            JAlbumObject first = list.get(0);
            boolean include = first == null || !first.isIncluded();
            AlbumSynchronizer sync = new AlbumSynchronizer(this.parent().engine);
            this.explorer.forSelected(Msg.get("edit.exclude"), jao -> {
                if (!include) {
                    sync.delete(jao.ao);
                }
                jao.setIncluded(include);
                this.applyFilter((JAlbumObject)jao);
            });
            this.tree.repaint();
        }).track()).accelerator(minus);
        this.wrapInFolderAction = ((SmartAction)new LambdaAction(e -> {
            Tracer.getInstance().trace("Wrap in folder");
            try (EditGroup _v = new EditGroup(Msg.get("edit.wrapInFolder"));){
                List<JAlbumObject> selected = this.getSelectedOrAll();
                int insertIndex = this.getClosestIndex(selected);
                AlbumObject ao = this.currentFolder.createFolder(insertIndex, Msg.get("edit.newFolder"));
                JAlbumObject newFolder = this.addJAO(insertIndex, ao);
                newFolder.setRenaming();
                for (JAlbumObject jao : selected) {
                    jao.ao.moveTo(newFolder.ao);
                    this.explorer.remove(jao);
                }
                newFolder.ao.invalidate();
                this.explorer.validate();
                this.explorer.repaint();
                this.refreshCurrentNode();
                this.explorer.scrollRectToVisible(newFolder.getBounds());
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }).track()).accelerator(ctrlAltW);
        this.flattenAction = ((SmartAction)new LambdaAction(e -> {
            List<JAlbumObject> selectedJAO = this.getSelectedOrAll();
            List<AlbumObject> selected = selectedJAO.stream().map(jao -> jao.ao).collect(Collectors.toList());
            int insertIndex = this.getClosestIndex(selectedJAO);
            JFlattenDialog dialog = new JFlattenDialog(this.parent(), selected, this.currentFolder, insertIndex);
            dialog.setVisible(true);
        }).track()).accelerator(ctrlAltF);
        this.groupAlphabeticallyAction = ((SmartAction)new LambdaAction(e -> {
            List<JAlbumObject> selectedJAO = this.getSelectedOrAll();
            List<AlbumObject> selected = selectedJAO.stream().map(jao -> jao.ao).collect(Collectors.toList());
            int insertIndex = this.getClosestIndex(selectedJAO);
            JAlphabeticalGroupingDialog dialog = new JAlphabeticalGroupingDialog(this.parent(), selected, this.currentFolder, insertIndex);
            dialog.setVisible(true);
        }).track()).accelerator(ctrlAltA);
        this.groupByDateAction = ((SmartAction)new LambdaAction(e -> {
            List<JAlbumObject> selectedJAO = this.getSelectedOrAll();
            List<AlbumObject> selected = selectedJAO.stream().map(jao -> jao.ao).collect(Collectors.toList());
            int insertIndex = this.getClosestIndex(selectedJAO);
            JDateGroupingDialog dialog = new JDateGroupingDialog(this.parent(), selected, this.currentFolder, insertIndex);
            ((JSmartDialog)dialog).setVisible(true);
        }).track()).accelerator(ctrlAltG);
        this.groupByPlaceAction = ((SmartAction)new LambdaAction(e -> {
            List<JAlbumObject> selectedJAO = this.getSelectedOrAll();
            List<AlbumObject> selected = selectedJAO.stream().map(jao -> jao.ao).collect(Collectors.toList());
            int insertIndex = this.getClosestIndex(selectedJAO);
            JPlaceGroupingDialog dialog = new JPlaceGroupingDialog(this.parent(), selected, this.currentFolder, insertIndex);
            ((JSmartDialog)dialog).setVisible(true);
        }).track()).accelerator(ctrlAltP);
        this.groupByKeywordsAction = ((SmartAction)new LambdaAction(e -> {
            List<JAlbumObject> selectedJAO = this.getSelectedOrAll();
            List<AlbumObject> selected = selectedJAO.stream().map(jao -> jao.ao).collect(Collectors.toList());
            int insertIndex = this.getClosestIndex(selectedJAO);
            JKeywordGroupingDialog dialog = new JKeywordGroupingDialog(this.parent(), selected, this.currentFolder, insertIndex);
            dialog.setVisible(true);
        }).track()).accelerator(ctrlAltK);
        this.groupByCreatorAction = ((SmartAction)new LambdaAction(e -> {
            List<JAlbumObject> selectedJAO = this.getSelectedOrAll();
            List<AlbumObject> selected = selectedJAO.stream().map(jao -> jao.ao).collect(Collectors.toList());
            int insertIndex = this.getClosestIndex(selectedJAO);
            JCreatorGroupingDialog dialog = new JCreatorGroupingDialog(this.parent(), selected, this.currentFolder, insertIndex);
            dialog.setVisible(true);
        }).track()).accelerator(ctrlAltC);
        this.groupByCalendarAction = new LambdaAction(e -> {
            List<JAlbumObject> selectedJAO = this.getSelectedOrAll();
            List<AlbumObject> selected = selectedJAO.stream().map(jao -> jao.ao).collect(Collectors.toList());
            int insertIndex = this.getClosestIndex(selectedJAO);
            JCalendarGroupingDialog dialog = new JCalendarGroupingDialog(this.parent(), selected, this.currentFolder, insertIndex);
            dialog.setVisible(true);
        }).track();
        this.shuffleSelectedAction = new RearrangeSelectedAction(){

            @Override
            protected void rearrange(ActionEvent e, List<JAlbumObject> selected) {
                Collections.shuffle(selected);
            }
        };
        this.printAction = new LambdaAction(e -> {
            if (this.printDialog == null) {
                this.printDialog = new JPrintDialog(this.parent().context);
                this.printDialog.setLocationRelativeTo(this.parent());
            }
            if (this.explorer.getSelectedAlbumObjects().length > 0) {
                this.printDialog.setTitle(Msg.get("print.printSelected"));
            } else {
                this.printDialog.setTitle(Msg.get("print.print"));
            }
            this.printDialog.setVisible(true);
        }).track();
        this.addButton = new JMenuButton(this.addAction){

            @Override
            protected void onShowMenu() {
                this.menu.removeAll();
                this.menu.add(JAlbumExplorer.this.addFromDiskAction);
                this.menu.add(JAlbumExplorer.this.addFromPhoneAction);
                this.menu.addSeparator();
                for (Action a : JAlbumContext.getInstance().getPluginContext().getImportActions()) {
                    this.menu.add(a);
                }
            }
        };
        this.newPageButton = new JMenuButton(){
            {
                this.menu.setName(Msg.get("edit.newPage"));
            }

            @Override
            protected void onShowMenu() {
                File skinDir = Config.getConfig().chainedSkinsDir.getFile(JAlbumExplorer.this.parent.engine.getSkin());
                File templatesDir = new File(skinDir, "templates");
                this.menu.removeAll();
                this.menu.add(JAlbumExplorer.this.newWebLocationAction);
                JAlbumExplorer.this.newEmptyPageAction.setEnabled(JAlbumExplorer.this.isFullSiteSupport());
                this.menu.add(JAlbumExplorer.this.newEmptyPageAction);
                if (templatesDir.exists()) {
                    this.menu.addSeparator();
                    for (File f : templatesDir.listFiles(new TemplateFilter())) {
                        JMenuItem item = new JMenuItem(f.getName());
                        item.setName(f.getName());
                        item.addActionListener(JAlbumExplorer.this.templateListener);
                        this.menu.add(item);
                    }
                }
            }
        };
        this.draggingObjects = false;
        this.rootNameChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                String newName = pce.getNewValue().toString();
                try {
                    JAlbumExplorer.this.parent.renameImageDirectory(newName);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this.parent, ex);
                }
            }
        };
        this.parent = parent;
        this.browserPanel = new BrowserPanel(parent.context, this.previewWindow);
        this.albumManager = new JAlbumManager(parent.context, this.tree);
        this.projectGroupsPanel = new JProjectGroupsPanel(this);
        this.explorer = new JExplorerPanel(this);
        this.welcomePanel = new JWelcomePanel(this);
        this.editor = new JEditPanel(this);
        this.peekPanel = new JPeekPanel(parent);
        this.previewWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JAlbumExplorer.this.browserPanel.dispose();
            }
        });
        Rectangle bounds = this.previewWindow.getGraphicsConfiguration().getBounds();
        if (WindowUtilities.getSavedBounds(this.previewWindow) == null) {
            this.previewWindow.setSize(Math.min(bounds.width * 2 / 3, 1024), bounds.height);
        }
        new ExplorerTreeTransferHandler(this.tree, this.albumManager.getAlbumRootComponent(), this);
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.enableEvents(64L);
        this.glassButton.addActionListener(e -> {
            Container c;
            for (c = this.glassButton.getParent(); c != null && !(c instanceof JAlbumObject); c = c.getParent()) {
            }
            if (c != null) {
                JAlbumObject jao = (JAlbumObject)c;
                if (!jao.isSelected()) {
                    this.explorer.selectionModel.deselectAll();
                    jao.setSelected(true);
                    this.explorer.selectionModel.setFocusedObject(jao);
                }
                this.maybeShowPopup(new MouseEvent(jao, 0, System.currentTimeMillis(), 3, this.glassButton.getWidth() / 2, this.glassButton.getHeight() / 2, 1, true), this.componentPopup);
            }
        });
        this.glassButton.setVisible(false);
        this.renderThread = new RenderThread();
        this.renderThread.start();
    }

    private void revealAttachment(Attachments.Type type) {
        MyDesktop.getDesktop().browseFileDirectory(this.explorer.selectionModel.getSingleSelected().ao.getAttachments().get(type));
    }

    private void deleteAttachements(Attachments.Type type) {
        int answer;
        long count = this.explorer.objects().filter(jao -> jao.isSelected()).filter(jao -> jao.ao.getAttachments().isPresent(type)).count();
        List<AlbumObject> sel = this.explorer.listSelectedAlbumObjects();
        if (count > 0L && (answer = JOptionPane.showConfirmDialog(this, Msg.get("edit.deletePermanentlyInfo", count), Msg.get("edit.deleteFilesTitle"), 0, 2)) != 0) {
            return;
        }
        this.explorer.objects().filter(jao -> jao.isSelected()).map(jao -> jao.ao).filter(ao -> ao.getAttachments().isPresent(type)).forEach(ao -> ao.getAttachments().set(null, type));
    }

    private static <T extends AbstractButton> T beefUp(T b) {
        Font f = b.getFont();
        b.setFont(f.deriveFont(1));
        b.setFont(f.deriveFont(f.getSize2D() + 2.0f));
        return b;
    }

    public JComponent setNotification(JComponent notification) {
        JComponent oldNotification = this.notification;
        if (this.notification != null) {
            this.notificationPanel.remove(this.notification);
        }
        this.notification = notification;
        if (notification != null) {
            this.notificationPanel.add((Component)notification, "North");
        }
        this.rightPanel.validate();
        return oldNotification;
    }

    public JComponent getNotification() {
        return this.notification;
    }

    void flavorChange() {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            this.clipboardContents = clipboard.getContents(this);
        }
        catch (IllegalStateException ex) {
            this.clipboardContents = null;
        }
        this.updatePasteAction();
    }

    private void updatePasteAction() {
        this.pasteAction.setEnabled(this.clipboardContents != null && this.clipboardContents.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || this.clipboardContents != null && this.clipboardContents.isDataFlavorSupported(DetailsEditor.fieldFlavor) && this.explorer.selectionModel.getSelectionCount() > 0);
        if (this.clipboardContents != null && this.clipboardContents.isDataFlavorSupported(DetailsEditor.fieldFlavor)) {
            try {
                DetailsEditor.FieldClip clip = (DetailsEditor.FieldClip)this.clipboardContents.getTransferData(DetailsEditor.fieldFlavor);
                DetailsEditor.ReadWriteField field = clip.field;
                this.pasteAction.putValue("Name", Msg.get("edit.pasteSpecified", field.type.toString()));
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getLogger(JAlbumExplorer.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.pasteAction.putValue("Name", Msg.get("edit.paste"));
        }
    }

    private JAlbumFrame parent() {
        return this.parent;
    }

    private void init() throws Exception {
        this.wrapInFolderAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.flattenAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.groupByDateAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.groupByPlaceAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.groupByKeywordsAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.groupByCreatorAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.groupByCalendarAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.groupAlphabeticallyAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.printAction.enabledProperty().bind((ObservableValue)this.parent.projectLoadedProperty());
        this.setRAWSettingsClipboard(null);
        this.explorer.selectionModel.addSelectionListener(l -> this.updatePasteAction());
        this.labelTypeButtonGroup.getButtonPanel().getComponent(0).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    UITarget detailsViewFieldsTarget = new UITarget(JAlbumExplorer.this.parent.preferencesWindow.detailsViewFields);
                    detailsViewFieldsTarget.open(e);
                }
            }
        });
        this.copyFiltersAction = new AbstractAction(Msg.get("edit.copy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (jao == null || !jao.ao.hasDisplayableImage()) {
                    return;
                }
                FilterList fl = (FilterList)jao.ao.getProperties().get("filterList");
                JAlbumExplorer.this.imageFilterClipboard = FilterList.clone(fl);
            }
        };
        this.pasteFiltersAction = new AbstractAction(Msg.get("edit.paste")){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<JAlbumObject> objects = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                JAlbumExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    for (JAlbumObject jao : objects) {
                        if (!jao.ao.hasDisplayableImage()) continue;
                        AlbumObjectProperties props = jao.ao.getProperties();
                        FilterList fl = props.get("filterList", null);
                        if (fl != null) {
                            List<JAlbumImageFilter> filters = fl.getFilters();
                            for (JAlbumImageFilter filter : JAlbumExplorer.this.imageFilterClipboard.getFilters()) {
                                if (fl.findExisting(filter) != null) continue;
                                filters.add(filter);
                                fl.setPosition(fl.getPosition() + 1);
                            }
                        } else {
                            fl = FilterList.clone(JAlbumExplorer.this.imageFilterClipboard);
                        }
                        props.putHidden("filterList", fl);
                        props.store(false);
                        jao.ao.updateRepresentingIcon();
                    }
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JAlbumExplorer.this, ex);
                }
                JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.removeFiltersAction = new AbstractAction(Msg.get("remove")){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<JAlbumObject> objects = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                JAlbumExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    for (JAlbumObject jao : objects) {
                        if (!jao.ao.hasDisplayableImage()) continue;
                        AlbumObjectProperties props = jao.ao.getProperties();
                        props.remove("filterList");
                        props.store();
                        jao.ao.updateRepresentingIcon();
                    }
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JAlbumExplorer.this, ex);
                }
                JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.renameAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", f2);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                List<JAlbumObject> sel = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                if (sel.size() == 1) {
                    sel.get(0).setRenaming();
                } else if (sel.size() > 1) {
                    JRenameDialog.show(JAlbumExplorer.this.parent, sel.stream().map(jao -> jao.ao).collect(Collectors.toList()));
                }
            }
        };
        this.refreshAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.refreshAction.actionPerformed(e);
                if (JAlbumExplorer.this.browserPanel.isShowing()) {
                    JAlbumExplorer.this.browserPanel.refreshAction.actionPerformed(e);
                }
            }
        };
        this.openAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.open(JAlbumExplorer.this.explorer.selectionModel.getFocusedObject(), e.getModifiers());
            }
        };
        this.openAction.putValue("AcceleratorKey", enter);
        this.repairLinkAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.open(JAlbumExplorer.this.explorer.selectionModel.getFocusedObject(), e.getModifiers());
            }
        };
        this.showInFilesystemAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<JAlbumObject> list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                for (JAlbumObject jao : list) {
                    File dest = LinkFile.getResolvedTarget(jao.ao);
                    MyDesktop.getDesktop().browseFileDirectory(dest);
                }
            }
        };
        this.editModeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.propertiesAction.actionPerformed(e);
            }
        };
        this.shareModeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String albumURL = (String)JAlbumExplorer.this.getRootFolder().getProperties().get("albumURL");
                if (albumURL == null) {
                    JOptionPane.showMessageDialog(JAlbumExplorer.this, Msg.get("ui.notUploaded"), Msg.get("ui.errorOccured"), 0);
                    return;
                }
                String title = (String)JAlbumExplorer.this.getRootFolder().getProperties().get("title");
                if (title == null) {
                    title = JAlbumExplorer.this.getRootFolder().getName();
                }
                JAlbumExplorer.this.sharePanel.updateAlbumInformation(albumURL, title, JAlbumExplorer.this.getRootFolder().getThumbnailPath());
                JAlbumExplorer.this.viewPanel.setSelectedCard(JAlbumExplorer.this.sharePanel);
            }
        };
        this.hideExcludedAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.applyFilters();
                JAlbumExplorer.this.updateStatusBar();
            }
        };
        this.closeFilterBarAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", escape);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.filterBarAction.putValue("SwingSelectedKey", false);
                JAlbumExplorer.this.filterBarAction.actionPerformed(e);
            }
        };
        this.addressBarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.addressBar.setVisible(JAlbumExplorer.this.addressBarMenuItem.isSelected());
                JAlbumExplorer.this.parent.preferencesWindow.savePreferences();
            }
        };
        this.deleteAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", Platform.isMac() ? cmdBackspace : delete);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer;
                List<JAlbumObject> list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                if (list.isEmpty()) {
                    return;
                }
                int physicalFilesOrFoldersSelected = 0;
                for (JAlbumObject jao : list) {
                    if (jao.ao.isLink()) continue;
                    ++physicalFilesOrFoldersSelected;
                }
                if (physicalFilesOrFoldersSelected > 0 && (answer = JOptionPane.showConfirmDialog(JAlbumExplorer.this, Msg.get("edit.deletePermanentlyInfo", physicalFilesOrFoldersSelected), Msg.get("edit.deleteFilesTitle"), 0, 2)) != 0) {
                    return;
                }
                try {
                    for (JAlbumObject jao : list) {
                        jao.ao.delete();
                        JAlbumExplorer.this.explorer.remove(jao);
                    }
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                catch (PermissionException ex) {
                    JOptionPane.showMessageDialog(JAlbumExplorer.this, ex.getMessage(), Msg.get("edit.deleteFilesTitle"), 0);
                }
                JAlbumExplorer.this.explorer.validate();
                JAlbumExplorer.this.explorer.repaint();
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.saveCopyAsAction = new AbstractAction(){
            private FileChooser chooser;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getFocusedObject();
                if (this.chooser == null) {
                    this.chooser = ChooserFactory.createFileChooser(JAlbumExplorer.this.parent);
                    this.chooser.setDialogTitle(Msg.get("edit.saveCopyAs"));
                    this.chooser.setCurrentDirectory(jao.ao.getFile().getParentFile());
                }
                File proposed = new File(this.chooser.getCurrentDirectory(), jao.ao.getFile().getName());
                this.chooser.setSelectedFile(proposed);
                int returnVal = this.chooser.showSaveDialog(JAlbumExplorer.this);
                if (returnVal == 0) {
                    File newFile = this.chooser.getSelectedFile();
                    if (newFile.getName().indexOf(46) == -1) {
                        newFile = new File(newFile.getParentFile(), newFile.getName() + ".jpg");
                    }
                    boolean write = true;
                    if (newFile.exists()) {
                        int response = JOptionPane.showConfirmDialog(JAlbumExplorer.this, Msg.get("edit.fileAlreadyExistsWarning", jao.ao.getFile().getName()), Msg.get("edit.saveCopyAs"), 0);
                        boolean bl = write = response == 0;
                    }
                    if (write) {
                        JAlbumExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            BufferedImage im = (BufferedImage)jao.ao.loadImage();
                            FilterPipeline pipeline = new FilterPipeline(jao.ao);
                            im = pipeline.processFilters(im);
                            IIOMetadata meta = null;
                            try {
                                meta = FileFilters.getMetaData(jao.ao.getFile());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            FileFilters.saveImageWithWriter(im, newFile, JAlbumExplorer.this.parent.engine, meta, FileFilters.getCapableWriter(IO.extensionOf(newFile).toLowerCase()));
                            if (meta != null && jao.ao.getOrientation() != Orientation.normal) {
                                try {
                                    RotationSupport.setOrientation(1, newFile);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            MyDesktop.getDesktop().browseFileDirectory(newFile);
                        }
                        catch (IOException ex) {
                            Debug.showErrorDialog(JAlbumExplorer.this, ex);
                        }
                        finally {
                            JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
            }
        };
        this.includeSelectedAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try (EditGroup _v = new EditGroup(Msg.get("edit.include"));){
                    List<JAlbumObject> list = JAlbumExplorer.this.getSelectJAlbumObjects();
                    for (JAlbumObject jao : list) {
                        jao.setIncluded(true);
                        JAlbumExplorer.this.applyFilter(jao);
                    }
                    JAlbumExplorer.this.syncModel();
                    if (!JAlbumExplorer.this.isExplorerMode()) {
                        JAlbumExplorer.this.editor.updateImage(false);
                    } else {
                        JAlbumExplorer.this.tree.repaint();
                    }
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JAlbumExplorer.this, ex);
                }
            }
        };
        this.includeSelectedAction.putValue("AcceleratorKey", plus);
        this.registerKeyboardAction(this.excludeSelectedAction, minus, 1);
        this.browserPanel.registerKeyboardAction(this.explorerAction, "change-to-explorer-view", escape, 1);
        this.sharePanel.registerKeyboardAction(this.explorerAction, escape, 2);
        this.includeOriginalAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.isSelected()) {
                    JAlbumExplorer.this.useOriginalAction.setSelected(false);
                    JAlbumExplorer.this.useOriginalAction.actionPerformed(e);
                }
                AlbumSynchronizer sync = new AlbumSynchronizer(JAlbumExplorer.this.parent.engine);
                List<JAlbumObject> list = JAlbumExplorer.this.getSelectJAlbumObjects();
                for (JAlbumObject jao : list) {
                    Category cat = jao.ao.getCategory();
                    if (cat != Category.image && cat != Category.video) continue;
                    try {
                        jao.ao.setIncludeOriginal(this.isSelected());
                    }
                    catch (IOException ex) {
                        Debug.showFriendlyErrorDialog(JAlbumExplorer.this, ex);
                    }
                    sync.deleteOriginal(jao.ao);
                }
            }
        };
        this.hideAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlbumSynchronizer sync = new AlbumSynchronizer(JAlbumExplorer.this.parent.engine);
                List<JAlbumObject> list = JAlbumExplorer.this.getSelectJAlbumObjects();
                try {
                    for (JAlbumObject jao : list) {
                        if (!jao.ao.isFolder() && jao.ao.getCategory() != Category.webPage) continue;
                        jao.ao.setHidden(this.isSelected());
                    }
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(JAlbumExplorer.this, ex);
                }
            }
        };
        this.selectAllAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.selectionModel.selectAll();
            }
        };
        this.selectAllAction.putValue("AcceleratorKey", ctrlA);
        this.invertSelectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.selectionModel.invertSelection();
            }
        };
        this.reviewModeAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JAlbumExplorer.this.isEditMode()) {
                    JAlbumObject jao = JAlbumExplorer.this.explorer.getJAlbumObject(JAlbumExplorer.this.editor.getAO());
                    JAlbumExplorer.this.explorer.selectionModel.selectSingle(jao);
                    jao.requestFocusInWindow();
                }
                ReviewMode rm = new ReviewMode(JAlbumExplorer.this);
                rm.setVisible(true);
            }
        };
        this.orderByNameAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.name);
            }
        };
        this.orderByLastModifiedDateAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.date);
            }
        };
        this.orderByCameraDateAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.cameraDate);
            }
        };
        this.orderByAddedDateAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.addedDate);
            }
        };
        this.orderByRatingAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.rating);
            }
        };
        this.orderByTitleAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.title);
            }
        };
        this.orderByCommentAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.comment);
            }
        };
        this.orderByCategoryAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.category);
            }
        };
        this.orderByExtensionAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.extension);
            }
        };
        this.customOrderingAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.custom);
            }
        };
        this.useJAlbumOrderingAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering(AlbumObject.Ordering.jalbum);
            }
        };
        this.reverseOrderingAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JAlbumExplorer.this.currentFolder.setReverseOrdering(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.foldersFirstAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JAlbumExplorer.this.currentFolder.setFoldersFirst(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.orderFoldersByNameAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setFolderOrdering(AlbumObject.Ordering.name);
            }
        };
        this.orderFoldersByLastModifiedDateAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setFolderOrdering(AlbumObject.Ordering.date);
            }
        };
        this.orderFoldersByAddedDateAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setFolderOrdering(AlbumObject.Ordering.addedDate);
            }
        };
        this.reverseFolderOrderingAction = new ToggleAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JAlbumExplorer.this.currentFolder.setReverseFolderOrdering(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.shuffleAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                Collections.shuffle(Arrays.asList(comps));
                JAlbumExplorer.this.explorer.removeAll();
                for (Component element : comps) {
                    JAlbumExplorer.this.explorer.add(element);
                }
                JAlbumExplorer.this.explorer.validate();
                JAlbumExplorer.this.explorer.repaint();
                JAlbumExplorer.this.syncModel(Msg.get("edit.shuffleOrdering"));
                try {
                    JAlbumExplorer.this.currentFolder.setOrdering(AlbumObject.Ordering.custom);
                    JAlbumExplorer.this.customOrderingAction.setSelected(true);
                    JAlbumExplorer.this.handleDisablingOfOrderingMenus();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.includeNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JAlbumExplorer.this.currentFolder.setIncluded(true);
                    JAlbumExplorer.this.tree.repaint();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        };
        this.excludeNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JAlbumExplorer.this.currentFolder.setIncluded(false);
                    JAlbumExplorer.this.tree.repaint();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        };
        this.deleteNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AlbumObject parent = JAlbumExplorer.this.currentFolder.getParent();
                    JAlbumExplorer.this.currentFolder.delete();
                    JAlbumExplorer.this.selectNode(parent);
                    JAlbumExplorer.this.refreshCurrentNode();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                catch (PermissionException ex) {
                    JOptionPane.showMessageDialog(JAlbumExplorer.this, ex.getMessage(), Msg.get("edit.deleteFilesTitle"), 0);
                }
            }
        };
        this.renameNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.tree.startEditingAtPath(JAlbumExplorer.this.tree.getLeadSelectionPath());
            }
        };
        this.notificationButtonAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.notificationsPopup.show(JAlbumExplorer.this.parent.toolBars.notificationButton, 0, JAlbumExplorer.this.parent.toolBars.notificationButton.getHeight());
            }
        };
        this.effectsMenu = new JEffectsMenu(this.parent.context);
        this.populateOrganizeMenu(this.componentOrganizeMenu);
        this.populateOrganizeMenu(this.explorerOrganizeMenu);
        JAlbumExplorer contentPane = this;
        contentPane.setLayout(new BorderLayout());
        this.explorerSplitPane.setOneTouchExpandable(true);
        this.explorerSplitPane.setResizeWeight(1.0);
        this.explorerSplitPane.setContinuousLayout(true);
        this.explorerSplitPane.setDividerSize(8);
        this.explorerSplitPane.addPropertyChangeListener("dividerLocation", evt -> {
            int panelWidth = this.explorerSplitPane.getWidth() - this.explorerSplitPane.getDividerLocation();
            this.folderPropertiesAction.putValue("SwingSelectedKey", panelWidth > 20);
        });
        this.explorerScrollPane.setPreferredSize(new Dimension(420, 80));
        Config.getConfig().bind("explorerScrollSpeed", pce -> this.explorerScrollPane.getVerticalScrollBar().setUnitIncrement(Config.getConfig().getExplorerScrollSpeed()));
        if (Platform.isMac()) {
            this.explorerScrollPane.setVerticalScrollBarPolicy(22);
        }
        this.explorerScrollPane.setHorizontalScrollBarPolicy(31);
        this.explorer.addStructureListener(e -> {
            if (e.getObjects() != null) {
                this.syncModel(e.getMessage());
            } else {
                this.syncModel();
            }
            this.refreshFrom((FolderTreeNode)this.tree.getModel().getRoot());
            this.selectNode(this.currentFolder);
            this.updateStatusBar();
            TipOfTheDay.showSpeechBubble(this.parent.mainSettingsPanel.makeAlbumButton, new Hour(3), Msg.get("tip.updateChanges", Msg.get("ui.makeAlbum")), 8);
        });
        this.explorer.configureKeys(this.explorerScrollPane);
        this.explorer.getInputMap(0).put(space, "reviewModeAction");
        this.explorer.getActionMap().put("reviewModeAction", this.reviewModeAction);
        this.explorer.getInputMap(1).put((KeyStroke)this.backAction.getValue("AcceleratorKey"), "backAction");
        this.explorer.getActionMap().put("backAction", this.backAction);
        this.explorer.getInputMap(1).put((KeyStroke)this.forwardAction.getValue("AcceleratorKey"), "forwardAction");
        this.explorer.getActionMap().put("forwardAction", this.forwardAction);
        this.tree.getInputMap(0).put((KeyStroke)this.backAction.getValue("AcceleratorKey"), "backAction");
        this.tree.getActionMap().put("backAction", this.backAction);
        this.tree.getInputMap(0).put((KeyStroke)this.forwardAction.getValue("AcceleratorKey"), "forwardAction");
        this.tree.getActionMap().put("forwardAction", this.forwardAction);
        contentPane.add((Component)this.splitPane, "Center");
        this.treeScrollPane.getViewport().add(this.tree);
        JScrollPane sp = new JScrollPane(this.albumManager);
        sp.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JAlbumColor.border));
        sp.getVerticalScrollBar().setUnitIncrement(8);
        this.albumsPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, JAlbumColor.border));
        this.albumsPanel.add((Component)this.projectGroupsPanel, "North");
        this.albumsPanel.add((Component)sp, "Center");
        this.leftPanel.add((Component)this.albumsPanel, "Center");
        this.leftPanel.add((Component)this.parent.mainSettingsPanel, "South");
        Dimension panelDimension = new Dimension(this.parent.mainSettingsPanel.getPreferredSize().width, this.treeScrollPane.getHeight() + this.parent.mainSettingsPanel.getHeight());
        this.leftPanel.setMinimumSize(panelDimension);
        this.leftPanel.setPreferredSize(panelDimension);
        this.explorerScrollPane.setViewportView(this.explorer);
        this.explorer.setAutoscrolls(true);
        this.initToolBar();
        Box bottomStack = Box.createVerticalBox();
        JPanel explorerTop = new JPanel(new BorderLayout());
        explorerTop.add((Component)this.toolBar, "Center");
        explorerTop.add((Component)this.labelTypeButtonGroup, "East");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JAlbumColor.border));
        JPanel explorerViewPanel = new JPanel(new FlowLayout(0, 0, 3));
        explorerViewPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        southPanel.add((Component)this.addressBar, "Center");
        southPanel.add((Component)explorerViewPanel, "After");
        JOnOffButton filterBarButton = new JOnOffButton(MappedAction.nameToToolTip(this.filterBarAction));
        explorerViewPanel.add(filterBarButton);
        JOnOffButton folderPropertiesButton = new JOnOffButton(MappedAction.nameToToolTip(this.folderPropertiesAction));
        explorerViewPanel.add(folderPropertiesButton);
        explorerViewPanel.add(Box.createHorizontalStrut(10));
        this.thumbZoomSlider.addChangeListener(e -> {
            double scale = (double)this.thumbZoomSlider.getValue() / 100.0;
            this.explorer.setIconScale(scale);
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.putInt("iconScale", this.thumbZoomSlider.getValue());
        });
        this.thumbZoomSlider.setPreferredSize(new Dimension(80, 20));
        this.thumbZoomSlider.setFocusable(false);
        JPlainButton zoomOut = new JPlainButton(Icons.get("zoom-out", 12));
        zoomOut.setToolTipText("60%");
        zoomOut.addActionListener(ae -> this.thumbZoomSlider.setValue(60));
        explorerViewPanel.add(zoomOut);
        explorerViewPanel.add(this.thumbZoomSlider);
        JPlainButton zoomIn = new JPlainButton(Icons.get("zoom-in", 16));
        zoomIn.setToolTipText("100%");
        zoomIn.addActionListener(ae -> this.thumbZoomSlider.setValue(100));
        this.explorer.addMouseWheelListener(e -> {
            if ((e.getModifiersEx() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()) != 0) {
                this.thumbZoomSlider.setValue(this.thumbZoomSlider.getValue() - e.getUnitsToScroll());
            } else {
                e.getComponent().getParent().dispatchEvent(e);
            }
        });
        explorerViewPanel.add(zoomIn);
        explorerTop.add((Component)southPanel, "South");
        this.explorerCard.add((Component)explorerTop, "North");
        this.explorerCard.add((Component)this.explorerSplitPane, "Center");
        bottomStack.add(this.tagPicker);
        bottomStack.add(this.filterBar);
        this.explorerCard.add((Component)bottomStack, "South");
        this.filterBar.setVisible(false);
        this.welcomePanel.setName("welcomePanel");
        this.explorerCard.setName("explorerPanel");
        this.editor.setName("editPanel");
        this.viewPanel.add((Component)this.welcomePanel, "welcomePanel");
        this.viewPanel.add((Component)this.explorerCard, "explorerPanel");
        this.viewPanel.add((Component)this.editor, "editPanel");
        this.viewPanel.add((Component)this.sharePanel, "SharePanel");
        this.viewPanel.setFocusCycleRoot(true);
        this.explorerCard.setFocusCycleRoot(true);
        this.viewPanel.setSelectedCard(this.welcomePanel);
        this.rightPanel.add((Component)this.topPanel, "North");
        JToggleButton explorerButton = this.viewModeBar.createToggleButton(this.explorerAction);
        JToggleButton editModeButton = this.viewModeBar.createToggleButton(this.editModeAction);
        JButton reviewModeButton = this.viewModeBar.createButton(this.reviewModeAction);
        JToggleButton shareModeButton = this.viewModeBar.createToggleButton(this.shareModeAction);
        this.explorerAction.putValue("toggleButton", explorerButton);
        this.editModeAction.putValue("toggleButton", editModeButton);
        this.previewAction.putValue("toggleButton", this.previewButton);
        this.shareModeAction.putValue("toggleButton", shareModeButton);
        this.previewButton.setIcon(Icons.small("btn-view"));
        shareModeButton.setIcon(Icons.small("view-share"));
        reviewModeButton.setIcon(Icons.small("view-slideshow"));
        this.viewModeBar.add(explorerButton);
        this.viewModeBar.add(editModeButton);
        this.viewModeBar.add(reviewModeButton);
        this.viewModeBar.add(shareModeButton);
        this.topPanel.add((Component)this.viewModeBar, "West");
        this.topPanel.add(Box.createVerticalStrut(36), "Center");
        this.setPreviewMode(Config.getConfig().getPreviewMode());
        JPanel viewAndNotificationPanel = new JPanel(new BorderLayout());
        viewAndNotificationPanel.add((Component)this.viewPanel, "Center");
        viewAndNotificationPanel.add((Component)this.notificationPanel, "North");
        this.rightPanel.add((Component)viewAndNotificationPanel, "Center");
        this.splitPane.add((Component)this.leftPanel, "left");
        this.splitPane.add((Component)this.rightPanel, "right");
        this.splitPane.setDividerSize(3);
        this.topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JAlbumColor.border));
        this.treeScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JAlbumColor.border));
        this.tree.setBorder(BorderFactory.createEmptyBorder(1, Platform.isMac() ? 6 : 2, 1, 1));
        this.viewPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JAlbumColor.border));
        contentPane.setBorder(null);
        this.splitPane.setBorder(null);
        this.explorerScrollPane.setBorder(null);
        this.parent.getNotificationManager().addPropertyChangeListener("oldNotificationsList", evt -> SwingUtilities.invokeLater(this.notificationsPopup::updateNotifications));
        this.parent.getNotificationManager().addPropertyChangeListener("newActiveNotification", evt -> JAlbumUtilities.runOnAWT(() -> this.setNotification((JNotification)evt.getNewValue())));
        this.explorer.getInputMap(1).put(backspace, "parentFolder");
        this.explorer.getActionMap().put("parentFolder", this.parentFolderAction);
        this.explorer.registerKeyboardAction(this.renameAction, "editNameAction", f2, 1);
        this.explorer.registerKeyboardAction(this.openAction, "openAction", enter, 1);
        this.explorer.registerKeyboardAction(this.openAction, "openAction", shiftEnter, 1);
        this.editor.registerKeyboardAction(this.openAction, "openAction", shiftEnter, 1);
        this.explorer.registerKeyboardAction(this.newFolderAction, "newFolderAction", ctrlShiftN, 1);
        this.explorer.registerKeyboardAction(this.propertiesAction, "propertiesAction", altEnter, 2);
        this.explorer.registerKeyboardAction(this.deleteAction, "deleteAction", Platform.isMac() ? cmdBackspace : delete, 1);
        this.explorer.registerKeyboardAction(this.closeFilterBarAction, "closeFilterBarAction", escape, 2);
        this.explorer.registerKeyboardAction(this.includeSelectedAction, "includeSelectedAction", plus, 2);
        this.explorer.registerKeyboardAction(this.excludeSelectedAction, "excludeSelectedAction", minus, 2);
        this.explorer.registerKeyboardAction(this.zoomInAction, "zoomIn", ctrlPlus, 2);
        this.explorer.registerKeyboardAction(this.zoomOutAction, "zoomOut", ctrlMinus, 2);
        this.explorer.registerKeyboardAction(this.zoomInAction, "zoomIn", ctrlNumPlus, 2);
        this.explorer.registerKeyboardAction(this.zoomOutAction, "zoomOut", ctrlNumMinus, 2);
        this.explorer.registerKeyboardAction(this.resetZoomAction, "resetZoom", ctrlZero, 2);
        this.explorer.registerKeyboardAction(this.resetZoomAction, "resetZoom", ctrlNumZero, 2);
        this.componentPopup.add(this.openAction);
        this.componentPopup.add(this.propertiesAction);
        this.componentPopup.add(this.cutAction);
        this.componentPopup.add(this.copyAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.showInFilesystemAction);
        this.componentPopup.add(this.showTargetMenuItem);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.extensionsMenu);
        this.componentPopup.addSeparator();
        this.useAsFolderThumbnailMenuItem = new JCheckBoxMenuItem(this.useAsFolderThumbnailAction);
        this.componentPopup.add(this.useAsFolderThumbnailMenuItem);
        this.componentPopup.addSeparator();
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.foldersFirst));
        this.orderSelectedByMenu.addSeparator();
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.name));
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.date));
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.cameraDate));
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.addedDate));
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.rating));
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.title));
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.comment));
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.category));
        this.orderSelectedByMenu.add(new OrderSelectedAction(AlbumObject.Ordering.extension));
        this.orderSelectedByMenu.add(this.shuffleSelectedAction);
        this.componentPopup.add(this.componentOrganizeMenu);
        this.componentPopup.add(this.orderSelectedByMenu);
        this.componentPopup.addSeparator();
        this.representingImageMenu.add(new ActionTracker(this.attachImageAction));
        this.representingImageMenu.add(new ActionTracker(this.deleteAttachedImageAction));
        this.audioClipMenu.add(new ActionTracker(this.attachAudioClipAction));
        this.audioClipMenu.add(new ActionTracker(this.recordAudioClipAction));
        this.audioClipMenu.add(new ActionTracker(this.playAudioClipAction));
        this.audioClipMenu.add(new ActionTracker(this.deleteAudioClipAction));
        this.attachementsMenu.add(this.representingImageMenu);
        this.attachementsMenu.add(this.audioClipMenu);
        this.componentPopup.add(this.attachementsMenu);
        this.rawSettingsMenu.add(this.copyRAWSettingsAction);
        this.rawSettingsMenu.add(this.pasteRAWSettingsAction);
        this.rawSettingsMenu.add(this.resetRAWSettingsAction);
        this.componentPopup.add(this.rawSettingsMenu);
        this.imageFiltersMenu = new JMenu(Msg.get("edit.filtersHeading"));
        this.imageFiltersMenu.add(this.copyFiltersAction);
        this.imageFiltersMenu.add(this.pasteFiltersAction);
        this.imageFiltersMenu.add(this.removeFiltersAction);
        this.componentPopup.add(this.imageFiltersMenu);
        this.componentPopup.add(this.effectsMenu);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.excludeSelectedAction);
        this.componentPopup.add(this.hideAction.createJCheckBoxMenuItem());
        this.componentPopup.add(this.includeOriginalAction.createJCheckBoxMenuItem());
        this.componentPopup.add(this.useOriginalAction.createJCheckBoxMenuItem());
        for (JMenuItem item : this.createRatingItems()) {
            this.ratingSubMenu.add(item);
        }
        this.componentPopup.add(this.ratingSubMenu);
        for (JMenuItem item : this.createFlagItems()) {
            this.flagSubMenu.add(item);
        }
        this.componentPopup.add(this.flagSubMenu);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.printAction);
        this.componentPopup.add(this.saveCopyAsAction);
        this.componentPopup.add(this.convertLinkToCopyAction);
        this.componentPopup.add(this.deleteAction);
        this.componentPopup.add(this.renameAction);
        this.brokenLinkPopup.add(this.repairLinkAction);
        this.brokenLinkPopup.add(this.invertSelectionAction);
        this.brokenLinkPopup.addSeparator();
        this.brokenLinkPopup.add(this.excludeSelectedAction);
        this.brokenLinkPopup.addSeparator();
        this.brokenLinkPopup.add(this.deleteAction);
        this.brokenLinkPopup.add(this.renameAction);
        this.explorerPopup.add(this.backAction);
        this.explorerPopup.add(this.forwardAction);
        this.explorerPopup.addSeparator();
        this.explorerPopup.add(this.pasteAction);
        this.explorerPopup.add(this.selectAllAction);
        this.explorerPopup.add(this.selectExcludedAction);
        this.explorerPopup.add(this.invertSelectionAction);
        this.explorerPopup.add(this.reviewModeAction);
        this.explorerPopup.addSeparator();
        this.addressBarMenuItem = new JCheckBoxMenuItem(this.addressBarAction);
        this.addressBarMenuItem.setModel(this.parent.preferencesWindow.addressBar.getModel());
        this.addressBar.setVisible(this.addressBarMenuItem.isSelected());
        this.filterBarMenuItem = new JCheckBoxMenuItem(MappedAction.noIcon(this.filterBarAction));
        this.explorerPopup.add(this.addressBarMenuItem);
        this.explorerPopup.add(this.filterBarMenuItem);
        for (JMenuItem item : this.createLabelTypeItems()) {
            this.labelTypeSubMenu.add(item);
        }
        this.explorerPopup.add(this.labelTypeSubMenu);
        this.hideExcludedMenuItem = new JCheckBoxMenuItem(this.hideExcludedAction);
        this.explorerPopup.add(this.hideExcludedMenuItem);
        this.explorerPopup.addSeparator();
        this.explorerPopup.add(this.explorerOrganizeMenu);
        this.orderingSubMenu = new JMenu();
        this.folderOrderingSubMenu = new JMenu();
        this.populateOrderingSubMenu(this.orderingSubMenu);
        this.populateFolderOrderingSubMenu(this.folderOrderingSubMenu);
        this.explorerPopup.add(this.orderingSubMenu);
        this.explorerPopup.add(this.folderOrderingSubMenu);
        this.explorerPopup.addSeparator();
        this.viewsMenu.add(this.newRecentlyAddedViewAction);
        this.viewsMenu.add(this.newAlphabeticalViewAction);
        this.viewsMenu.add(this.newDateViewAction);
        this.viewsMenu.add(this.newPlaceViewAction);
        this.viewsMenu.add(this.newKeywordsViewAction);
        this.viewsMenu.add(this.newCustomFilterViewAction);
        this.explorerPopup.add(this.viewsMenu);
        this.explorerPopup.add(this.templatesMenu);
        this.explorerPopup.add(this.newFolderAction);
        this.explorerPopup.addSeparator();
        this.explorerPopup.add(this.refreshAction);
        this.explorerPopup.addSeparator();
        this.explorerPopup.add(this.propertiesAction);
        this.treeNodePopup.add(this.excludeNodeAction);
        this.treeNodePopup.add(this.includeNodeAction);
        this.treeNodePopup.add(this.deleteNodeAction);
        this.treeNodePopup.add(this.renameNodeAction);
        this.treeNodePopup.addSeparator();
        this.treeNodePopup.add(this.propertiesAction);
        Msg.maintainTranslated(this);
        this.setTexts();
        MouseAdapter mouseOnExplorerAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 4 && !Platform.isLinux()) {
                    JAlbumExplorer.this.historyNavigator.backAction.actionPerformed(null);
                    e.consume();
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                    JAlbumExplorer.this.startingPoint = e.getPoint();
                    JAlbumExplorer.this.explorer.rubberband = new Rectangle(JAlbumExplorer.this.startingPoint);
                    if (!JAlbumExplorer.isPortableControlDown(e) && !e.isShiftDown()) {
                        JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    }
                    JAlbumExplorer.this.maybeShowPopup(e, JAlbumExplorer.this.explorerPopup);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                    Component[] comps;
                    JAlbumExplorer.this.explorer.rubberband = null;
                    JAlbumExplorer.this.explorer.repaint();
                    for (Component element : comps = JAlbumExplorer.this.explorer.getComponents()) {
                        JAlbumObject jao = (JAlbumObject)element;
                        jao.resetRubberbanded();
                    }
                    JAlbumExplorer.this.maybeShowPopup(e, JAlbumExplorer.this.explorerPopup);
                }
            }
        };
        this.explorer.addMouseListener(mouseOnExplorerAdapter);
        MouseMotionAdapter mouseMotionOnExplorerAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                    if (JAlbumExplorer.this.explorer.rubberband == null) {
                        JAlbumExplorer.this.explorer.rubberband = new Rectangle(e.getPoint());
                    }
                    JAlbumExplorer.points2rect(JAlbumExplorer.this.startingPoint, e.getPoint(), JAlbumExplorer.this.explorer.rubberband);
                    JAlbumExplorer.this.explorer.scrollRectToVisible(new Rectangle(e.getPoint()));
                    Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                    Rectangle cr = new Rectangle();
                    for (Component element : comps) {
                        JAlbumObject jao = (JAlbumObject)element;
                        cr.x = jao.getX();
                        cr.y = jao.getY();
                        cr.width = jao.getWidth();
                        cr.height = jao.getHeight();
                        Rectangle intersection = JAlbumExplorer.this.explorer.rubberband.intersection(cr);
                        jao.setRubberbanded(intersection.width > cr.width / 4 && intersection.height > cr.height / 4);
                    }
                    JAlbumExplorer.this.explorer.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JAlbumExplorer.this.glassButton.setVisible(false);
                JAlbumObject jao = JAlbumExplorer.this.getJAlbumObjectParent(JAlbumExplorer.this.glassButton);
                if (jao != null) {
                    jao.focusLost();
                }
            }
        };
        this.explorer.addMouseMotionListener(mouseMotionOnExplorerAdapter);
        this.mouseMotionOnComponentListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                    JAlbumExplorer.this.draggingObjects = true;
                    JAlbumObject jao = (JAlbumObject)e.getComponent();
                    if (!jao.isSelected()) {
                        jao.setSelected(true);
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                jao.attachGlassButton(JAlbumExplorer.this.glassButton);
            }
        };
        this.mouseOnComponentAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 4 && !Platform.isLinux()) {
                    JAlbumExplorer.this.historyNavigator.backAction.actionPerformed(null);
                    e.consume();
                    return;
                }
                JAlbumExplorer.this.draggingObjects = false;
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected = jao.isSelected();
                if (e.isShiftDown()) {
                    int clickedIndex = JAlbumExplorer.this.explorer.selectionModel.indexOf(jao);
                    JAlbumExplorer.this.explorer.selectionModel.selectRange(JAlbumExplorer.this.explorer.selectionModel.lastClickedIndex, clickedIndex);
                } else if (!(JAlbumExplorer.isPortableControlDown(e) && !SwingUtilities.isRightMouseButton(e) || jao.isSelected())) {
                    JAlbumExplorer.this.explorer.selectionModel.selectSingle(jao);
                }
                if (!JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected && jao.isSelected()) {
                    JAlbumExplorer.this.explorer.selectionModel.setFocusedObject(jao);
                }
                if (!e.isShiftDown()) {
                    JAlbumExplorer.this.explorer.selectionModel.lastClickedIndex = JAlbumExplorer.this.explorer.selectionModel.indexOf(jao);
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (JAlbumExplorer.this.peekPanel.isShowing()) {
                        try {
                            JAlbumExplorer.this.peekPanel.setImage(JAlbumExplorer.this.imageCache.getImage(jao.ao), jao);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(JAlbumExplorer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        if (JAlbumExplorer.this.longClickFuture != null) {
                            JAlbumExplorer.this.longClickFuture.cancel(true);
                        }
                        JAlbumExplorer.this.longClickFuture = JAlbumUtilities.schedule(() -> {
                            try {
                                if (JAlbumExplorer.this.explorer.selectionModel.getSelectionCount() == 1) {
                                    JAlbumExplorer.this.peekPanel.setImage(new FilterPipeline(jao.ao).processFilters((BufferedImage)JAlbumExplorer.this.imageCache.getImage(jao.ao)), jao);
                                    JAlbumExplorer.this.peekPanel.activate();
                                }
                            }
                            catch (IOException ex) {
                                Logger.getLogger(JAlbumExplorer.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }, 500L, TimeUnit.MILLISECONDS);
                    }
                }
                JAlbumExplorer.this.maybeShowPopup(e, JAlbumExplorer.this.componentPopup);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JAlbumExplorer.this.longClickFuture != null) {
                    JAlbumExplorer.this.longClickFuture.cancel(true);
                    if (JAlbumExplorer.this.peekPanel.isShowing()) {
                        JAlbumExplorer.this.peekPanel.close();
                        return;
                    }
                }
                if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                    JAlbumObject jao = (JAlbumObject)e.getComponent();
                    if (SwingUtilities.isLeftMouseButton(e) && !JAlbumExplorer.this.draggingObjects) {
                        if (JAlbumExplorer.isPortableControlDown(e)) {
                            jao.setSelected(!jao.isSelected());
                        } else if (!e.isShiftDown()) {
                            JAlbumExplorer.this.explorer.selectionModel.selectSingle(jao);
                        }
                    }
                    if (!(JAlbumExplorer.this.maybeShowPopup(e, JAlbumExplorer.this.componentPopup) || JAlbumExplorer.isPortableControlDown(e) || e.isShiftDown())) {
                        Point p = e.getPoint();
                        if (jao.editor != null && jao.editor.getBounds().contains(p) && JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected) {
                            if (e.isAltDown()) {
                                jao.setRenaming();
                            } else {
                                jao.setEditing(true);
                            }
                        }
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                if (!(e.getClickCount() != 2 || JAlbumExplorer.isPortableControlDown(e) || e.isShiftDown() || SwingUtilities.isRightMouseButton(e) || jao.editor.getBounds().contains(e.getPoint()))) {
                    JAlbumExplorer.this.open(jao, e.getModifiersEx());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                Point p = e.getPoint();
                p.translate(jao.getX(), jao.getY());
                if (!jao.getBounds().contains(p)) {
                    JAlbumExplorer.this.glassButton.setVisible(false);
                    Container c = JAlbumExplorer.this.glassButton.getParent();
                    if (c != null) {
                        c.remove(JAlbumExplorer.this.glassButton);
                    }
                }
            }
        };
        this.mouseOnTreeAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try (WaitCursor.WaitToken _wt = JAlbumExplorer.this.parent.waitCursor.getToken();){
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    TreePath path = JAlbumExplorer.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (e.getButton() != 1) {
                        JAlbumExplorer.this.tree.getSelectionModel().setSelectionPath(path);
                    }
                    if (e.isPopupTrigger() && JAlbumExplorer.this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                        JAlbumExplorer.this.treeNodePopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreePath tp = JAlbumExplorer.this.tree.getClosestPathForLocation(e.getX(), e.getY());
                if (tp != null) {
                    boolean rootSelected = tp.getPathCount() == 1;
                    JAlbumExplorer.this.includeNodeAction.setEnabled(!rootSelected);
                    JAlbumExplorer.this.excludeNodeAction.setEnabled(!rootSelected);
                    JAlbumExplorer.this.propertiesAction.setEnabled(JAlbumExplorer.this.tree.getSelectionCount() < 2);
                    JAlbumExplorer.this.editModeAction.setEnabled(JAlbumExplorer.this.tree.getSelectionCount() == 1);
                    JAlbumExplorer.this.deleteNodeAction.setEnabled(!rootSelected);
                    if (!JAlbumExplorer.this.isPreviewTabShowing() || !rootSelected) {
                        JAlbumExplorer.this.setExplorerView();
                    }
                    if (e.isPopupTrigger() && JAlbumExplorer.this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                        JAlbumExplorer.this.treeNodePopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && JAlbumExplorer.this.tree.getPathForLocation(e.getX(), e.getY()) == null) {
                    JAlbumExplorer.this.parent.actions.settingsAction.actionPerformed(null);
                }
            }
        };
        this.componentFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getSource();
                if (jao == JAlbumExplorer.this.explorer.selectionModel.getFocusedObject()) {
                    return;
                }
                JAlbumExplorer.this.explorer.scrollRectToVisible(jao.getBounds());
                JAlbumExplorer.this.explorer.selectionModel.setFocusedObject(jao);
                if (jao.isSelected()) {
                    return;
                }
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != jao) {
                    MouseEvent me = new MouseEvent(jao, -1, 0L, 0, 0, 0, 1, false);
                    JAlbumExplorer.this.mouseOnComponentAdapter.mousePressed(me);
                    if (JAlbumObject.tabCycling) {
                        jao.setEditing(true);
                        JAlbumObject.tabCycling = false;
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getSource();
            }
        };
        DefaultTreeCellRenderer folderRenderer = new DefaultTreeCellRenderer(){
            private Icon albumIcon = Icons.small("book");
            Icon loadingIcon = Icons.small("elipsis");
            {
                this.setBackgroundNonSelectionColor(JAlbumColor.albumHighlight);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JComponent renderer = (JComponent)super.getTreeCellRendererComponent(tree, value, selected, expanded, false, row, hasFocus);
                if (value instanceof FolderTreeNode) {
                    FolderTreeNode node = (FolderTreeNode)value;
                    AlbumObject ao = node.getAlbumObject();
                    if (ao.getName().length() == 0) {
                        return new JLabel();
                    }
                    if (node.isRoot()) {
                        this.setIcon(this.albumIcon);
                    }
                    do {
                        if (ao.isIncluded()) continue;
                        renderer.setForeground(JAlbumColor.textInactiveText);
                        break;
                    } while ((ao = ao.getParent()) != null);
                }
                return renderer;
            }
        };
        this.tree.setCellRenderer(folderRenderer);
        AutoSelectingTreeCellEditor editor = new AutoSelectingTreeCellEditor(this.tree, folderRenderer);
        editor.rootEditable = true;
        this.tree.setCellEditor(editor);
        this.tree.addTreeSelectionListener(e -> {
            FolderTreeNode node = (FolderTreeNode)e.getPath().getLastPathComponent();
            AlbumObject ao = node.getAlbumObject();
            if (ao != this.currentFolder) {
                try (WaitCursor.WaitToken _wt = this.parent.waitCursor.getToken();){
                    this.viewFolder(ao);
                }
            }
        });
        this.tree.addMouseListener(this.mouseOnTreeAdapter);
        this.imageCache = new ImageCache(10, new Dimension(640, 480));
        this.editor.imageComp.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JAlbumExplorer.this.imageCache = new ImageCache(10, e.getComponent().getSize());
            }
        });
        this.explorer.selectionModel.addSelectionListener(model -> {
            int selCount = model.getSelectionCount();
            boolean selected = selCount > 0;
            this.cutAction.setEnabled(selected);
            this.copyAction.setEnabled(selected);
            this.includeSelectedAction.setEnabled(selected);
            this.excludeSelectedAction.setEnabled(selected);
            this.deleteAction.setEnabled(selected);
            JAlbumObject jao = model.getSingleSelected();
            if (jao != null) {
                this.updateRotateActions(jao.ao);
                this.useAsFolderThumbnailAction.setEnabled(jao.ao.hasDisplayableImage() || jao.ao.isFolder());
                this.imageFiltersMenu.setEnabled(!jao.ao.isFolder() && jao.ao.hasDisplayableImage());
                this.saveCopyAsAction.setEnabled(!jao.ao.isFolder() && jao.ao.isDisplayableImage());
                this.copyFiltersAction.setEnabled(!jao.ao.isFolder() && jao.ao.hasDisplayableImage());
            } else {
                this.imageFiltersMenu.setEnabled(selected);
                this.rotateLeftAction.setEnabled(selected);
                this.rotateRightAction.setEnabled(selected);
                this.flipAction.setEnabled(selected);
                this.useAsFolderThumbnailAction.setEnabled(false);
                this.saveCopyAsAction.setEnabled(false);
                this.copyFiltersAction.setEnabled(false);
            }
            EnumSet<Category> allowedCategories = EnumSet.of(Category.image, Category.video, Category.webPage, Category.other);
            this.attachAudioClipAction.setEnabled(selCount == 1 && allowedCategories.contains((Object)jao.ao.getCategory()));
            this.recordAudioClipAction.setEnabled(selCount == 1 && allowedCategories.contains((Object)jao.ao.getCategory()));
            this.playAudioClipAction.setEnabled(selCount == 1 && jao.ao.getAttachments().isPresent(Attachments.Type.AUDIO));
            this.deleteAudioClipAction.setEnabled(selCount > 0);
            this.deleteAttachedImageAction.setEnabled(selCount > 0);
            this.editModeAction.setEnabled(model.getSelectionCount() == 1);
            this.propertiesAction.setEnabled(model.getSelectionCount() <= 1);
            this.updateStatusBar(model);
        });
        Config.getConfig().addPropertyChangeListener("videoSupported", evt -> {
            if (this.currentFolder != null) {
                this.redraw();
            }
        });
        Config.getConfig().addPropertyChangeListener("labelType", evt -> {
            this.parent.preferencesWindow.savePreferences();
            if (this.currentFolder != null) {
                this.explorer.objects().forEach(jao -> jao.setupViewMode());
                this.validate();
                this.explorer.repaint();
            }
        });
        this.notificationsPopup = new JNotificationsPopup(this.parent.getNotificationManager());
        PropertyChangeListener updateListView = pce -> {
            if (this.explorer.getLabelType() == Config.LabelType.details && this.isProjectLoaded()) {
                this.viewFolder(this.currentFolder);
            }
        };
        this.parent.preferencesWindow.addPropertyChangeListener("listViewFields", updateListView);
        Config.getConfig().addPropertyChangeListener("language", updateListView);
        Config.getConfig().addPropertyChangeListener("datePattern", pce -> this.viewFolder(this.currentFolder));
        Config.getConfig().addPropertyChangeListener("thumbnailQuality", pce -> this.explorer.repaint());
        this.parent.addPropertyChangeListener("skinLoaded", pce -> this.explorer.objects().forEach(jao -> {
            if (jao.ao.getCategory() == Category.webPage) {
                jao.refresh();
            }
        }));
        JAlbumUtilities.schedule(() -> {
            if (!TipOfTheDay.isShowingNotification()) {
                TipOfTheDay.showInBackground(Msg.get("tip.longClick"));
            }
        }, 60L, TimeUnit.SECONDS);
        this.explorer.registerKeyboardAction(this.rotateLeftAction, (KeyStroke)this.rotateLeftAction.getValue("AcceleratorKey"), 1);
        this.explorer.registerKeyboardAction(this.rotateRightAction, (KeyStroke)this.rotateRightAction.getValue("AcceleratorKey"), 1);
    }

    public void onContextMenu(Consumer<JMenu> listener) {
        if (listener != null) {
            this.skinContextMenu.setText(this.parent.engine.getSkin());
            this.componentPopup.add((Component)this.skinContextMenu, 7);
            this.componentPopup.add((Component)new JSeparator(), 8);
        } else if (this.contextMenuListener != null) {
            this.componentPopup.remove(7);
            this.componentPopup.remove(7);
        }
        this.contextMenuListener = listener;
    }

    private JAlbumObject getJAlbumObjectParent(Component comp) {
        while (comp != null) {
            if (comp instanceof JAlbumObject) {
                return (JAlbumObject)comp;
            }
            comp = comp.getParent();
        }
        return null;
    }

    void setTopBarActionsEnabled(boolean enabled) {
        this.rotateLeftAction.setEnabled(enabled);
        this.rotateRightAction.setEnabled(enabled);
        this.flipAction.setEnabled(enabled);
        this.includeSelectedAction.setEnabled(enabled);
        this.excludeSelectedAction.setEnabled(enabled);
    }

    public void updateStatusBar() {
        this.updateStatusBar(this.explorer.selectionModel);
    }

    void updateStatusBar(ExplorerSelectionModel selectionModel) {
        Component[] comps;
        int total = this.explorer.getComponentCount();
        int excluded = 0;
        int visible = 0;
        for (Component element : comps = this.explorer.getComponents()) {
            JAlbumObject jao = (JAlbumObject)element;
            if (!jao.ao.isIncluded()) {
                ++excluded;
            }
            if (!jao.isVisible()) continue;
            ++visible;
        }
        total -= excluded;
        int selected = selectionModel.getSelectedObjects().size();
        if (selected == 0) {
            String s = visible + " " + Msg.get("ui.objects");
            if (excluded > 0) {
                s = s + " (" + excluded + " " + Msg.get("ui.excluded") + ")";
            }
            this.parent.statusBar.setText(s);
        } else {
            this.parent.statusBar.setText(selected + " " + Msg.get("ui.objectsSelected"));
        }
        if (visible == 0 && total > 0) {
            this.explorer.setBackgroundText(Msg.get("ui.noMatchingItems"));
        } else {
            this.explorer.setBackgroundText(null);
        }
    }

    private List<JAlbumObject> getSelectJAlbumObjects() {
        if (this.isExplorerMode()) {
            return this.explorer.selectionModel.getSelectedObjects();
        }
        ArrayList<JAlbumObject> list = new ArrayList<JAlbumObject>();
        list.add(new JAlbumObject(this.editor.ao, this.explorer));
        return list;
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        return this.componentPopup;
    }

    void updateOrderingMenus() {
        if (this.currentFolder != null) {
            switch (this.currentFolder.getOrdering()) {
                case name: {
                    this.orderByNameAction.setSelected(true);
                    break;
                }
                case date: {
                    this.orderByLastModifiedDateAction.setSelected(true);
                    break;
                }
                case cameraDate: {
                    this.orderByCameraDateAction.setSelected(true);
                    break;
                }
                case addedDate: {
                    this.orderByAddedDateAction.setSelected(true);
                    break;
                }
                case rating: {
                    this.orderByRatingAction.setSelected(true);
                    break;
                }
                case title: {
                    this.orderByTitleAction.setSelected(true);
                    break;
                }
                case comment: {
                    this.orderByCommentAction.setSelected(true);
                    break;
                }
                case category: {
                    this.orderByCategoryAction.setSelected(true);
                    break;
                }
                case extension: {
                    this.orderByExtensionAction.setSelected(true);
                    break;
                }
                case custom: {
                    this.customOrderingAction.setSelected(true);
                    break;
                }
                case jalbum: {
                    this.useJAlbumOrderingAction.setSelected(true);
                }
            }
            this.reverseOrderingAction.setSelected(this.currentFolder.isReverseOrdering());
            this.foldersFirstAction.setSelected(this.currentFolder.isFoldersFirst());
            switch (this.currentFolder.getFolderOrdering()) {
                case name: {
                    this.orderFoldersByNameAction.setSelected(true);
                    break;
                }
                case date: {
                    this.orderFoldersByLastModifiedDateAction.setSelected(true);
                    break;
                }
                case addedDate: {
                    this.orderFoldersByAddedDateAction.setSelected(true);
                }
            }
            this.reverseFolderOrderingAction.setSelected(this.currentFolder.isReverseFolderOrdering());
        }
    }

    void handleDisablingOfOrderingMenus() {
        boolean b = !this.customOrderingAction.isSelected() && !this.useJAlbumOrderingAction.isSelected();
        this.reverseOrderingAction.setEnabled(b);
        this.foldersFirstAction.setEnabled(b);
        boolean foldersFirst = this.foldersFirstAction.isSelected();
        this.orderFoldersByNameAction.setEnabled(b && foldersFirst);
        this.orderFoldersByLastModifiedDateAction.setEnabled(b && foldersFirst);
        this.orderFoldersByAddedDateAction.setEnabled(b && foldersFirst);
        this.reverseFolderOrderingAction.setEnabled(b && foldersFirst);
    }

    private void setOrdering(AlbumObject.Ordering ordering) {
        try {
            this.currentFolder.setOrdering(ordering);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
        this.currentFolder.invalidate();
        this.viewFolder(this.currentFolder);
        this.refreshCurrentNode();
    }

    private void setFolderOrdering(AlbumObject.Ordering folderOrdering) {
        try {
            this.currentFolder.setFolderOrdering(folderOrdering);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
        this.currentFolder.invalidate();
        this.viewFolder(this.currentFolder);
        this.refreshCurrentNode();
    }

    public List<JMenuItem> createLabelTypeItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem item = this.detailsLabelTypeAction.createJRadioButtonMenuItem();
        bg.add(item);
        items.add(item);
        item = this.fileNameLabelTypeAction.createJRadioButtonMenuItem();
        bg.add(item);
        items.add(item);
        item = this.titleLabelTypeAction.createJRadioButtonMenuItem();
        item.setForeground(Color.blue);
        bg.add(item);
        items.add(item);
        item = this.captionLabelTypeAction.createJRadioButtonMenuItem();
        bg.add(item);
        items.add(item);
        item = this.keywordsLabelTypeAction.createJRadioButtonMenuItem();
        item.setForeground(KeywordsEditor.keywordsColor);
        bg.add(item);
        items.add(item);
        this.labelTypeChanged();
        Config.getConfig().addPropertyChangeListener("labelType", evt -> this.labelTypeChanged());
        return items;
    }

    private Iterable<JMenuItem> createFlagItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ButtonGroup bg = new ButtonGroup();
        for (Flag f : Flag.values()) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(f.getSelectedIcon());
            mi.setToolTipText(f.toString());
            mi.setName(f.name());
            mi.setActionCommand(f.name());
            mi.addActionListener(ae -> {
                Flag chosen = Flag.valueOf(ae.getActionCommand());
                this.explorer.setFlag(chosen);
            });
            items.add(mi);
            bg.add(mi);
        }
        return items;
    }

    private Iterable<JMenuItem> createRatingItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ButtonGroup bg = new ButtonGroup();
        for (int rating = 0; rating <= 5; ++rating) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(Icons.get("star-gray-" + rating));
            mi.setToolTipText(Msg.get("ui.ratingToolTip", rating));
            mi.setActionCommand(Integer.toString(rating));
            mi.addActionListener(ae -> {
                int chosen = Integer.parseInt(ae.getActionCommand());
                this.explorer.setRating(chosen);
            });
            items.add(mi);
            bg.add(mi);
        }
        return items;
    }

    Set<Config.FieldType> getFieldTypes() {
        LinkedHashSet<Config.FieldType> types = new LinkedHashSet<Config.FieldType>();
        ListModel model = this.parent.preferencesWindow.detailsViewFields.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            types.add((Config.FieldType)((Object)model.getElementAt(i)));
        }
        return types;
    }

    private void labelTypeChanged() {
        switch (this.explorer.getLabelType()) {
            case details: {
                this.detailsLabelTypeAction.setSelected(true);
                this.tagPicker.setVisible(this.getFieldTypes().contains((Object)Config.FieldType.keywords));
                break;
            }
            case title: {
                this.titleLabelTypeAction.setSelected(true);
                this.tagPicker.setVisible(false);
                break;
            }
            case caption: {
                this.captionLabelTypeAction.setSelected(true);
                this.tagPicker.setVisible(false);
                break;
            }
            case fileName: {
                this.fileNameLabelTypeAction.setSelected(true);
                this.tagPicker.setVisible(false);
                break;
            }
            case keywords: {
                this.keywordsLabelTypeAction.setSelected(true);
                this.tagPicker.setVisible(true);
            }
        }
    }

    public void populateOrderingSubMenu(JMenu menu) {
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem item = this.orderByNameAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByLastModifiedDateAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByCameraDateAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByAddedDateAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByRatingAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByTitleAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByCommentAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByCategoryAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByExtensionAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.customOrderingAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.useJAlbumOrderingAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        menu.add(this.reverseOrderingAction.createJCheckBoxMenuItem());
        menu.add(this.shuffleAction);
        menu.addSeparator();
        menu.add(this.applyOrderingToSubFoldersAction);
    }

    public void populateFolderOrderingSubMenu(JMenu menu) {
        menu.add(this.foldersFirstAction.createJCheckBoxMenuItem());
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem item = this.orderFoldersByNameAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderFoldersByLastModifiedDateAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderFoldersByAddedDateAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        menu.add(this.reverseFolderOrderingAction.createJCheckBoxMenuItem());
        this.handleDisablingOfOrderingMenus();
    }

    public static boolean isPortableControlDown(MouseEvent e) {
        boolean ret = (e.getModifiersEx() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()) != 0;
        return ret;
    }

    public void setTexts() {
        this.convertLinkToCopyAction.putValue("Name", Msg.get("edit.convertLinkToCopy"));
        this.renameAction.putValue("Name", Msg.get("edit.renameFile"));
        this.newFolderAction.putValue("Name", Msg.get("edit.newFolder"));
        this.refreshAction.putValue("Name", Msg.get("edit.update"));
        this.openAction.putValue("Name", Msg.get("edit.open"));
        this.repairLinkAction.putValue("Name", Msg.get("edit.repairLink"));
        this.showInFilesystemAction.putValue("Name", Msg.get("edit.showInFilesystem"));
        this.editModeAction.putValue("Name", Msg.get("ui.edit"));
        this.previewAction.putValue("Name", Msg.get("ui.preview"));
        this.shareModeAction.putValue("Name", Msg.get("ui.share"));
        this.reviewModeAction.putValue("Name", Msg.get("ui.review"));
        this.hideExcludedAction.putValue("Name", Msg.get("edit.hideExcluded"));
        this.deleteAction.putValue("Name", Msg.get("edit.delete"));
        this.includeSelectedAction.putValue("Name", Msg.get("edit.include"));
        this.hideAction.putValue("Name", Msg.get("edit.hide"));
        this.hideAction.putValue("ShortDescription", Msg.get("edit.hideToolTip"));
        this.includeOriginalAction.putValue("Name", Msg.get("edit.includeOriginal"));
        this.includeOriginalAction.putValue("ShortDescription", Msg.get("edit.includeOriginalToolTip"));
        this.selectAllAction.putValue("Name", Msg.get("edit.selectAll"));
        this.invertSelectionAction.putValue("Name", Msg.get("edit.invertSelection"));
        this.orderByNameAction.putValue("Name", Msg.get("ui.nameOrdering"));
        this.orderByLastModifiedDateAction.putValue("Name", Msg.get("ui.dateOrdering"));
        this.orderByCameraDateAction.putValue("Name", Msg.get("edit.cameraDateOrdering"));
        this.orderByAddedDateAction.putValue("Name", Msg.get("edit.addedDateOrdering"));
        this.orderByRatingAction.putValue("Name", Msg.get("edit.ratingOrdering"));
        this.orderByTitleAction.putValue("Name", Msg.get("edit.titleLabel"));
        this.orderByCommentAction.putValue("Name", Msg.get("ui.caption"));
        this.orderByCategoryAction.putValue("Name", Msg.get("info.category"));
        this.orderByExtensionAction.putValue("Name", Msg.get("info.type"));
        this.customOrderingAction.putValue("Name", Msg.get("edit.customOrdering"));
        this.useJAlbumOrderingAction.putValue("Name", Msg.get("edit.jalbumOrdering"));
        this.reverseOrderingAction.putValue("Name", Msg.get("edit.reverseOrdering"));
        this.foldersFirstAction.putValue("Name", Msg.get("edit.foldersFirst"));
        this.orderFoldersByNameAction.putValue("Name", Msg.get("ui.nameOrdering"));
        this.orderFoldersByLastModifiedDateAction.putValue("Name", Msg.get("ui.dateOrdering"));
        this.orderFoldersByAddedDateAction.putValue("Name", Msg.get("edit.addedDateOrdering"));
        this.reverseFolderOrderingAction.putValue("Name", Msg.get("edit.reverseOrdering"));
        this.shuffleAction.putValue("Name", Msg.get("edit.shuffleOrdering"));
        this.includeNodeAction.putValue("Name", Msg.get("edit.include"));
        this.excludeNodeAction.putValue("Name", Msg.get("edit.exclude"));
        this.deleteNodeAction.putValue("Name", Msg.get("edit.delete"));
        this.renameNodeAction.putValue("Name", Msg.get("edit.renameFile"));
        this.orderingSubMenu.setText(Msg.get("edit.ordering"));
        this.folderOrderingSubMenu.setText(Msg.get("edit.folderOrdering"));
        this.saveCopyAsAction.putValue("Name", Msg.get("edit.saveCopyAs"));
        this.templatesMenu.setText(Msg.get("edit.newPage"));
    }

    private void adjustOrientation(boolean right) {
        this.imageCache.clear();
        try (EditGroup _v = new EditGroup(Msg.get("edit.rotate"));){
            if (this.isExplorerMode()) {
                List<JAlbumObject> list = this.getSelectJAlbumObjects();
                for (JAlbumObject jao : list) {
                    if (right) {
                        jao.ao.rotateRight();
                        continue;
                    }
                    jao.ao.rotateLeft();
                }
            } else {
                if (right) {
                    this.editor.ao.rotateRight();
                } else {
                    this.editor.ao.rotateLeft();
                }
                this.imageCache.clear();
                this.editor.updateImage(false);
            }
        }
        catch (IOException ex) {
            Debug.showFriendlyErrorDialog(this, ex);
        }
    }

    private void flip() {
        this.imageCache.clear();
        try (EditGroup _v = new EditGroup(Msg.get("edit.rotate"));){
            if (this.isExplorerMode()) {
                List<JAlbumObject> list = this.getSelectJAlbumObjects();
                for (JAlbumObject jao : list) {
                    jao.ao.setOrientation(jao.ao.getOrientation().flipped());
                }
            } else {
                this.editor.ao.setOrientation(this.editor.ao.getOrientation().flipped());
                this.imageCache.clear();
                this.editor.updateImage(false);
            }
        }
        catch (IOException ex) {
            Debug.showFriendlyErrorDialog(this, ex);
        }
    }

    private void repairAllBrokenLinks(AlbumObject folder, File newParent) throws IOException {
        List<AlbumObject> children = folder.getChildren();
        for (AlbumObject ao : children) {
            LinkFile link;
            File newTarget;
            if (ao.isLink() && !ao.getFile().exists() && (newTarget = new File(newParent, (link = (LinkFile)ao.getFile()).getTargetName())).exists()) {
                ao.repairLink(newTarget);
            }
            if (!ao.isFolder()) continue;
            this.repairAllBrokenLinks(ao, newParent);
        }
        folder.setChildren(children);
    }

    void open(JAlbumObject jao, int modifiersMask) {
        block28: {
            if (jao == null) {
                return;
            }
            if (!LinkFile.exists(jao.ao.getFile(), jao.ao.getEngine()) && jao.ao.getFile() instanceof LinkFile) {
                if (((LinkFile)jao.ao.getFile()).isDynamic()) {
                    JOptionPane.showMessageDialog(this.parent, Msg.get("ui.repairDynamicLinkError"), Msg.get("edit.repairLink"), 0);
                    return;
                }
                LinkFile link = (LinkFile)jao.ao.getFile();
                File closestFile = link.getTarget();
                while (!closestFile.exists() && closestFile.getParentFile() != null) {
                    closestFile = closestFile.getParentFile();
                }
                File target = link.getTarget();
                DirectoryChooser chooser = target.getName().indexOf(46) != -1 ? ChooserFactory.createFileChooser(this.parent) : ChooserFactory.createDirectoryChooser(this.parent);
                chooser.setCurrentDirectory(closestFile);
                chooser.setSelectedFile(new File(closestFile, target.getName()));
                chooser.setDialogTitle(Msg.get("edit.locateTargetFile", link.getTargetName()));
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal == 0) {
                    try {
                        File targetFile = chooser.getSelectedFile();
                        if (targetFile.exists()) {
                            File f;
                            if (targetFile.isDirectory() && (f = new File(targetFile, link.getTargetName())).exists()) {
                                targetFile = f;
                            }
                        } else {
                            File f = new File(chooser.getCurrentDirectory(), link.getTargetName());
                            if (f.exists()) {
                                targetFile = f;
                            }
                        }
                        if (jao.ao.repairLink(targetFile)) {
                            this.repairAllBrokenLinks(this.currentFolder, targetFile.getParentFile());
                        }
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(this, ex);
                    }
                    this.refreshAction.actionPerformed(null);
                }
            } else if (jao.ao.getCategory() == Category.folder) {
                if (jao.ao.isInternalLink()) {
                    this.selectNode(((LinkFileAlbumObject)jao.ao).getInternalTarget());
                } else {
                    this.selectNode(jao.ao);
                }
            } else if (jao.ao.isDisplayableImage() || this.hasCustomUI(jao.ao) || jao.ao.getCategory() == Category.view) {
                Action editAction = ImageEditor.getInstance().getEditAction();
                if ((modifiersMask & 0x240) != 0 && editAction != null) {
                    editAction.actionPerformed(null);
                } else {
                    this.setEditView(jao.ao);
                }
            } else {
                try {
                    if (jao.ao.getCategory() == Category.webPage) {
                        TextEditor.openDocument(LinkFile.getResolvedTarget(jao.ao));
                        break block28;
                    }
                    try {
                        if (jao.ao.getCategory() == Category.video && (modifiersMask & 0x200) == 0) {
                            new VideoPlayer(jao.ao);
                            return;
                        }
                        if (jao.ao.getCategory() == Category.webLocation) {
                            WebLocation wl = new WebLocation(jao.ao.getFile());
                            Desktop.getDesktop().browse(wl.getURI());
                            return;
                        }
                    }
                    catch (IOException wl) {
                        // empty catch block
                    }
                    Desktop.getDesktop().open(jao.ao.getFile());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(this, ex);
                }
            }
        }
    }

    private boolean hasCustomUI(AlbumObject ao) {
        if (ao.getCategory() == Category.webPage) {
            try {
                String doc = IO.readTextFile(LinkFile.getResolvedTarget(ao));
                Element elem = Elements.getElementByName("ja:ui", doc, false);
                if (elem != null && "ja:ui".equals(elem.getName())) {
                    return true;
                }
            }
            catch (IOException | ElementException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void refreshCurrentNode() {
        FolderTreeNode node = (FolderTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            this.selectNode(this.currentFolder);
            node = (FolderTreeNode)this.tree.getLastSelectedPathComponent();
        }
        this.refreshFrom(node);
        TreePath selTP = new TreePath(node.getPath());
        this.tree.setSelectionPath(selTP);
    }

    void refreshFrom(FolderTreeNode node) {
        Enumeration<TreePath> expandedPaths = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
        node.invalidate();
        ((DefaultTreeModel)this.tree.getModel()).reload(node);
        while (expandedPaths != null && expandedPaths.hasMoreElements()) {
            TreePath tp = expandedPaths.nextElement();
            this.tree.expandPath(tp);
        }
    }

    public void syncModel() {
        this.syncModel(null);
    }

    private void syncModel(String namedOperation) {
        Component[] comps;
        final ArrayList<AlbumObject> children = new ArrayList<AlbumObject>();
        for (Component element : comps = this.explorer.getComponents()) {
            JAlbumObject jao = (JAlbumObject)element;
            children.add(jao.ao);
        }
        try {
            if (this.currentFolder != null) {
                UndoableNamedEdit structureEdit = null;
                if (namedOperation != null) {
                    structureEdit = new UndoableNamedEdit(this, namedOperation){
                        List<AlbumObject> oldState;
                        List<AlbumObject> newState;
                        final /* synthetic */ JAlbumExplorer this$0;
                        {
                            this.this$0 = this$0;
                            super(presentationName);
                            this.oldState = this.this$0.currentFolder.getChildren();
                            this.newState = children;
                        }

                        @Override
                        public void doUndo() throws Exception {
                            this.this$0.currentFolder.setChildren(this.oldState);
                            this.this$0.currentFolder.fireModelChanged();
                        }

                        @Override
                        public void doRedo() throws Exception {
                            this.this$0.currentFolder.setChildren(this.newState);
                            this.this$0.currentFolder.fireModelChanged();
                        }
                    };
                }
                this.currentFolder.setChildren(children);
                if (structureEdit != null) {
                    UndoHandler.getInstance().undoableEditHappened(this, structureEdit);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private TreePath getTreePathFor(AlbumObject folder) {
        LinkedList<AlbumObject> ancestors = new LinkedList<AlbumObject>();
        AlbumObject ao = folder;
        while (ao.getParent() != null) {
            ancestors.addFirst(ao);
            ao = ao.getParent();
        }
        TreePath tp = new TreePath(this.tree.getModel().getRoot());
        block1: for (AlbumObject ao2 : ancestors) {
            FolderTreeNode node = (FolderTreeNode)tp.getLastPathComponent();
            Enumeration<TreeNode> tne = node.children();
            while (tne.hasMoreElements()) {
                FolderTreeNode child = (FolderTreeNode)tne.nextElement();
                if (child.getAlbumObject() != ao2) continue;
                tp = tp.pathByAddingChild(child);
                continue block1;
            }
        }
        return tp;
    }

    public void selectNode(AlbumObject folder) {
        TreePath path = this.getTreePathFor(folder);
        this.tree.setSelectionPath(path);
        this.tree.expandPath(path);
    }

    public void gotoPath(String path) {
        JAlbumObject jao;
        String[] pathParts;
        TreePath tp = new TreePath(this.tree.getModel().getRoot());
        String[] allPathParts = path.split("/");
        block0: for (String name : pathParts = Arrays.copyOf(allPathParts, allPathParts.length - 1)) {
            FolderTreeNode node = (FolderTreeNode)tp.getLastPathComponent();
            Enumeration<TreeNode> tne = node.children();
            while (tne.hasMoreElements()) {
                FolderTreeNode child = (FolderTreeNode)tne.nextElement();
                if (!child.getAlbumObject().getName().equals(name)) continue;
                tp = tp.pathByAddingChild(child);
                continue block0;
            }
        }
        this.tree.setSelectionPath(tp);
        this.tree.expandPath(tp);
        AlbumObject selected = this.getCurrentFolder().getChild(allPathParts[allPathParts.length - 1]);
        if (selected != null && (jao = this.explorer.getJAlbumObject(selected)) != null) {
            this.explorer.scrollRectToVisible(jao.getBounds());
            this.explorer.selectionModel.selectSingle(jao);
            SwingUtilities.invokeLater(() -> jao.requestFocusInWindow());
        }
    }

    public AlbumObject getRootFolder() {
        return this.rootFolder;
    }

    public AlbumObject getCurrentFolder() {
        return this.currentFolder;
    }

    public void rememberLastLocation() {
        Preferences node = Preferences.userNodeForPackage(JAlbumExplorer.class).node(LAST_LOCATION_KEY);
        String key = StringUtil.limit(this.rootFolder.getName(), 70);
        if (Config.getConfig().isRememberLastSelectedItem()) {
            JAlbumObject focused = this.explorer.selectionModel.getFocusedObject();
            if (focused != null) {
                node.put(key, focused.ao.getPathFromRoot());
            } else if (this.currentFolder.getParent() != null) {
                node.put(key, this.currentFolder.getPathFromRoot());
            }
        } else {
            node.remove(key);
        }
    }

    private void gotoLastLocation() {
        Preferences node;
        String path;
        if (Config.getConfig().isRememberLastSelectedItem() && (path = (node = Preferences.userNodeForPackage(JAlbumExplorer.class).node(LAST_LOCATION_KEY)).get(this.rootFolder.getName(), null)) != null) {
            this.gotoPath(path);
        }
    }

    public void setRootFolder(AlbumObject root) {
        if (this.rootFolder != null) {
            this.rootFolder.removePropertyChangeListener(this.rootNameChangeListener);
            this.rememberLastLocation();
        }
        if (!this.isPreviewTabShowing()) {
            this.setExplorerView();
        }
        root.addPropertyChangeListener("name", this.rootNameChangeListener);
        this.parent.settingsWindow.setAlbumObject(root);
        this.rootFolder = root;
        this.knownKeywords.clear();
        AlbumObjectProperties props = root.getProperties();
        if (props.containsKey("lastFetchedDate")) {
            props.put("lastOpenedDate", new Date().getTime());
            props.save();
        }
        this.albumManager.setCurrentProject(new AlbumProject(this.parent.projectChooser.getSelectedFile(), this.rootFolder));
        this.explorer.removeAll();
        FolderTreeNode rootNode = new FolderTreeNode(root);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.tree.setModel(treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setEditable(true);
        this.tree.setInvokesStopCellEditing(true);
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                FolderTreeNode node = (FolderTreeNode)JAlbumExplorer.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    String newName = node.getUserObject().toString().trim();
                    node.setUserObject(newName);
                    AlbumObject ao = node.getAlbumObject();
                    if (ao.setName(newName)) {
                        JAlbumExplorer.this.refreshCurrentNode();
                        JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                        if (node.isRoot()) {
                            try {
                                JAlbumExplorer.this.parent.renameImageDirectory(newName);
                            }
                            catch (IOException ex) {
                                Debug.showErrorDialog(JAlbumExplorer.this.parent, ex);
                            }
                        }
                    }
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        SwingUtilities.invokeLater(() -> this.gotoLastLocation());
    }

    private boolean isExplorerMode() {
        for (Component panel : this.viewPanel.getComponents()) {
            if (!panel.isVisible() || !"explorerPanel".equals(panel.getName())) continue;
            return true;
        }
        return false;
    }

    boolean isEditMode() {
        return this.viewPanel.getSelectedCard() == this.editor;
    }

    public boolean isPreviewMode() {
        return this.viewPanel.getSelectedCard() == this.browserPanel;
    }

    public boolean isProjectLoaded() {
        return this.rootFolder != null && this.rootFolder.getFile().toString().length() > 0;
    }

    public void setExplorerView() {
        if (!this.isProjectLoaded()) {
            this.viewPanel.setSelectedCard(this.welcomePanel);
            return;
        }
        if (this.isExplorerMode()) {
            return;
        }
        this.viewPanel.setSelectedCard(this.explorerCard);
        JToggleButton tb = (JToggleButton)this.explorerAction.getValue("toggleButton");
        if (tb != null) {
            tb.setSelected(true);
        }
        this.editor.cleanFilterListeners();
        AlbumObject lastEdited = this.editor.getAO();
        this.editor.setAO(null);
        this.updateStatusBar();
        JAlbumObject jao = this.explorer.getJAlbumObject(lastEdited);
        if (jao != null) {
            this.explorer.selectionModel.selectSingle(jao);
            this.explorer.scrollRectToVisible(jao.getBounds());
            jao.requestFocusInWindow();
        }
        this.parent.setTitle();
    }

    void setEditView(AlbumObject ao) {
        Tracer.getInstance().trace("open edit view");
        this.viewPanel.validate();
        this.viewPanel.setSelectedCard(this.editor);
        JToggleButton tb = (JToggleButton)this.editModeAction.getValue("toggleButton");
        if (tb != null) {
            tb.setSelected(true);
        }
        SwingUtilities.invokeLater(() -> {
            this.editor.setAO(ao);
            this.editor.setFiltersViewMode();
            this.parent.setTitle();
            this.propertiesAction.setEnabled(false);
            this.editor.requestFocusInWindow();
            TipOfTheDay.interruptPendingNotification();
            JNotification n = new JNotification(Msg.get("tip.editMode"));
            n.setPriority(JNotification.Priority.HIGH);
            if (!n.isShownBefore()) {
                n.setRememberShown(true);
                n.setLastShown(System.currentTimeMillis());
            }
        });
    }

    public void selectRootFolderInTreeView() {
        this.selectNode(this.rootFolder);
    }

    void applyFilter(JAlbumObject jao) {
        boolean hideExcluded = this.hideExcludedMenuItem.isSelected();
        jao.setVisible(!(hideExcluded && !jao.ao.isIncluded() || this.filterBar.isVisible() && !this.filterBar.test(jao.ao)));
    }

    void applyFilters() {
        for (Component c : this.explorer.getComponents()) {
            this.applyFilter((JAlbumObject)c);
        }
    }

    public void redraw() {
        if (this.delayedRedraw != null) {
            this.delayedRedraw.cancel(false);
        }
        this.delayedRedraw = JAlbumUtilities.schedule(this::redrawNow, 200L, TimeUnit.MILLISECONDS);
    }

    public void redrawNow() {
        JAlbum.logger.fine("Redrawing");
        JAlbumUtilities.runOnAWT(() -> {
            this.refreshFrom((FolderTreeNode)this.tree.getModel().getRoot());
            this.selectNode(this.currentFolder);
            this.viewFolder(this.currentFolder);
        });
    }

    public void refreshView() {
        Point pos = this.explorerScrollPane.getViewport().getViewPosition();
        this.viewFolder(this.currentFolder);
        this.explorerScrollPane.getViewport().setViewPosition(pos);
    }

    public void viewFolder(AlbumObject folder) {
        this.doViewFolder(folder);
        this.historyNavigator.track(folder);
    }

    public void doViewFolder(AlbumObject folder) {
        try (WaitCursor.WaitToken _wt = this.parent.waitCursor.getToken();){
            this.explorer.closestObject = null;
            Stopwatch sw = new Stopwatch("View folder");
            sw.start();
            boolean projectLoaded = this.isProjectLoaded();
            this.templatesMenu.setEnabled(projectLoaded);
            this.newPageButton.setEnabled(projectLoaded);
            this.newEmptyPageAction.setEnabled(projectLoaded);
            this.newWebLocationAction.setEnabled(projectLoaded);
            this.newFolderAction.setEnabled(projectLoaded);
            this.explorerAction.setEnabled(projectLoaded);
            this.propertiesAction.setEnabled(projectLoaded);
            this.previewAction.setEnabled(projectLoaded);
            this.filterBarAction.setEnabled(projectLoaded);
            if (this.currentFolder != null) {
                this.currentFolder.removePropertyChangeListener(this.orderingListener);
                this.currentFolder.removePropertyChangeListener(this.modelChangedListener);
            }
            AlbumObject previousFolder = this.currentFolder;
            this.currentFolder = folder;
            this.currentFolder.addPropertyChangeListener("ordering", this.orderingListener);
            this.currentFolder.addPropertyChangeListener("modelChanged", this.modelChangedListener);
            this.currentFolder.addPropertyChangeListener("moved", this.modelChangedListener);
            this.addressBar.setFolder(folder);
            if (!projectLoaded) {
                this.viewPanel.setSelectedCard(this.welcomePanel);
                this.folderPropertyPanel.reset();
                return;
            }
            this.parentFolderAction.setEnabled(folder != null && folder.getParent() != null);
            if (!this.isPreviewTabShowing()) {
                this.setExplorerView();
            }
            this.explorer.removeAll();
            this.children = folder.getChildren();
            if (this.children == null) {
                return;
            }
            for (AlbumObject ao : this.children) {
                this.addJAO(ao);
            }
            if (Config.getConfig().isScrollToTop()) {
                this.explorerScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
            this.validate();
            this.repaint();
            this.updateOrderingMenus();
            this.handleDisablingOfOrderingMenus();
            this.updateStatusBar();
            this.representingAlbumObjectListener = evt -> this.explorer.repaint();
            this.currentFolder.addPropertyChangeListener("representingAlbumObject", this.representingAlbumObjectListener);
            KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (mgr.getCurrentFocusCycleRoot() == this.explorerCard) {
                JAlbumObject jao = this.explorer.getJAlbumObject(previousFolder);
                if (jao != null && this.currentFolder.equals(previousFolder.getParent())) {
                    jao.requestFocusInWindow();
                } else if (mgr.getFocusOwner() instanceof JAlbumObject) {
                    this.explorer.requestFocusInWindow();
                }
            }
            this.firePropertyChange("currentFolder", null, this.currentFolder);
            if (JAlbum.logger.isLoggable(Level.FINER)) {
                sw.print();
            }
        }
    }

    private void setPreviewMode(Config.PreviewMode mode) {
        boolean previewWasShowing = this.browserPanel.isShowing();
        if (mode == Config.PreviewMode.integrated) {
            if (!this.viewModeBar.contains(this.previewButton)) {
                this.viewModeBar.add(this.previewButton, 2);
                if (this.previewWindow.isVisible()) {
                    this.previewWindow.setVisible(false);
                }
                this.previewWindow.remove(this.browserPanel);
                this.viewPanel.add((Component)this.browserPanel, "browserPanel");
                this.validate();
            }
        } else {
            if (this.viewModeBar.contains(this.previewButton)) {
                this.viewModeBar.remove(this.previewButton);
                this.previewButton.setSelected(false);
                this.viewPanel.remove(this.browserPanel);
                this.browserPanel.setVisible(true);
                this.validate();
                this.setExplorerView();
            }
            this.previewWindow.installBrowserPanel(this.browserPanel);
        }
        if (previewWasShowing) {
            SwingUtilities.invokeLater(this::showPreview);
        }
    }

    public void showPreview() {
        Tracer.getInstance().trace("preview album", "previewMode:" + Config.getConfig().getPreviewMode().name());
        switch (Config.getConfig().getPreviewMode()) {
            case integrated: {
                this.previewButton.setSelected(true);
                this.viewPanel.setSelectedCard(this.browserPanel);
                break;
            }
            case windowed: {
                if (!this.previewWindow.isVisible()) {
                    this.previewWindow.setVisible(true);
                }
                if (this.previewWindow.getState() == 1) {
                    this.previewWindow.setState(0);
                }
                SwingUtilities.invokeLater(this.previewWindow::toFront);
            }
        }
    }

    private JAlbumObject addJAO(AlbumObject ao) {
        return this.addJAO(this.explorer.getComponentCount(), ao);
    }

    private JAlbumObject addJAO(int index, AlbumObject ao) {
        JAlbumObject jao = new JAlbumObject(ao, this.explorer);
        this.applyFilter(jao);
        this.prepareJAO(jao);
        this.explorer.add((Component)jao, index);
        return jao;
    }

    void prepareJAO(JAlbumObject jao) {
        jao.addFocusListener(this.componentFocusListener);
        jao.getInputMap().put(space, "slideShowAction");
        jao.getActionMap().put("slideShowAction", this.reviewModeAction);
        jao.addKeyListener(this.explorer.typeNavigator);
        DragSource ds = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(jao, 0x40000003, new DragGestureButtonFilter(this.explorer));
        jao.addMouseListener(this.mouseOnComponentAdapter);
        jao.addMouseMotionListener(this.mouseMotionOnComponentListener);
        jao.ao.addPropertyChangeListener("name", this);
    }

    void updateRotateActions(AlbumObject ao) {
        this.rotateLeftAction.setEnabled(!ao.isFolder() && ao.hasDisplayableImage());
        this.rotateRightAction.setEnabled(!ao.isFolder() && ao.hasDisplayableImage());
        this.flipAction.setEnabled(!ao.isFolder() && ao.hasDisplayableImage());
    }

    private static void points2rect(Point p1, Point p2, Rectangle r) {
        if (p1 == null) {
            throw new NullPointerException("p1 is null");
        }
        if (p2 == null) {
            throw new NullPointerException("p2 is null");
        }
        if (r == null) {
            throw new NullPointerException("r is null");
        }
        r.x = Math.min(p1.x, p2.x);
        r.y = Math.min(p1.y, p2.y);
        r.width = p2.x - p1.x;
        if (r.width < 0) {
            r.width = -r.width;
        }
        r.height = p2.y - p1.y;
        if (r.height < 0) {
            r.height = -r.height;
        }
    }

    private boolean maybeShowPopup(MouseEvent e, JPopupMenu popup) {
        if (e.isPopupTrigger()) {
            if (popup == this.componentPopup) {
                Category cat;
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                try {
                    FileFilters.BasicImageInfo ii = jao.ao.getImageInfo();
                    this.rawSettingsMenu.setVisible(jao.ao.getCategory() == Category.image && ii != null ? ii.isRaw() : false);
                    this.copyRAWSettingsAction.setEnabled(this.explorer.selectionModel.getSingleSelected() != null);
                }
                catch (IOException ii) {
                    // empty catch block
                }
                if (!LinkFile.exists(jao.ao.getFile(), jao.ao.getEngine())) {
                    popup = this.brokenLinkPopup;
                }
                this.includeOriginalAction.setEnabled((cat = jao.ao.getCategory()) == Category.image || cat == Category.video);
                this.includeOriginalAction.setSelected(jao.ao.isIncludeOriginal());
                this.ratingSubMenu.getItem(Math.max(jao.ao.getRating(), 0)).setSelected(true);
                this.flagSubMenu.getItem(jao.ao.getFlag().ordinal()).setSelected(true);
                this.useOriginalAction.setSelected(jao.ao.isUseOriginal());
                if (cat == Category.video) {
                    this.includeOriginalAction.putValue("Name", Msg.get("edit.doNotReEncode"));
                } else {
                    this.includeOriginalAction.putValue("Name", Msg.get("edit.includeOriginal"));
                }
                this.hideAction.setEnabled(jao.ao.getCategory() == Category.folder || jao.ao.getCategory() == Category.webPage);
                this.hideAction.setSelected(jao.ao.isHidden());
                this.useAsFolderThumbnailMenuItem.setSelected(false);
                if (jao.ao == this.currentFolder.getRepresentingAlbumObject()) {
                    this.useAsFolderThumbnailMenuItem.setSelected(true);
                }
                this.effectsMenu.updateMenuState(jao.ao);
                this.orderSelectedByMenu.setEnabled(this.explorer.selectionModel.getSelectionCount() > 1);
                int nSelected = this.explorer.selectionModel.getSelectedObjects().size();
                this.renameAction.putValue("Name", nSelected > 1 ? Msg.get("rename.renameNItems", nSelected) + "..." : Msg.get("edit.renameFile"));
                if (this.contextMenuListener != null) {
                    this.skinContextMenu.removeAll();
                    try {
                        this.contextMenuListener.accept(this.skinContextMenu);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                }
                this.showTargetMenuItem.setVisible(jao.ao.isInternalLink());
            } else if (popup == this.explorerPopup) {
                File skinDir = Config.getConfig().chainedSkinsDir.getFile(this.parent.engine.getSkin());
                File templatesDir = new File(skinDir, "templates");
                this.templatesMenu.removeAll();
                this.templatesMenu.add(this.newWebLocationAction);
                this.newEmptyPageAction.setEnabled(this.isFullSiteSupport());
                this.templatesMenu.add(this.newEmptyPageAction);
                if (templatesDir.exists()) {
                    this.templatesMenu.addSeparator();
                    for (File f : templatesDir.listFiles(new TemplateFilter())) {
                        JMenuItem item = new JMenuItem(f.getName());
                        item.setName(f.getName());
                        item.addActionListener(this.templateListener);
                        this.templatesMenu.add(item);
                    }
                }
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
            return true;
        }
        return false;
    }

    private boolean isFullSiteSupport() {
        File skinDir = Config.getConfig().chainedSkinsDir.getFile(this.parent.engine.getSkin());
        File templatesDir = new File(skinDir, "templates");
        return templatesDir.exists() || this.parent.engine.getSkinProperties().isFullSiteSupport();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        AlbumObject source;
        if ("name".equals(evt.getPropertyName()) && (source = (AlbumObject)evt.getSource()).isFolder()) {
            SwingUtilities.invokeLater(this::refreshCurrentNode);
        }
    }

    private void initToolBar() {
        this.toolBar.add(this.addButton);
        this.toolBar.add(this.newFolderAction, true);
        this.toolBar.add((Component)this.newPageButton, (Object)true);
        this.toolBar.add(this.excludeSelectedAction);
        this.toolBar.addGroup(this.rotateLeftAction, this.rotateRightAction, this.flipAction);
        this.toolBar.add(Box.createHorizontalStrut(4));
        this.toolBar.addSeparator();
        this.toolBar.addGroup(UndoHandler.getInstance().getUndoAction(), UndoHandler.getInstance().getRedoAction());
        this.toolBar.add(Box.createHorizontalStrut(4));
    }

    public void populateOrganizeMenu(JMenu menu) {
        menu.add(this.wrapInFolderAction);
        menu.add(this.flattenAction);
        menu.add(this.groupAlphabeticallyAction);
        menu.add(this.groupByDateAction);
        menu.add(this.groupByCalendarAction);
        menu.add(this.groupByPlaceAction);
        menu.add(this.groupByKeywordsAction);
        menu.add(this.groupByCreatorAction);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public boolean isPreviewTabShowing() {
        return this.viewPanel.getSelectedCard() == this.browserPanel;
    }

    public void setEnableRefresh(boolean enable) {
        this.renderThread.setEnableRefresh(enable);
    }

    class RenderThread
    extends Thread {
        private int nErrors;
        private int counter;
        private boolean enableRefresh;

        public boolean isEnableRefresh() {
            return this.enableRefresh;
        }

        public void setEnableRefresh(boolean enableRefresh) {
            this.enableRefresh = enableRefresh;
        }

        public RenderThread() {
            super("JAlbumExplorer.RenderThread");
            this.nErrors = 0;
            this.counter = 0;
            this.enableRefresh = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        block12: {
                            try {
                                Thread.sleep(200L);
                                AlbumObject cf = JAlbumExplorer.this.currentFolder;
                                if (!JAlbumExplorer.this.isExplorerMode() && !JAlbumExplorer.this.isEditMode() || !this.enableRefresh || this.counter % 5 != 0 || cf == null) break block12;
                                long lastModified = cf.getFile().lastModified();
                                long lastRefreshed = ((AlbumObjectImpl)cf).getLastRefreshed();
                                if (lastModified == 0L && !cf.getFile().exists()) {
                                    for (cf = cf.getParent(); cf != null; cf = cf.getParent()) {
                                        if (cf.getLastModified() == 0L) continue;
                                        JAlbumExplorer.this.selectNode(cf);
                                        break block12;
                                    }
                                    break block12;
                                }
                                if (lastModified > lastRefreshed && System.currentTimeMillis() - lastModified > 1000L) {
                                    Debug.log("Refreshing current folder due to external file system changes");
                                    SwingUtilities.invokeAndWait(() -> {
                                        AlbumObject cf1 = JAlbumExplorer.this.currentFolder;
                                        if (cf1 != null) {
                                            cf1.invalidate();
                                            JAlbumExplorer.this.imageCache.clear();
                                            JAlbumExplorer.this.refreshCurrentNode();
                                            if (JAlbumExplorer.this.isExplorerMode()) {
                                                JAlbumExplorer.this.viewFolder(cf1);
                                            } else if (JAlbumExplorer.this.isEditMode() && JAlbumExplorer.this.editor.customUI == null) {
                                                try {
                                                    File f = JAlbumExplorer.this.editor.ao.getFile();
                                                    if (f instanceof CachedFile) {
                                                        ((CachedFile)f).clear();
                                                    }
                                                    JAlbumExplorer.this.editor.ao.updateRepresentingIcon();
                                                    JAlbumExplorer.this.editor.updateImage(true);
                                                }
                                                catch (IOException ex) {
                                                    Logger.getLogger(JAlbumExplorer.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                            catch (InterruptedException cf) {
                                // empty catch block
                            }
                        }
                        ++this.counter;
                    }
                }
                catch (InvocationTargetException t) {
                    if (++this.nErrors == 1) {
                        Debug.showErrorDialog(JAlbumExplorer.this, t.getCause());
                    }
                    System.err.println("Render thread reported error: " + String.valueOf(t.getCause()));
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }

    private class OrderSelectedAction
    extends RearrangeSelectedAction {
        private AlbumObject.Ordering ordering;

        public OrderSelectedAction(AlbumObject.Ordering ordering) {
            this.ordering = ordering;
            this.updateTexts();
            Config.getConfig().addPropertyChangeListener("language", evt -> this.updateTexts());
        }

        private void updateTexts() {
            this.putValue("Name", this.ordering.toString());
            this.putValue("ShortDescription", Msg.get("edit.orderSelectedByToolTip"));
        }

        @Override
        protected void rearrange(ActionEvent e, List<JAlbumObject> selected) {
            Comparator<AlbumObject> aoCmp = this.ordering.getComparator((e.getModifiers() & 9) != 0);
            Collections.sort(selected, (jao1, jao2) -> aoCmp.compare(jao1.ao, jao2.ao));
        }
    }

    private static class TemplateFilter
    implements FileFilter {
        private TemplateFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName().toLowerCase();
            if (name.equals("empty-page.htt")) {
                return false;
            }
            return name.endsWith(".htt") || name.endsWith(".htm") || name.endsWith(".html");
        }
    }

    private abstract class RearrangeSelectedAction
    extends SmartAction {
        protected abstract void rearrange(ActionEvent var1, List<JAlbumObject> var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            List<JAlbumObject> selectedJAO = JAlbumExplorer.this.getSelectedOrAll();
            int insertIndex = JAlbumExplorer.this.getClosestIndex(selectedJAO);
            this.rearrange(e, selectedJAO);
            Object object = JAlbumExplorer.this.explorer.getTreeLock();
            synchronized (object) {
                int i = 0;
                for (JAlbumObject jao : selectedJAO) {
                    JAlbumExplorer.this.explorer.setComponentZOrder(jao, insertIndex + i++);
                }
            }
            JAlbumExplorer.this.explorer.validate();
            JAlbumExplorer.this.explorer.repaint();
            JAlbumExplorer.this.explorer.scrollRectToVisible(selectedJAO.get(0).getBounds().union(selectedJAO.get(selectedJAO.size() - 1).getBounds()));
            try {
                JAlbumContext.getInstance().getFrame().actions.setLastTool(this, Msg.get("edit.orderSelectedBy") + " " + String.valueOf(this.getValue("Name")));
                JAlbumExplorer.this.explorer.fireStructureChanged(new StructureEvent(this, selectedJAO, Msg.get("edit.reorderedNItems", selectedJAO.size(), (String)this.getValue("Name"))));
                JAlbumExplorer.this.currentFolder.setOrdering(AlbumObject.Ordering.custom);
                JAlbumExplorer.this.customOrderingAction.setSelected(true);
                JAlbumExplorer.this.handleDisablingOfOrderingMenus();
                JAlbumExplorer.this.parent.statusBar.setText(Msg.get("edit.reorderedNItems", selectedJAO.size(), (String)this.getValue("Name")));
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JAlbumExplorer.this, ex);
                Logger.getLogger(JAlbumExplorer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

