/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import se.datadosen.component.JCleanToolBar;
import se.datadosen.component.JNiceTextField;
import se.datadosen.component.JToolBarButton;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class JAddressBar
extends JPanel {
    private JAlbumExplorer context;
    private JTextField address = new JNiceTextField();
    private JPopupMenu menu = new JPopupMenu();
    private Action closeAction = new AbstractAction(Msg.get("close")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAddressBar.this.context.addressBarMenuItem.setSelected(false);
            JAddressBar.this.context.addressBarAction.actionPerformed(e);
        }
    };
    private Action showInFilesystemAction = new AbstractAction(Msg.get("edit.showInFilesystem")){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BrowserLauncher.openLocal(JAddressBar.this.context.getCurrentFolder().getFile());
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JAddressBar.this.context, ex);
            }
        }
    };

    public JAddressBar(JAlbumExplorer context) {
        this.context = context;
        this.address.setFont(JAlbumFrame.H3_FONT);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.address.setEditable(false);
        this.address.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JAddressBar.this.menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JAddressBar.this.menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        File targetDir = null;
                        targetDir = e.isAltDown() || e.isShiftDown() ? new AlbumSynchronizer(JAddressBar.this.context.parent.engine).translate(JAddressBar.this.context.getCurrentFolder()) : JAddressBar.this.context.getCurrentFolder().getFile();
                        if (!targetDir.exists()) {
                            Toolkit.getDefaultToolkit().beep();
                        } else {
                            BrowserLauncher.openLocal(targetDir);
                        }
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JAddressBar.this.context, ex);
                    }
                }
            }
        });
        JCleanToolBar tb = new JCleanToolBar();
        tb.add(new JToolBarButton(this.context.backAction, false));
        tb.add(new JToolBarButton(this.context.forwardAction, false));
        tb.add(new JToolBarButton(this.context.parentFolderAction, false));
        this.add((Component)tb, "West");
        this.add(this.address);
        this.menu.add(this.showInFilesystemAction);
        this.menu.add(this.closeAction);
    }

    public void setFolder(AlbumObject folder) {
        if (folder.getName().length() > 0) {
            this.address.setText(folder.getFile().getAbsolutePath());
        } else {
            this.address.setText("");
        }
    }
}

