/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import se.datadosen.component.Autocompleter;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JSmartSyntaxTextArea;
import se.datadosen.component.RiverLayout2;
import se.datadosen.component.SmartTextComponent;
import se.datadosen.component.WordList;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JPropertyPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileNameDocument;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.Platform;
import se.datadosen.util.StringUtil;

public class DetailsEditor
extends JAlbumObject.LabelEditor {
    public static final DataFlavor fieldFlavor = new DataFlavor(ReadWriteField.class, "Field flavor");
    private static ReadWriteField currentField;
    private static Action copyAction;
    private static JButton copyButton;
    private static Box hBox;
    private List<AbstractField> formFields = new ArrayList<AbstractField>();
    private boolean refreshed;

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        return new Dimension(Short.MAX_VALUE, pref.height);
    }

    public DetailsEditor(JAlbumObject jao) {
        super(jao);
        this.init();
    }

    @Override
    void refresh() {
        for (AbstractField field : this.formFields) {
            field.refresh();
        }
        this.refreshed = true;
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    @Override
    void setEditing(boolean editing) {
    }

    @Override
    boolean isEditing() {
        return false;
    }

    @Override
    void setSelected(boolean selected) {
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.setLayout(new RiverLayout2());
        String sep = "tab";
        for (Config.FieldType ft : this.jao.context.context.getFieldTypes()) {
            SimpleDateFormat df = Config.getConfig().getDateFormatter();
            switch (ft) {
                case added: {
                    this.formFields.add(new UndoableReadWriteField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, ao -> {
                        long whenAdded = ao.getWhenAdded();
                        return whenAdded != 0L ? df.format(new Date(whenAdded)) : "";
                    }, (ao, s) -> {
                        Date date = df.parse(s);
                        ao.setWhenAdded(date.getTime());
                    }).monitorProperty("whenAdded"));
                    break;
                }
                case cameraDate: {
                    this.formFields.add(new ReadOnlyField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, ao -> {
                        long date = ao.getCameraDate();
                        if (date != 0L) {
                            return df.format(new Date(date));
                        }
                        throw new DataMissingException();
                    }));
                    break;
                }
                case caption: {
                    this.formFields.add(new ReadWriteField(ft, (JTextComponent)((Object)new JSmallSyntaxTextArea()), this.jao.ao, AlbumObject::getComment, AlbumObject::setComment));
                    break;
                }
                case creator: {
                    this.formFields.add(new XmpField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, ao -> ao.getXmpManager().getCreator(), (ao, s) -> {
                        XmpManager mgr = ao.getXmpManager();
                        if (mgr != null) {
                            mgr.setCreator(s);
                            mgr.save();
                        }
                    }));
                    break;
                }
                case fileName: {
                    this.formFields.add(new ReadWriteField(ft, new JPropertyPanel.JSmallTextField(new FileNameDocument()), this.jao.ao, AlbumObject::getName, AlbumObject::setName));
                    break;
                }
                case keywords: {
                    this.formFields.add(new ReadWriteField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, AlbumObject::getKeywords, (ao, kw) -> {
                        ao.setKeywords(kw);
                        WordList knownKeywords = this.jao.context.context.knownKeywords;
                        knownKeywords.addAll(StringUtil.stringToSet(ao.getKeywords()));
                    }){

                        @Override
                        protected void init() {
                            super.init();
                            new Autocompleter(this.comp, DetailsEditor.this.jao.context.context.knownKeywords);
                        }
                    });
                    break;
                }
                case modified: {
                    this.formFields.add(new UndoableReadWriteField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, ao -> df.format(new Date(ao.getLastModified())), (ao, s) -> {
                        Date date = df.parse(s);
                        ao.setLastModified(date.getTime());
                    }).monitorProperty("lastModified"));
                    break;
                }
                case rights: {
                    this.formFields.add(new XmpField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, ao -> ao.getXmpManager().getRights(), (ao, s) -> {
                        XmpManager mgr = ao.getXmpManager();
                        if (mgr != null) {
                            mgr.setRights(s);
                            mgr.save();
                        }
                    }));
                    break;
                }
                case rightsURL: {
                    this.formFields.add(new XmpField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, ao -> ao.getXmpManager().getRightsURL(), (ao, s) -> {
                        XmpManager mgr = ao.getXmpManager();
                        if (mgr != null) {
                            mgr.setRightsURL(s);
                            mgr.save();
                        }
                    }));
                    break;
                }
                case title: {
                    this.formFields.add(new ReadWriteField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, AlbumObject::getTitle, AlbumObject::setTitle));
                    break;
                }
                case dimensions: {
                    this.formFields.add(new ReadOnlyField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, ao -> {
                        if (ao.getCategory() == Category.image) {
                            FileFilters.BasicImageInfo ii = ao.getImageInfo();
                            return ii.width + " x " + ii.height;
                        }
                        throw new DataMissingException();
                    }));
                    break;
                }
                case size: {
                    this.formFields.add(new ReadOnlyField(ft, new JPropertyPanel.JSmallTextField(), this.jao.ao, ao -> {
                        if (!ao.isFolder()) {
                            long size = ao.getFile().length();
                            return DataSizeFormatter.groupByThousands(size) + " bytes (" + String.valueOf(DataSizeFormatter.formatBytes(size)) + ")";
                        }
                        throw new DataMissingException();
                    }));
                }
            }
        }
        for (AbstractField field : this.formFields) {
            this.add("br", field.getLabel());
            if (field.getComponent() instanceof JTextArea) {
                this.add(sep + " hfill vfill", field.getComponent());
                continue;
            }
            this.add(sep + " hfill", field.getComponent());
        }
    }

    static {
        copyAction = new AbstractAction(null, Icons.small("copy")){
            {
                this.putValue("ShortDescription", Msg.get("edit.copy"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DetailsEditor.currentField.comp.isFocusOwner()) {
                    DetailsEditor.currentField.comp.transferFocusUpCycle();
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new FieldClip(currentField), null);
                JAlbumContext.getInstance().getExplorer().flavorChange();
                TipOfTheDay.showInBackground(Msg.get("tip.metadataCopied", Msg.get("edit.pasteSpecified", DetailsEditor.currentField.type.toString())));
                JAlbumContext.getInstance().getFrame().statusBar.setText(Msg.get("tip.metadataCopied", Msg.get("edit.pasteSpecified", DetailsEditor.currentField.type.toString())));
            }
        };
        copyButton = new JPlainButton(copyAction);
        hBox = Box.createHorizontalBox();
        copyButton.setCursor(Cursor.getDefaultCursor());
        copyButton.setOpaque(true);
        hBox.add(Box.createGlue());
        hBox.add(copyButton);
    }

    static abstract class AbstractField<T extends JTextComponent> {
        protected final Config.FieldType type;
        protected final JLabel label;
        protected final T comp;
        protected AlbumObject ao;
        final /* synthetic */ DetailsEditor this$0;

        public AbstractField(Config.FieldType type, T comp, AlbumObject ao) {
            this.this$0 = this$0;
            this.type = type;
            this.comp = comp;
            this.ao = ao;
            this.label = new JPropertyPanel.JSmallLabel(type.toString());
            this.label.setLabelFor((Component)comp);
        }

        JLabel getLabel() {
            return this.label;
        }

        Config.FieldType getType() {
            return this.type;
        }

        JComponent getComponent() {
            return this.comp;
        }

        abstract void refresh();
    }

    private class UndoableReadWriteField
    extends ReadWriteField {
        public UndoableReadWriteField(Config.FieldType type, JTextComponent comp, AlbumObject ao, StringLoader loader, StringSaver saver) {
            StringSaver wrapped;
            super(type, comp, ao, loader, saver);
            this.saver = wrapped = (ao2, s) -> {
                try {
                    String old = loader.get(ao2);
                    saver.accept(ao2, s);
                    ao2.getFactory().getUndoNotifier().undoableEditHappened(this, type.toString(), () -> saver.accept(ao2, old), () -> saver.accept(ao2, s));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            };
        }
    }

    @FunctionalInterface
    static interface StringLoader {
        public String get(AlbumObject var1) throws Exception;
    }

    @FunctionalInterface
    static interface StringSaver {
        public void accept(AlbumObject var1, String var2) throws Exception;
    }

    private class ReadOnlyField
    extends AbstractField
    implements PropertyChangeListener {
        protected String originalText;
        protected final StringLoader loader;

        public ReadOnlyField(Config.FieldType type, JTextComponent comp, AlbumObject ao, StringLoader loader) {
            super(DetailsEditor.this, type, comp, ao);
            this.originalText = "";
            this.loader = loader;
            this.init();
            comp.addKeyListener(new KeyAdapter(this){
                final /* synthetic */ ReadOnlyField this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        this.this$1.refresh();
                        this.this$1.DetailsEditor.this.jao.requestFocusInWindow();
                    }
                }
            });
        }

        public ReadOnlyField monitorProperty(String name) {
            this.ao.addPropertyChangeListener(name, this);
            return this;
        }

        protected void init() {
            this.comp.setEditable(false);
        }

        @Override
        public void refresh() {
            try {
                this.originalText = this.loader.get(this.ao);
                if (this.originalText == null) {
                    this.originalText = "";
                }
                SwingUtilities.invokeLater(() -> this.comp.setText(this.originalText));
                return;
            }
            catch (Exception exception) {
                this.label.setEnabled(false);
                this.comp.setEnabled(false);
                return;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refresh();
        }
    }

    class ReadWriteField
    extends ReadOnlyField {
        public StringSaver saver;

        public ReadWriteField(Config.FieldType type, JTextComponent comp, AlbumObject ao, StringLoader loader, StringSaver saver) {
            super(type, comp, ao, loader);
            this.saver = saver;
        }

        @Override
        protected void init() {
            if (this.comp instanceof JTextField) {
                ((JTextField)this.comp).addActionListener(ae -> this.comp.transferFocus());
            }
            if (this.comp instanceof SmartTextComponent) {
                ((SmartTextComponent)((Object)this.comp)).getSupport().installHoverButton(copyAction);
            }
            this.comp.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!ReadWriteField.this.comp.getText().equals(ReadWriteField.this.originalText)) {
                        try {
                            ReadWriteField.this.saver.accept(ReadWriteField.this.ao, ReadWriteField.this.comp.getText());
                            ReadWriteField.this.originalText = ReadWriteField.this.comp.getText();
                        }
                        catch (Exception ex) {
                            Debug.showFriendlyErrorDialog(DetailsEditor.this, ex);
                        }
                    }
                }
            });
            this.comp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!SwingUtilities.getLocalBounds(ReadWriteField.this.comp).contains(e.getPoint())) {
                        currentField = null;
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    currentField = ReadWriteField.this;
                }
            });
        }
    }

    private class JSmallSyntaxTextArea
    extends JSmartSyntaxTextArea {
        public JSmallSyntaxTextArea() {
            this.initialize();
        }

        public JSmallSyntaxTextArea(int rows, int columns) {
            super(rows, columns);
            this.initialize();
        }

        public JSmallSyntaxTextArea bordered() {
            Border border = new JPropertyPanel.JSmallTextField().getBorder();
            this.setBorder(border);
            return this;
        }

        private void initialize() {
            this.bordered();
            this.spelling();
            this.setAllowHTMLEditing(true);
            if (DetailsEditor.this.jao.ao.getCategory() == Category.webPage) {
                this.setFullHTMLEditing(true);
            }
            if (Platform.isMac()) {
                this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            }
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }
    }

    private class XmpField
    extends UndoableReadWriteField
    implements PropertyChangeListener {
        public XmpField(Config.FieldType type, JTextComponent comp, AlbumObject ao, StringLoader loader, StringSaver saver) {
            super(type, comp, ao, loader, saver);
        }

        @Override
        protected void init() {
            super.init();
            XmpManager mgr = this.ao.getXmpManager();
            if (mgr != null) {
                mgr.addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refresh();
        }

        protected void setAndSave(String s) {
        }
    }

    private static class DataMissingException
    extends Exception {
    }

    public static class FieldClip
    implements Transferable {
        public final ReadWriteField field;
        public final String stringValue;
        private static final DataFlavor[] flavors = new DataFlavor[]{fieldFlavor, DataFlavor.stringFlavor};

        public FieldClip(ReadWriteField field) {
            this.field = field;
            this.stringValue = field.comp.getText();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])flavors.clone();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor df : flavors) {
                if (!flavor.equals(df)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(fieldFlavor)) {
                return this;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.stringValue;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

