/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;

class Cache
extends HashMap {
    private int maxSize;
    LinkedList recentKeys = new LinkedList();

    public Cache(int maxSize) {
        super(maxSize);
        this.maxSize = maxSize;
    }

    @Override
    public Object get(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        this.recentKeys.remove(key);
        this.recentKeys.addFirst(key);
        Object o = ((Reference)super.get(key)).get();
        if (o == null) {
            this.recentKeys.remove(key);
            super.remove(key);
        }
        return o;
    }

    @Override
    public Object put(Object key, Object value) {
        this.recentKeys.remove(key);
        this.recentKeys.addFirst(key);
        if (this.recentKeys.size() > this.maxSize) {
            super.remove(this.recentKeys.removeLast());
        }
        return super.put(key, new SoftReference<Object>(value));
    }
}

