/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;

public class AlbumObjectTransferable
implements Transferable {
    public static final DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String", "URI List");
    private final List<AlbumObject> selectedObjects;

    public AlbumObjectTransferable(List<AlbumObject> selectedObjects) {
        this.selectedObjects = selectedObjects;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(AlbumObject.albumObjectFlavor)) {
            return this.selectedObjects;
        }
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            ArrayList fileList = new ArrayList();
            this.selectedObjects.forEach(ao -> fileList.add(ao.getFile()));
            return fileList;
        }
        if (flavor.equals(uriListFlavor)) {
            return this.selectedObjects.stream().map(ao -> {
                File file;
                if (ao.getFile() instanceof LinkFile) {
                    LinkFile cfr_ignored_0 = (LinkFile)ao.getFile();
                    file = LinkFile.getResolvedTarget(ao);
                } else {
                    file = ao.getFile();
                }
                return file;
            }).map(f -> LinkFile.targetOf(f).toURI().toString()).collect(Collectors.joining("\r\n"));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{AlbumObject.albumObjectFlavor, DataFlavor.javaFileListFlavor, uriListFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.stream(this.getTransferDataFlavors()).anyMatch(fl -> flavor.equals((DataFlavor)fl));
    }
}

