/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.WaitCursor;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.util.Debug;

abstract class AbstractEditor
extends JAlbumObject.LabelEditor {
    static KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
    static KeyStroke altEnterStroke = KeyStroke.getKeyStroke(10, 512);
    static KeyStroke shiftEnterStroke = KeyStroke.getKeyStroke(10, 64);
    protected AlbumObject ao;
    private boolean editing;
    protected WrappableJLabel label = new WrappableJLabel(){

        @Override
        public int getPreferredWidth() {
            return AbstractEditor.this.jao.context.getIconBounds().width;
        }
    };
    protected JSmartTextArea editArea;
    Dimension lastCaptionAreaDimension = new Dimension(0, 0);
    private JScrollPane scrollPane = new JScrollPane(21, 31);
    private Color deselectedTextColor = this.getTextColor();

    public abstract String readText();

    public abstract void writeText(String var1) throws IOException;

    public abstract String getPromptText();

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.remove(this.scrollPane);
        this.scrollPane.setViewportView(null);
        this.editArea = null;
    }

    public AbstractEditor(JAlbumObject jao) {
        super(jao);
        this.ao = jao.ao;
        this.init();
    }

    protected Color getTextColor() {
        UIDefaults defaults = UIManager.getDefaults();
        Color c = defaults.getColor("TextArea.foreground");
        return c != null ? c : JAlbumColor.textText;
    }

    protected JTextArea getEditArea() {
        if (this.editArea == null) {
            this.editArea = new JSmartTextArea(2, 10){
                {
                    this.spelling();
                    this.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent event) {
                            if (event.getKeyCode() == 9 || event.getKeyChar() == '\t') {
                                JAlbumObject.tabCycling = true;
                                if (event.isShiftDown()) {
                                    AbstractEditor.this.jao.transferFocusBackward();
                                } else {
                                    AbstractEditor.this.editArea.transferFocus();
                                }
                                event.consume();
                            }
                        }
                    });
                }

                @Override
                public boolean isManagingFocus() {
                    return true;
                }
            };
            this.editArea.setForeground(this.getTextColor());
            this.editArea.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        AbstractEditor.this.setEditing(false);
                    }
                }
            });
            this.editArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        AbstractEditor.this.editArea.setText(AbstractEditor.this.readText());
                        AbstractEditor.this.setEditing(false);
                    }
                }
            });
            this.editArea.setFont(this.label.getFont());
            this.editArea.setText(this.label.getText());
            this.editArea.setLineWrap(true);
            this.editArea.setWrapStyleWord(true);
            this.editArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    AbstractEditor.this.updateCaptionAreaSize();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    AbstractEditor.this.updateCaptionAreaSize();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    AbstractEditor.this.updateCaptionAreaSize();
                }
            });
            AbstractAction myEnterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AbstractEditor.this.setEditing(false);
                }
            };
            InputMap im = this.editArea.getInputMap();
            Object enterActionKeyName = im.get(enterStroke);
            im.put(altEnterStroke, enterActionKeyName);
            im.put(shiftEnterStroke, enterActionKeyName);
            im.put(enterStroke, myEnterAction);
            this.scrollPane.setViewportView(this.editArea);
            this.add((Component)this.scrollPane, "South");
        }
        return this.editArea;
    }

    private void init() {
        this.label.setOpaque(false);
        this.label.setHorizontalAlignment(0);
        int w = this.jao.context.getIconBounds().width;
        Border originalScrollBorder = this.scrollPane.getBorder();
        if (originalScrollBorder != null) {
            Insets in = originalScrollBorder.getBorderInsets(this.scrollPane);
            Border emptyBorder = BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right);
            this.label.setBorder(emptyBorder);
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)this.label, "North");
        this.scrollPane.setVisible(false);
        this.add((Component)this.scrollPane, "South");
        this.jao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getButton() == 0 && AbstractEditor.this.readText().length() == 0) {
                    AbstractEditor.this.label.setText(AbstractEditor.this.getPromptText());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AbstractEditor.this.refresh();
            }
        });
    }

    private void updateCaptionAreaSize() {
        SwingUtilities.invokeLater(() -> {
            Dimension dim = this.getEditArea().getPreferredSize();
            if (!dim.equals(this.lastCaptionAreaDimension)) {
                this.lastCaptionAreaDimension = dim;
                Insets in = new Insets(0, 0, 0, 0);
                Border originalScrollBorder = this.scrollPane.getBorder();
                if (originalScrollBorder != null) {
                    in = originalScrollBorder.getBorderInsets(this.scrollPane);
                }
                dim = this.editArea.getPreferredSize();
                dim.width += in.left + in.right;
                dim.height += in.top + in.bottom;
                this.scrollPane.setPreferredSize(dim);
                this.revalidate();
            }
        });
    }

    @Override
    void setEditing(boolean editing) {
        if (this.editing == editing) {
            return;
        }
        this.editing = editing;
        if (this.editArea != null && this.editArea.hasFocus()) {
            this.jao.requestFocusInWindow();
        }
        this.scrollPane.setVisible(editing);
        this.label.setVisible(!editing);
        if (editing) {
            this.getEditArea();
            this.editArea.setInitialText(this.readText());
            this.validate();
            this.repaint();
            this.editArea.requestFocusInWindow();
            this.updateCaptionAreaSize();
        } else {
            String newText;
            if (this.editArea != null && !(newText = this.editArea.getText()).equals(this.readText())) {
                try (WaitCursor.WaitToken _wt = new WaitCursor.WaitToken(this);){
                    this.writeText(newText);
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(this, ex);
                }
            }
            this.refresh();
            this.validate();
            this.repaint();
        }
    }

    @Override
    void refresh() {
        String text = this.readText();
        JAlbumUtilities.runOnAWT(() -> {
            if ("".equals(text)) {
                this.deselectedTextColor = JAlbumColor.textInactiveText;
                this.label.setText(this.ao.getName());
            } else {
                this.deselectedTextColor = this.getTextColor();
                this.label.setText(text);
            }
            this.label.setForeground(this.jao.isSelected() ? JAlbumColor.textHighlightText : this.deselectedTextColor);
        });
    }

    @Override
    boolean isEditing() {
        return this.editing;
    }

    @Override
    void setSelected(boolean selected) {
        if (selected) {
            this.label.setOpaque(true);
            this.label.setForeground(JAlbumColor.textHighlightText);
            this.label.setBackground(JAlbumColor.textHighlight);
        } else {
            this.label.setOpaque(false);
            this.label.setForeground(this.deselectedTextColor);
        }
    }
}

