/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.tags;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;

public class TagsTransferable
implements Transferable {
    public static final DataFlavor tagsFlavor = new DataFlavor(String[].class, "Tags");
    private static DataFlavor[] flavors = new DataFlavor[]{tagsFlavor, DataFlavor.stringFlavor};
    private Collection<String> tags;

    public TagsTransferable(Collection<String> tags) {
        this.tags = tags;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor fl : flavors) {
            if (!fl.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(tagsFlavor)) {
            return this.tags;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            StringBuilder buf = new StringBuilder();
            for (String tag : this.tags) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(tag);
            }
            return buf.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

