/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.plaf.ListUI;
import net.jalbum.util.Work;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.WordList;
import se.datadosen.component.tags.FlowListUI;
import se.datadosen.component.tags.TagListTransferHandler;
import se.datadosen.component.tags.TagRenderer;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.IncludeOption;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JTagPicker
extends JPanel {
    @Text(value="ui.renameKeywords")
    Action renameAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String oldKeyword = JTagPicker.this.tagList.getSelectedValue();
            String newKeyword = JOptionPane.showInputDialog(JTagPicker.this, Msg.get("ui.renameKeywords"), oldKeyword);
            if (newKeyword != null && !newKeyword.equals(oldKeyword)) {
                Work.on(JTagPicker.this.getTarget()).titled(Msg.get("ui.renameKeywords")).forEach((ao, counter) -> {
                    Set<String> keywords = ao.getKeywordSet();
                    if (keywords.remove(oldKeyword)) {
                        keywords.add(newKeyword);
                        ao.setKeywords(keywords);
                        counter.incrementAndGet();
                    }
                }).execute(work -> {
                    if (work.getProcessed() > 0L) {
                        WordList knownKeywords = JAlbumContext.getInstance().getExplorer().knownKeywords;
                        knownKeywords.remove(oldKeyword);
                        knownKeywords.add(newKeyword);
                    }
                }).showResult();
            }
        }
    };
    @Text(value="ui.deleteKeywords")
    Action deleteAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            List<String> oldOnes = JTagPicker.this.tagList.getSelectedValuesList();
            Work.on(JTagPicker.this.getTarget()).titled(Msg.get("ui.deleteKeywords")).forEach((ao, counter) -> {
                Set<String> keywords = ao.getKeywordSet();
                if (keywords.removeAll(oldOnes)) {
                    ao.setKeywords(keywords);
                    counter.incrementAndGet();
                }
            }).execute(work -> {
                if (work.getProcessed() > 0L) {
                    WordList knownKeywords = JAlbumContext.getInstance().getExplorer().knownKeywords;
                    for (String kw : oldOnes) {
                        knownKeywords.remove(kw);
                    }
                }
            }).showResult();
        }
    };
    @ToolTipText(value="ui.tipLabel")
    JList<String> tagList;
    @ToolTipText(value="close")
    private final JButton closeButton = new JPlainButton(Icons.small("abort"), Icons.small("abort-1"));

    private TreeCollection getTarget() {
        JAlbumExplorer explorer = JAlbumContext.getInstance().getExplorer();
        List<AlbumObject> sel = explorer.explorer.listSelectedAlbumObjects();
        if (sel.isEmpty()) {
            return explorer.getCurrentFolder().getDescendants(IncludeOption.EXCLUDED_FILES, IncludeOption.HIDDEN);
        }
        return new TreeCollection(sel, EnumSet.of(IncludeOption.EXCLUDED_FILES, IncludeOption.HIDDEN));
    }

    public JTagPicker(ListModel model) {
        super(new BorderLayout());
        this.init(model);
    }

    private void init(ListModel model) {
        this.tagList = new JList(model){
            private ListUI myUI;

            @Override
            public ListUI getUI() {
                if (this.myUI == null) {
                    this.myUI = new FlowListUI();
                }
                return this.myUI;
            }

            @Override
            public void setUI(ListUI ui) {
                super.setUI(this.getUI());
            }
        };
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.closeButton.addActionListener(e -> this.setVisible(false));
        this.tagList.setOpaque(false);
        this.setBackground(JAlbumColor.text);
        this.tagList.setLayoutOrientation(2);
        this.tagList.setPrototypeCellValue(null);
        this.tagList.setVisibleRowCount(-1);
        this.tagList.setDragEnabled(true);
        this.tagList.setTransferHandler(new TagListTransferHandler());
        this.tagList.setCellRenderer(new TagRenderer());
        this.tagList.addMouseListener(new MouseAdapter(){

            private void handle(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int index = JTagPicker.this.tagList.locationToIndex(e.getPoint());
                    if (!JTagPicker.this.tagList.isSelectedIndex(index)) {
                        JTagPicker.this.tagList.setSelectedIndex(index);
                    }
                    JTagPicker.this.tagList.getSelectionModel().setAnchorSelectionIndex(1);
                    List<String> selected = JTagPicker.this.tagList.getSelectedValuesList();
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(JTagPicker.this.renameAction);
                    menu.add(JTagPicker.this.deleteAction);
                    JTagPicker.this.renameAction.setEnabled(selected.size() == 1);
                    JTagPicker.this.deleteAction.setEnabled(selected.size() > 0);
                    menu.show(JTagPicker.this, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.handle(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handle(e);
            }
        });
        this.add(this.tagList, "Center");
        this.add((Component)this.closeButton, "East");
        Msg.maintainTranslated(this);
    }
}

