/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.tags;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicListUI;

public class FlowListUI
extends BasicListUI
implements ListSelectionListener {
    private int getAncestorWidth(Component c) {
        int width = c.getWidth();
        if (width > 0) {
            return width;
        }
        if (c.getParent() != null) {
            return width + this.getAncestorWidth(c.getParent());
        }
        return 0;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int ancestorWidth = this.getAncestorWidth(this.list);
        if (this.list.getWidth() != ancestorWidth) {
            this.list.setSize(ancestorWidth, this.list.getWidth());
        }
        Rectangle bounds = this.getCellBounds(this.list, 0, this.list.getModel().getSize());
        Dimension pref = bounds.getSize();
        pref.width = ancestorWidth;
        return pref;
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.list.removeListSelectionListener(this);
        super.uninstallUI(c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.list.addListSelectionListener(this);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ListModel model = this.list.getModel();
        ListCellRenderer renderer = this.list.getCellRenderer();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform backup = g2d.getTransform();
        FlowingLayout fl = new FlowingLayout(c);
        for (int i = 0; i < model.getSize(); ++i) {
            Object o = model.getElementAt(i);
            Component stamp = renderer.getListCellRendererComponent(this.list, o, i, this.list.isSelectedIndex(i), false);
            Dimension dim = stamp.getPreferredSize();
            Rectangle bounds = fl.next(dim);
            stamp.setBounds(bounds);
            g2d.translate(bounds.x, bounds.y);
            stamp.paint(g2d);
            g2d.setTransform(backup);
        }
    }

    public int locationToIndex(JList list, Point location) {
        FlowingLayout fl = new FlowingLayout(list);
        ListModel model = list.getModel();
        ListCellRenderer renderer = list.getCellRenderer();
        for (int i = 0; i < model.getSize(); ++i) {
            Object o = model.getElementAt(i);
            Component stamp = renderer.getListCellRendererComponent(list, o, i, list.isSelectedIndex(i), false);
            Dimension dim = stamp.getPreferredSize();
            Rectangle bounds = fl.next(dim);
            if (!bounds.contains(location)) continue;
            return i;
        }
        return -1;
    }

    public Point indexToLocation(JList list, int index) {
        Rectangle bounds = this.getCellBounds(list, index, index);
        Point p = bounds.getLocation();
        p.translate(bounds.width / 2, bounds.height / 2);
        return p;
    }

    public Rectangle getCellBounds(JList list, int index1, int index2) {
        int i;
        if (index2 < index1) {
            int temp = index2;
            index2 = index1;
            index1 = temp;
        }
        FlowingLayout fl = new FlowingLayout(list);
        ListModel model = list.getModel();
        int size = model.getSize();
        ListCellRenderer renderer = list.getCellRenderer();
        Rectangle bounds1 = new Rectangle();
        for (i = 0; i <= index1 && i < size; ++i) {
            Object o = model.getElementAt(i);
            Component stamp = renderer.getListCellRendererComponent(list, o, i, list.isSelectedIndex(i), false);
            Dimension dim = stamp.getPreferredSize();
            bounds1 = fl.next(dim);
        }
        bounds1 = new Rectangle(bounds1);
        Rectangle bounds2 = new Rectangle(bounds1);
        while (i <= index2 && i < size) {
            Object o = model.getElementAt(i);
            Component stamp = renderer.getListCellRendererComponent(list, o, i, list.isSelectedIndex(i), false);
            Dimension dim = stamp.getPreferredSize();
            bounds2 = fl.next(dim);
            ++i;
        }
        Rectangle union = bounds1.union(bounds2);
        return union;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.list.repaint();
    }

    private class FlowingLayout {
        private Component c;
        private Rectangle r = new Rectangle();

        public FlowingLayout(Component c) {
            this.c = c;
        }

        public Rectangle next(Dimension dim) {
            return this.next(dim.width, dim.height);
        }

        public Rectangle next(int width, int height) {
            if (this.r.x + this.r.width + width > this.c.getWidth()) {
                this.r.x = 0;
                this.r.y += height;
            } else {
                this.r.x += this.r.width;
            }
            this.r.width = width;
            this.r.height = height;
            return this.r;
        }
    }
}

