/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.buttonbar;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.datadosen.component.buttonbar.JAlbumButtonBarUI;
import se.datadosen.component.buttonbar.JButtonBar;
import se.datadosen.jalbum.JAlbumColor;

public class JButtonBarPane
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private JButtonBar buttonBar;
    private JPanel slackPanel = new JPanel(new BorderLayout());
    private ButtonGroup buttonGroup;
    private JPanel tabHolder;
    CardLayout holderLayout;
    private ArrayList listeners = new ArrayList();
    private Component selectedComponent = null;

    public JButtonBarPane() {
        this(0);
    }

    public JButtonBarPane(int orientation) {
        this.buttonGroup = new ButtonGroup();
        this.holderLayout = new CardLayout();
        this.tabHolder = new JPanel(this.holderLayout);
        this.buttonBar = new JButtonBar(orientation);
        this.buttonBar.setUI(new JAlbumButtonBarUI());
        this.setLayout(new BorderLayout());
        JPanel buttonBarPanel = new JPanel(new BorderLayout());
        buttonBarPanel.add(this.buttonBar);
        buttonBarPanel.add((Component)this.slackPanel, orientation == 0 ? "After" : "South");
        JPanel lineBorderPanel = new JPanel();
        lineBorderPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("Separator.foreground")));
        buttonBarPanel.add((Component)lineBorderPanel, "South");
        this.add((Component)buttonBarPanel, orientation == 0 ? "North" : "West");
        this.add((Component)this.tabHolder, "Center");
        this.registerArrowAccelerators();
    }

    public JComponent getButtonBar() {
        return this.buttonBar;
    }

    public JPanel getTabHolder() {
        return this.tabHolder;
    }

    public JPanel getSlackPanel() {
        return this.slackPanel;
    }

    private void registerArrowAccelerators() {
        this.buttonBar.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "nextTab");
        this.buttonBar.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "previousTab");
        this.buttonBar.getActionMap().put("nextTab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nextIndex = JButtonBarPane.this.indexOfTab(JButtonBarPane.this.getSelectedComponent()) + 1;
                if (nextIndex < JButtonBarPane.this.buttonBar.getComponentCount()) {
                    Component nextComponent = JButtonBarPane.this.buttonBar.getComponent(nextIndex);
                    JButtonBarPane.this.show(nextComponent);
                }
            }
        });
        this.buttonBar.getActionMap().put("previousTab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int previousIndex = JButtonBarPane.this.indexOfTab(JButtonBarPane.this.getSelectedComponent()) - 1;
                if (previousIndex >= 0) {
                    Component previousComponent = JButtonBarPane.this.buttonBar.getComponent(previousIndex);
                    JButtonBarPane.this.show(previousComponent);
                }
            }
        });
    }

    public void addTab(String title, Icon icon, Component tab) {
        this.createTab(title, icon, tab);
    }

    private void createTab(String title, Icon icon, final Component component) {
        AbstractAction buttonPressed = new AbstractAction(this, title, icon){
            final /* synthetic */ JButtonBarPane this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.show(component);
            }
        };
        JToggleButton button = new JToggleButton(buttonPressed){

            @Override
            public void setSelected(boolean b) {
                this.setForeground(b ? JAlbumColor.textHighlightText : JAlbumColor.textText);
                super.setSelected(b);
            }
        };
        button.setFocusable(false);
        String key = "tab nr " + this.buttonBar.getComponentCount();
        component.setName(key);
        button.setName(key);
        this.tabHolder.add(component, key);
        this.buttonGroup.add(button);
        this.buttonBar.add(button);
        if (this.buttonGroup.getSelection() == null) {
            button.setSelected(true);
            this.show(component);
        }
        this.buttonBar.repaint();
    }

    public void show(Component tab) {
        Component[] buttons;
        String key = tab.getName();
        this.holderLayout.show(this.tabHolder, key);
        for (Component button1 : buttons = this.buttonBar.getComponents()) {
            JToggleButton button = (JToggleButton)button1;
            button.setSelected(key.equals(button.getName()));
        }
        this.selectedComponent = tab;
        this.fireChangeEvent();
    }

    public int indexOfTab(Component tab) {
        if (tab == null || tab.getName() == null) {
            return -1;
        }
        String key = tab.getName();
        Component[] buttons = this.buttonBar.getComponents();
        for (int i = 0; i < buttons.length; ++i) {
            JToggleButton button = (JToggleButton)buttons[i];
            if (!key.equals(button.getName())) continue;
            return i;
        }
        return -1;
    }

    public Component getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setTitleAt(int index, String title) {
        JToggleButton button = (JToggleButton)this.buttonBar.getComponent(index);
        button.setText(title);
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private synchronized void fireChangeEvent() {
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(ce);
        }
    }

    @Override
    public void remove(Component c) {
        Component[] buttons;
        if (c == null || c.getName() == null) {
            return;
        }
        this.tabHolder.remove(c);
        if (c.equals(this.selectedComponent)) {
            this.holderLayout.first(this.tabHolder);
            this.selectedComponent = this.tabHolder.getComponent(0);
        }
        for (Component button : buttons = this.buttonBar.getComponents()) {
            if (!c.getName().equals(button.getName())) continue;
            this.buttonBar.remove(button);
            break;
        }
        this.buttonBar.repaint();
    }
}

