/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.buttonbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import se.datadosen.jalbum.JAlbumColor;

class JAlbumButtonUI
extends BasicButtonUI {
    private static Color hoverColor = JAlbumColor.blend(JAlbumColor.textHighlight, JAlbumColor.control);

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        AbstractButton button = (AbstractButton)c;
        button.setRolloverEnabled(true);
        button.setBorder(BorderFactory.createEmptyBorder(4, 2, 2, 2));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferred = super.getPreferredSize(c);
        return new Dimension(preferred.width < 59 ? 59 : preferred.width, preferred.height);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        if (model.isRollover() || model.isArmed() || model.isSelected()) {
            Color oldColor = g.getColor();
            if (model.isSelected()) {
                g.setColor(JAlbumColor.textHighlight);
            } else {
                g.setColor(JAlbumColor.control);
            }
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            if (model.isRollover()) {
                g.setColor(hoverColor);
            }
            if (model.isSelected()) {
                g.setColor(JAlbumColor.textHighlight);
            }
            if (model.isArmed()) {
                g.setColor(g.getColor().darker());
            }
            g.fillRect(1, 0, c.getWidth() - 2, c.getHeight());
            g.setColor(oldColor);
        }
        super.paint(g, c);
    }
}

