/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;

public class WordList {
    private List<String> list;
    private Map<String, String> words = new TreeMap<String, String>();
    private WordListModel model = new WordListModel();

    public synchronized List<String> getList() {
        if (this.list == null) {
            this.list = new ArrayList<String>(this.words.keySet());
        }
        return this.list;
    }

    public synchronized String remove(String word) {
        int index = 0;
        for (Map.Entry<String, String> e : this.words.entrySet()) {
            String key = word.toLowerCase();
            if (e.getKey().equals(key)) {
                this.words.remove(key);
                this.model.fireIntervalRemoved(this.words, index, index);
                return word;
            }
            ++index;
        }
        return null;
    }

    public synchronized boolean add(String word) {
        String oldWord = this.words.put(word.toLowerCase(), word);
        if (oldWord == null) {
            this.model.fireIntervalAdded(this.words, this.words.size() - 1, this.words.size() - 1);
        }
        return !word.equals(oldWord);
    }

    public synchronized boolean addAll(Collection<String> newWords) {
        boolean changed = false;
        for (String word : newWords) {
            String oldWord;
            if (word.equals(oldWord = this.words.put(word.toLowerCase(), word))) continue;
            changed = true;
        }
        if (changed) {
            this.list = null;
            this.model.fireContentsChanged(this.words, 0, this.words.size() - 1);
        }
        return changed;
    }

    public String get(String key) {
        return this.words.get(key);
    }

    public void clear() {
        int size = this.words.size();
        this.words.clear();
        this.list = null;
        this.model.fireIntervalRemoved(this.words, 0, size);
    }

    public ListModel getModel() {
        return this.model;
    }

    private class WordListModel
    extends AbstractListModel {
        private WordListModel() {
        }

        @Override
        public int getSize() {
            return WordList.this.words.size();
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            super.fireIntervalAdded(source, index0, index1);
        }

        @Override
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            super.fireIntervalRemoved(source, index0, index1);
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getElementAt(int index) {
            WordList wordList = WordList.this;
            synchronized (wordList) {
                ArrayList<String> values = new ArrayList<String>(WordList.this.words.values());
                return values.get(index);
            }
        }
    }
}

