/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import se.datadosen.component.ToggleAction;

public class ToggleAliasAction
extends ToggleAction
implements PropertyChangeListener {
    protected Action target;
    protected Set<String> blockedKeys = new HashSet<String>();

    public ToggleAliasAction(Action target) {
        this.target = target;
        this.copyValue("AcceleratorKey");
        this.copyValue("ActionCommandKey");
        this.copyValue("SwingDisplayedMnemonicIndexKey");
        this.copyValue("SwingLargeIconKey");
        this.copyValue("LongDescription");
        this.copyValue("MnemonicKey");
        this.copyValue("Name");
        this.copyValue("SwingSelectedKey");
        this.copyValue("ShortDescription");
        this.copyValue("SmallIcon");
        this.setEnabled(target.isEnabled());
        target.addPropertyChangeListener(this);
    }

    public ToggleAliasAction(Action target, String name) {
        this(target);
        this.putValue("Name", name);
    }

    public ToggleAliasAction(Action target, Icon icon) {
        this(target);
        this.putValue("SmallIcon", icon);
    }

    private void copyValue(String key) {
        super.putValue(key, this.target.getValue(key));
    }

    @Override
    public void putValue(String key, Object newValue) {
        if (this.blockedKeys != null) {
            this.blockedKeys.add(key);
        }
        super.putValue(key, newValue);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.target.actionPerformed(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (!this.blockedKeys.contains(key)) {
            super.putValue(key, evt.getNewValue());
        }
    }
}

