/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.border.Border;
import se.datadosen.component.Hour;

public class SpeechBubbleBorder
implements Border {
    private Side tipSide = Side.TOP;
    private TipPosition tipPosition = TipPosition.LAST;
    private int r = 6;
    private int padding = 12;
    private int tipHeight = 8;
    private int outlineThickness = 2;
    private Color outlineColor = Color.black;

    public SpeechBubbleBorder(Hour tip) {
        this.tipSide = Side.values()[(tip.value() + 1) / 3 % 4];
        this.tipPosition = TipPosition.values()[(tip.value() + 1 - this.tipSide.ordinal() * 3) % 3];
    }

    private void appendSide(GeneralPath path, int s, int rotations) {
        GeneralPath side = new GeneralPath();
        side.moveTo(0.0f, 0.0f);
        int tipDistance = 0;
        if (rotations == this.tipSide.ordinal()) {
            switch (this.tipPosition.ordinal()) {
                case 0: {
                    tipDistance = this.tipHeight;
                    break;
                }
                case 1: {
                    tipDistance = s / 2 - this.tipHeight;
                    break;
                }
                default: {
                    tipDistance = s - 3 * this.tipHeight - this.r;
                }
            }
            side.lineTo(tipDistance, 0.0f);
            side.lineTo(tipDistance + this.tipHeight, -this.tipHeight);
            side.lineTo(tipDistance + 2 * this.tipHeight, 0.0f);
        }
        side.lineTo(s - this.r, 0.0f);
        side.curveTo(s - this.r, 0.0f, s, 0.0f, s, this.r);
        Point2D p = path.getCurrentPoint();
        AffineTransform tr = AffineTransform.getTranslateInstance(p.getX(), p.getY());
        tr.concatenate(AffineTransform.getQuadrantRotateInstance(rotations, 0.0, 0.0));
        path.append(side.createTransformedShape(tr), true);
    }

    int getTipOffset() {
        return this.outlineThickness + this.r + this.tipHeight + this.tipHeight;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHints(qualityHints);
        g2d.setPaint(c.getBackground());
        AffineTransform backup = g2d.getTransform();
        int w = width - this.outlineThickness;
        int h = height - this.outlineThickness;
        g2d.translate(this.outlineThickness / 2, this.outlineThickness / 2);
        if (this.tipSide == Side.TOP) {
            g2d.translate(0, this.tipHeight);
        }
        if (this.tipSide == Side.LEFT) {
            g2d.translate(this.tipHeight, 0);
        }
        int[] sides = new int[]{w, h, w, h};
        int n = (this.tipSide.ordinal() + 1) % 4;
        sides[n] = sides[n] - this.tipHeight;
        int n2 = (this.tipSide.ordinal() + 3) % 4;
        sides[n2] = sides[n2] - this.tipHeight;
        GeneralPath path = new GeneralPath();
        path.moveTo(this.r, 0.0f);
        for (int i = 0; i < 4; ++i) {
            int s = sides[i];
            this.appendSide(path, s - this.r, i);
        }
        path.closePath();
        g2d.fill(path);
        g2d.setPaint(this.outlineColor);
        g2d.draw(path);
        path.toString();
        g2d.setTransform(backup);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int[] i = new int[]{this.padding, this.padding, this.padding, this.padding};
        int n = this.tipSide.ordinal();
        i[n] = i[n] + this.tipHeight;
        return new Insets(i[0], i[3], i[2], i[1]);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private static enum Side {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }

    private static enum TipPosition {
        FIRST,
        CENTERED,
        LAST;

    }
}

