/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.adapter.JavaBeanBooleanPropertyBuilder;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class SmartAction<T extends SmartAction>
extends AbstractAction {
    public final String BLOCKED_KEY = "blocked";
    private BooleanProperty enabledProperty;

    public SmartAction() {
        try {
            this.enabledProperty = JavaBeanBooleanPropertyBuilder.create().bean((Object)this).name("enabled").build();
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    public T accelerator(KeyStroke ks) {
        this.putValue("AcceleratorKey", ks);
        return (T)this;
    }

    public T toolTip(String toolTip) {
        this.putValue("ShortDescription", toolTip);
        return (T)this;
    }

    public T enabled(boolean e) {
        this.setEnabled(e);
        return (T)this;
    }

    public SmartAction(String name) {
        super(name);
        try {
            this.enabledProperty = JavaBeanBooleanPropertyBuilder.create().bean((Object)this).name("enabled").build();
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        this.setEnabled(this.enabled);
    }

    public SmartAction(String name, Icon icon) {
        super(name, icon);
        try {
            this.enabledProperty = JavaBeanBooleanPropertyBuilder.create().bean((Object)this).name("enabled").build();
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    public BooleanProperty enabledProperty() {
        return this.enabledProperty;
    }

    public void setBlocked(boolean blocked) {
        this.putValue("blocked", blocked);
    }

    public boolean isBlocked() {
        return Boolean.TRUE.equals(this.getValue("blocked"));
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (!this.isBlocked()) {
            super.setEnabled(newValue);
        }
    }
}

