/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JTextArea;

public class RiverLayout2
implements LayoutManager {
    public static final String LINE_BREAK = "br";
    public static final String PARAGRAPH_BREAK = "p";
    public static final String TAB_STOP = "tab";
    public static final String HFILL = "hfill";
    public static final String VFILL = "vfill";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String CENTER = "center";
    public static final String VTOP = "vtop";
    public static final String VCENTER = "vcenter";
    public static final String VBOTTOM = "vbottom";
    public static final String LABEL = "label";
    List<Row> rows;
    int hgap = 9;
    int vgap = 5;
    int width;
    int height;
    int rowsWithVfillCount;
    String valign = "vcenter";
    Map<Component, String> constraints = new HashMap<Component, String>();

    public RiverLayout2() {
    }

    public RiverLayout2(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.constraints.put(comp, name);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension size = this.getLayoutSize(target, Component::getPreferredSize);
        return size;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension size = this.getLayoutSize(target, Component::getMinimumSize);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getLayoutSize(Container target, Function<Component, Dimension> sizeFunc) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this.init(target);
            int tabIndex = 0;
            Ruler ruler = this.calcTabs(target);
            int maxRowWidth = 0;
            int totalRowHeight = 0;
            for (Row row : this.rows) {
                int maxRowHeight = 0;
                tabIndex = 0;
                for (Component c : row.cols) {
                    Dimension compSize = sizeFunc.apply(c);
                    if (this.hasConstraint(c, TAB_STOP)) {
                        row.width = ruler.getTab(tabIndex++);
                    } else if (row.width > 0) {
                        row.width += this.hgap;
                    }
                    row.width += compSize.width;
                    maxRowHeight = Math.max(maxRowHeight, compSize.height);
                }
                row.height = maxRowHeight;
                totalRowHeight += row.gap + row.height;
                maxRowWidth = Math.max(maxRowWidth, row.width);
            }
            Insets in = target.getInsets();
            Dimension dim = new Dimension(in.left + maxRowWidth + in.right, in.top + totalRowHeight + in.bottom);
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this.init(target);
            int tabIndex = 0;
            Ruler ruler = this.calcTabs(target);
            Dimension containerDim = target.getSize();
            Dimension layoutSize = this.preferredLayoutSize(target);
            Insets in = target.getInsets();
            int vslack = containerDim.height - layoutSize.height;
            int y = in.top;
            for (Row row : this.rows) {
                tabIndex = 0;
                y += row.gap;
                int hslack = this.width - row.width;
                int x = in.left;
                int hfillCount = row.hfillCount;
                int finalRowHeight = 0;
                boolean hasVfill = false;
                for (Component c : row.cols) {
                    this.adjustAlignment(c);
                    Dimension ps = c.getPreferredSize();
                    int w = ps.width;
                    if (this.hasConstraint(c, HFILL)) {
                        w += hslack / hfillCount;
                    }
                    int h = ps.height;
                    if (this.hasConstraint(c, VFILL)) {
                        h += vslack / this.rowsWithVfillCount;
                        hasVfill = true;
                    }
                    if (this.hasConstraint(c, TAB_STOP)) {
                        x = ruler.getTab(tabIndex++);
                    }
                    Dimension min = c.getMinimumSize();
                    Dimension max = c.getMaximumSize();
                    w = c instanceof JTextArea ? RiverLayout2.mid(0, w, max.width) : RiverLayout2.mid(min.width, w, max.width);
                    h = RiverLayout2.mid(min.height, h, max.height);
                    c.setBounds(x, y + this.addVAlgin(row, h), w, h);
                    w = c.getWidth();
                    h = c.getHeight();
                    finalRowHeight = Math.max(row.height, h);
                    if (this.hasConstraint(c, HFILL)) {
                        hslack -= w - ps.width;
                        --hfillCount;
                    }
                    x += w + this.hgap;
                }
                if (hasVfill) {
                    vslack -= finalRowHeight - row.height;
                    --this.rowsWithVfillCount;
                }
                y += finalRowHeight;
            }
        }
    }

    protected void adjustAlignment(Component m) {
        if (this.hasConstraint(m, VTOP)) {
            this.valign = VTOP;
        } else if (this.hasConstraint(m, VCENTER)) {
            this.valign = VCENTER;
        } else if (this.hasConstraint(m, VBOTTOM)) {
            this.valign = VBOTTOM;
        }
    }

    private static int mid(int min, int val, int max) {
        int res = Math.max(min, val);
        return Math.min(res, max);
    }

    private void init(Container target) {
        Insets in = target.getInsets();
        this.width = target.getWidth() - in.left - in.right;
        this.height = target.getHeight() - in.top - in.bottom;
        this.fillRows(target);
        this.initRows();
    }

    boolean isFirstInRow(Component comp) {
        String cons = this.constraints.get(comp);
        return cons != null && (cons.contains(LINE_BREAK) || cons.contains(PARAGRAPH_BREAK));
    }

    private boolean hasConstraint(Component c, String constraint) {
        return this.constraints.getOrDefault(c, "").contains(constraint);
    }

    private void fillRows(Container parent) {
        this.rows = new ArrayList<Row>();
        Row row = new Row();
        this.rows.add(row);
        for (Component c : parent.getComponents()) {
            if (!c.isVisible()) continue;
            if (this.hasConstraint(c, LINE_BREAK) || this.hasConstraint(c, PARAGRAPH_BREAK)) {
                if (!row.cols.isEmpty()) {
                    row = new Row();
                    this.rows.add(row);
                }
                if (this.hasConstraint(c, LINE_BREAK)) {
                    row.gap = this.vgap;
                }
                if (this.hasConstraint(c, PARAGRAPH_BREAK)) {
                    row.gap = this.vgap * 2;
                }
            }
            row.add(c);
        }
    }

    private void initRows() {
        this.rowsWithVfillCount = 0;
        for (Row row : this.rows) {
            for (Component c : row.cols) {
                if (this.hasConstraint(c, HFILL)) {
                    ++row.hfillCount;
                }
                if (!this.hasConstraint(c, VFILL)) continue;
                ++row.vfillCount;
            }
            if (row.vfillCount <= 0) continue;
            ++this.rowsWithVfillCount;
        }
    }

    private int addVAlgin(Row row, int h) {
        int slack = Math.max(0, row.height - h);
        switch (this.valign) {
            case "vtop": {
                return 0;
            }
            case "vcenter": {
                return slack / 2;
            }
        }
        return slack;
    }

    protected Ruler calcTabs(Container target) {
        Ruler ruler = new Ruler();
        for (Row row : this.rows) {
            int x = 0;
            int tabIndex = 0;
            for (Component c : row.cols) {
                if (this.hasConstraint(c, TAB_STOP)) {
                    ruler.setTab(tabIndex, x);
                    x = ruler.getTab(tabIndex++);
                } else {
                    x += this.hgap;
                }
                Dimension d = c.getPreferredSize();
                x += d.width;
            }
        }
        return ruler;
    }

    protected static class Ruler {
        private final ArrayList<Integer> tabs = new ArrayList();

        protected Ruler() {
        }

        public void setTab(int num, int xpos) {
            if (num >= this.tabs.size()) {
                this.tabs.add(num, xpos);
            } else {
                int delta = xpos - this.getTab(num);
                if (delta > 0) {
                    for (int i = num; i < this.tabs.size(); ++i) {
                        this.tabs.set(i, this.getTab(i) + delta);
                    }
                }
            }
        }

        public int getTab(int num) {
            return this.tabs.get(num);
        }

        public String toString() {
            StringBuilder ret = new StringBuilder(this.getClass().getName() + " {");
            for (int i = 0; i < this.tabs.size(); ++i) {
                ret.append(this.tabs.get(i));
                if (i >= this.tabs.size() - 1) continue;
                ret.append(',');
            }
            ret.append('}');
            return ret.toString();
        }
    }

    private class Row {
        List<Component> cols = new ArrayList<Component>();
        int hfillCount;
        int vfillCount;
        int width;
        int height;
        int gap;

        private Row() {
        }

        public void add(Component comp) {
            this.cols.add(comp);
        }
    }
}

