/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class MarginIcon
extends ImageIcon {
    private final Insets margin;
    private final Icon icon;

    public MarginIcon(int margin, Icon icon) {
        this.margin = new Insets(margin, margin, margin, margin);
        this.icon = icon;
    }

    public MarginIcon(int top, int right, int bottom, int left, Icon icon) {
        this.margin = new Insets(top, right, bottom, left);
        this.icon = icon;
    }

    public MarginIcon(Insets margin, Icon icon) {
        this.margin = margin;
        this.icon = icon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.icon.paintIcon(c, g, x + this.margin.left, y + this.margin.top);
    }

    @Override
    public Image getImage() {
        BufferedImage bi = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics g = bi.getGraphics();
        this.icon.paintIcon(null, g, this.margin.left, this.margin.top);
        return bi;
    }

    @Override
    public int getIconWidth() {
        return this.margin.left + this.icon.getIconWidth() + this.margin.right;
    }

    @Override
    public int getIconHeight() {
        return this.margin.top + this.icon.getIconHeight() + this.margin.bottom;
    }
}

