/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import se.datadosen.component.DirectoryChooser;

class MacAWTDirectoryChooser
implements DirectoryChooser {
    private FileDialog dialog;

    public MacAWTDirectoryChooser(Window parent) {
        if (parent instanceof Frame) {
            this.dialog = new FileDialog((Frame)parent);
        } else if (parent instanceof Dialog) {
            this.dialog = new FileDialog((Dialog)parent);
        } else {
            throw new IllegalArgumentException("Parent not instance of Frame or Dialog. It's a " + String.valueOf(parent != null ? parent.getClass() : null));
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.dialog.setDirectory(dir.getAbsolutePath());
    }

    @Override
    public File getCurrentDirectory() {
        String dir = this.dialog.getDirectory();
        return dir != null ? new File(dir) : null;
    }

    @Override
    public void setSelectedFile(File file) {
        this.setCurrentDirectory(file.getParentFile());
        this.dialog.setFile(file.getName());
    }

    @Override
    public File getSelectedFile() {
        if (this.dialog.getFile() == null) {
            return null;
        }
        File f = new File(this.dialog.getDirectory(), this.dialog.getFile());
        return f.isDirectory() ? f : f.getParentFile();
    }

    @Override
    public void setDialogTitle(String title) {
        this.dialog.setTitle(title);
    }

    @Override
    public int showOpenDialog(Component parent) {
        String def = System.getProperty("apple.awt.fileDialogForDirectories", "false");
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        this.dialog.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", def);
        return this.dialog.getFile() != null ? 0 : 1;
    }
}

