/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileView;
import net.tomahawk.ExtensionsFilter;
import net.tomahawk.XFileDialog;
import se.datadosen.component.FileChooser;
import se.datadosen.jalbum.Watchdog;

public class JXFileChooser
implements FileChooser {
    private File currentDir = new File("");
    private String dialogTitle = "";
    private int dialogType = 0;
    private boolean multiSelection = false;
    private int fileSelectionMode;
    private ActionListener listener;
    private File[] selectedFiles;
    private boolean showThumbnails = false;
    private List<ExtensionsFilter> filters = new ArrayList<ExtensionsFilter>();
    XFileDialog dlg;

    public JXFileChooser() {
        XFileDialog.setTraceLevel((int)0);
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.currentDir = dir;
    }

    @Override
    public File getCurrentDirectory() {
        return this.currentDir;
    }

    @Override
    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    @Override
    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelection = b;
    }

    @Override
    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = mode;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    @Override
    public void setFileView(FileView fileView) {
        this.showThumbnails = fileView != null;
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(parent, null);
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        this.setDialogType(0);
        return this.showDialog(parent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        try {
            Watchdog.getInstance().setEnabled(false);
            if (!(parent instanceof Frame)) {
                parent = SwingUtilities.windowForComponent(parent);
            }
            if (this.dlg == null) {
                this.dlg = parent instanceof Frame ? new XFileDialog((Frame)parent) : new XFileDialog((Dialog)parent);
                if (this.showThumbnails) {
                    this.dlg.setThumbnail(this.showThumbnails);
                }
                this.dlg.setTitle(this.dialogTitle);
            }
            this.dlg.resetFilters();
            this.dlg.addFilters(this.filters.toArray(new ExtensionsFilter[this.filters.size()]));
            this.dlg.setDirectory(this.currentDir.getAbsolutePath());
            String[] filenames = null;
            if (this.multiSelection) {
                filenames = this.fileSelectionMode == 1 ? this.dlg.getFolders() : this.dlg.getFiles();
            } else {
                String filename = this.fileSelectionMode == 1 ? this.dlg.getFolder() : this.dlg.getFile();
                if (filename != null) {
                    filenames = new String[]{filename};
                }
            }
            if (filenames == null) {
                int filename = 1;
                return filename;
            }
            this.currentDir = new File(this.dlg.getDirectory());
            ArrayList<File> files = new ArrayList<File>();
            for (String name : filenames) {
                File f = new File(name);
                if (!f.isAbsolute()) {
                    f = new File(this.currentDir, name);
                }
                files.add(f);
            }
            this.selectedFiles = files.toArray(new File[files.size()]);
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, 0, "ApproveSelection"));
            }
            int n = 0;
            return n;
        }
        finally {
            Watchdog.getInstance().setEnabled(true);
        }
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFiles[0];
    }

    @Override
    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        if (!(filter instanceof FileNameExtensionFilter)) {
            throw new IllegalArgumentException("filter is not a FileNameExtensionFilter");
        }
        FileNameExtensionFilter fnef = (FileNameExtensionFilter)filter;
        this.filters.add(new ExtensionsFilter(fnef.getDescription(), Arrays.asList(fnef.getExtensions())));
    }

    @Override
    public void setSelectedFile(File file) {
        this.selectedFiles = new File[1];
        this.selectedFiles[0] = file;
    }
}

