/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import se.datadosen.component.DeferredSVGIcon;
import se.datadosen.component.JFallbackLabel;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.util.Platform;

public class JTabButtonBar
extends JPanel {
    private ButtonGroup bg = new ButtonGroup();
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            this.getModel(e).setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.getModel(e).setRollover(false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.getModel(e).setPressed(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.getModel(e).setPressed(true);
        }

        private ButtonModel getModel(MouseEvent e) {
            return ((AbstractButton)e.getSource()).getModel();
        }
    };

    public JTabButtonBar() throws HeadlessException {
        this.setLayout(new RiverLayout(0, 0));
    }

    public JButton createButton(String text, Icon icon) {
        return new JTabButton(text, icon);
    }

    public JToggleButton createToggleButton(String text, Icon icon) {
        return new JToggleTabButton(text, icon);
    }

    public JButton createButton(Action a) {
        return new JTabButton(a);
    }

    public JToggleButton createToggleButton(Action a) {
        return new JToggleTabButton(a);
    }

    public AbstractButton add(AbstractButton b) {
        return this.add(b, -1);
    }

    public AbstractButton add(AbstractButton b, int index) {
        if (b instanceof JToggleButton) {
            this.bg.add(b);
        }
        super.add(b, "vfill", index);
        if (this.getComponentCount() == 1) {
            b.setSelected(true);
        }
        return b;
    }

    public boolean contains(Component comp) {
        for (Component c : this.getComponents()) {
            if (comp != c) continue;
            return true;
        }
        return false;
    }

    public AbstractButton remove(AbstractButton b) {
        if (b instanceof JToggleButton) {
            this.bg.remove(b);
        }
        super.remove(b);
        return b;
    }

    private void initComp(AbstractButton b, String text, Icon icon) {
        JFallbackLabel label = new JFallbackLabel(text, icon, 10);
        label.setFont(JAlbumFrame.TITLE_FONT);
        Font f = label.getFont();
        if (!Platform.isMac()) {
            label.setFont(f.deriveFont(f.getSize2D() + 1.0f));
        }
        b.add(label);
        b.setBorderPainted(false);
        b.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        b.addMouseListener(this.mouseAdapter);
        b.getModel().addChangeListener(e -> label.setForeground(b.getModel().isSelected() && b.getModel().isEnabled() ? JAlbumColor.textHighlightText : JAlbumColor.textText));
    }

    void paintComp(AbstractButton b, Graphics g) {
        if (b.isEnabled() && b.isSelected() || b.getModel().isArmed()) {
            g.setColor(JAlbumColor.textHighlight);
        } else if (b.isEnabled() && b.getModel().isRollover()) {
            g.setColor(JAlbumColor.albumHover);
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(0, 0, b.getWidth(), b.getHeight());
        if (b.isEnabled() && b.isSelected()) {
            g.setColor(JAlbumColor.controlShadow);
            g.drawLine(0, 0, 0, b.getHeight());
            g.drawLine(b.getWidth() - 1, 0, b.getWidth() - 1, b.getHeight());
        }
        Graphics2D g2d = (Graphics2D)g;
        if (!b.isEnabled()) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
    }

    private class JTabButton
    extends JButton {
        public JTabButton(Action a) {
            this((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
            this.setAction(a);
        }

        public JTabButton(String text) {
            this(text, null);
        }

        public JTabButton(String text, Icon icon) {
            super(text, icon);
            JTabButtonBar.this.initComp(this, text, icon);
            this.addMouseListener(JTabButtonBar.this.mouseAdapter);
        }

        @Override
        protected void paintComponent(Graphics g) {
            JTabButtonBar.this.paintComp(this, g);
        }

        @Override
        public void setIcon(Icon icon) {
            if (this.getComponentCount() == 1) {
                JLabel l = (JLabel)this.getComponent(0);
                l.setIcon(icon);
            }
            super.setIcon(icon);
        }

        @Override
        public void setText(String text) {
            if (this.getComponentCount() == 1) {
                JLabel l = (JLabel)this.getComponent(0);
                l.setText(text);
            }
            super.setText(text);
        }
    }

    private class JToggleTabButton
    extends JToggleButton {
        public JToggleTabButton(Action a) {
            this((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
            this.setAction(a);
        }

        public JToggleTabButton(String text) {
            this(text, null);
        }

        public JToggleTabButton(String text, Icon icon) {
            super(text, icon);
            JTabButtonBar.this.initComp(this, text, icon);
            this.addMouseListener(JTabButtonBar.this.mouseAdapter);
        }

        @Override
        protected void paintComponent(Graphics g) {
            JTabButtonBar.this.paintComp(this, g);
        }

        @Override
        public void setIcon(Icon icon) {
            if (this.getComponentCount() == 1) {
                JLabel l = (JLabel)this.getComponent(0);
                l.setIcon(icon);
            }
            super.setIcon(icon);
            if (icon != null) {
                DeferredSVGIcon selectedIcon = ((DeferredSVGIcon)((Object)icon)).cloneMe();
                selectedIcon.setAdaptColors(false);
                super.setSelectedIcon((Icon)((Object)selectedIcon));
            }
        }

        @Override
        public void setText(String text) {
            if (this.getComponentCount() == 1) {
                JLabel l = (JLabel)this.getComponent(0);
                l.setText(text);
            }
            super.setText(text);
        }
    }
}

