/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import se.datadosen.component.Hour;
import se.datadosen.component.SpeechBubbleBorder;
import se.datadosen.jalbum.JAlbumUtilities;

public class JSpeechBubble
extends JPanel {
    private JLabel text = new JLabel();
    private static int OVERLAP = 12;
    private int expiration = 0;
    private JComponent comp;
    private SpeechBubbleBorder border;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            JSpeechBubble.this.uninstall();
        }
    };
    private ComponentListener listener;

    public void uninstall() {
        JLayeredPane pane = (JLayeredPane)this.getParent();
        if (pane != null) {
            pane.removeComponentListener(this.listener);
            pane.remove(this);
            this.listener = null;
            pane.validate();
            pane.repaint();
        }
        if (this.comp != null) {
            this.comp.removeMouseListener(this.mouseListener);
            this.comp = null;
        }
    }

    public JSpeechBubble(String message) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.text.setText(message);
        this.text.setFont(new Font("Dialog", 0, 14));
        this.setBackground(Color.decode("#a8d560"));
        this.text.setForeground(Color.decode("#181818"));
        this.add(this.text);
        this.validate();
        this.setSize(this.getPreferredSize());
        this.addMouseListener(this.mouseListener);
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public void show(JComponent comp, Hour relativePosition) {
        this.comp = comp;
        comp.addMouseListener(this.mouseListener);
        if (this.expiration > 0) {
            JAlbumUtilities.schedule(() -> this.uninstall(), (long)this.expiration, TimeUnit.SECONDS);
        }
        this.border = new SpeechBubbleBorder(relativePosition.getOpposite());
        this.setBorder(this.border);
        Dimension ps = this.getPreferredSize();
        this.setSize(ps);
        int x = 0;
        int y = 0;
        switch (relativePosition.value()) {
            case 1: 
            case 11: 
            case 12: {
                y = -this.getHeight();
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                y = comp.getHeight();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                x = comp.getWidth();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                x = -this.getWidth();
            }
        }
        switch (relativePosition.value()) {
            case 7: 
            case 11: {
                x = comp.getWidth() / 2 - this.getWidth() + this.border.getTipOffset();
                break;
            }
            case 1: 
            case 5: {
                x = comp.getWidth() / 2 - this.border.getTipOffset();
                break;
            }
            case 6: 
            case 12: {
                x = (comp.getWidth() - this.getWidth()) / 2;
                break;
            }
            case 3: 
            case 9: {
                y = (comp.getHeight() - this.getHeight()) / 2;
                break;
            }
            case 2: 
            case 10: {
                y = comp.getHeight() / 2 - this.getHeight() + this.border.getTipOffset();
                break;
            }
            case 4: 
            case 8: {
                y = comp.getHeight() / 2 - this.border.getTipOffset();
            }
        }
        this.show(comp, x, y);
    }

    private void show(final Component invoker, final int x, final int y) {
        RootPaneContainer win = (RootPaneContainer)((Object)SwingUtilities.windowForComponent(invoker));
        this.adjustLocation(invoker, x, y);
        if (!this.isShowing()) {
            if (this.listener != null) {
                win.getLayeredPane().removeComponentListener(this.listener);
            }
            JLayeredPane pane = win.getLayeredPane();
            pane.remove(this);
            this.setVisible(true);
            pane.add((Component)this, JLayeredPane.PALETTE_LAYER);
            Dimension ps = this.getPreferredSize();
            this.setSize(ps);
            this.adjustLocation(invoker, x, y);
            this.listener = new ComponentAdapter(this){
                final /* synthetic */ JSpeechBubble this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingUtilities.invokeLater(() -> this.this$0.adjustLocation(invoker, x, y));
                }
            };
            win.getLayeredPane().addComponentListener(this.listener);
            this.requestFocusInWindow();
        }
    }

    public void adjustLocation(Component rel, int x, int y) {
        RootPaneContainer win = (RootPaneContainer)((Object)SwingUtilities.windowForComponent(rel));
        if (win != null) {
            Point newLocation = SwingUtilities.convertPoint(rel, x, y, win.getLayeredPane());
            this.setLocation(newLocation.x, newLocation.y);
        }
    }

    public static void show(JComponent comp, Hour relativePos, String message) {
        JSpeechBubble.show(comp, relativePos, message, 500);
    }

    public static void show(JComponent comp, Hour relativePos, String message, int delayMillis) {
        JSpeechBubble.show(comp, relativePos, message, delayMillis, 8);
    }

    public static void show(JComponent comp, Hour relativePos, String message, int delayMillis, int expirationSecs) {
        JAlbumUtilities.schedule(() -> {
            JSpeechBubble sb = new JSpeechBubble("<html><center>" + message + "</center></html>");
            sb.setExpiration(expirationSecs);
            sb.show(comp, relativePos);
        }, (long)delayMillis, TimeUnit.MILLISECONDS);
    }
}

