/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import org.w3c.dom.Node;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;

public class JSkinLikesPanel
extends JPanel {
    private String skinName;
    private WrappableJLabel label = new WrappableJLabel();
    private boolean likes;
    private Integer likesCount;
    private Action likeAction = new AbstractAction(Msg.get("ui.like")){
        {
            this.putValue("SmallIcon", Icons.small("like"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSkinLikesPanel.this.likeButton.setText(JSkinLikesPanel.this.likeButton.isSelected() ? Msg.get("ui.liking") : Msg.get("ui.like"));
            JSkinLikesPanel.this.callLikesAPIBg(JSkinLikesPanel.this.likeButton.isSelected());
        }
    };
    private JToggleButton likeButton = new JToggleButton(this.likeAction);
    private Thread updater;

    public JSkinLikesPanel(String skinName) {
        this.skinName = skinName;
        this.init();
    }

    public boolean isLikes() {
        return this.likes;
    }

    public Integer getLikesCount() {
        return this.likesCount;
    }

    public JToggleButton getLikeButton() {
        return this.likeButton;
    }

    private void updateVisuals() {
        this.label.setText(Msg.get("ui.skinLikes", this.skinName, this.likesCount != null ? this.likesCount : "--"));
        boolean signedIn = SignInManager.getInstance().isSignedIn();
        this.likeButton.setEnabled(signedIn);
        this.likeButton.setToolTipText(signedIn ? null : Msg.get("ui.notSignedIn"));
        this.likeButton.setText(this.likeButton.isSelected() ? Msg.get("ui.liking") : Msg.get("ui.like"));
        this.validate();
    }

    public int hashCode() {
        int hash = 5;
        String s = Msg.get("ui.skinLikes", this.skinName, 0);
        hash = 37 * hash + s.hashCode();
        return hash;
    }

    private void init() {
        this.label.setForeground(SystemColor.black);
        SignInManager.getInstance().addPropertyChangeListener("signIn", evt -> this.updateVisuals());
        this.setOpaque(false);
        this.setLayout(new FlowLayout(3, 0, 0));
        this.updateVisuals();
        this.add(this.label);
        this.add(Box.createHorizontalStrut(20));
        this.add(this.likeButton);
        this.validate();
        this.callLikesAPIBg(null);
    }

    public void waitForUpdate() {
        if (this.updater != null && this.updater.isAlive()) {
            try {
                this.updater.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean foundLikes() {
        this.waitForUpdate();
        return this.likesCount != null;
    }

    public void callLikesAPIBg(final Boolean like) {
        this.waitForUpdate();
        this.updater = new Thread(this, "Skin likes updater"){
            final /* synthetic */ JSkinLikesPanel this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                try {
                    this.this$0.likeAction.setEnabled(false);
                    this.this$0.callLikesAPI(like);
                    this.this$0.updateVisuals();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.this$0.updateVisuals();
                }
            }
        };
        this.updater.start();
    }

    private void callLikesAPI(Boolean like) throws IOException, IllegalStateException {
        SignInManager mgr;
        RobustResty r = new RobustResty();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("skin", this.skinName);
        if (like != null) {
            data.put("like", like.toString());
        }
        if ((mgr = SignInManager.getInstance()).isSignedIn()) {
            String cid = AccountManager.getCid(mgr.getUserName(), mgr.getPassword());
            data.put("cid", cid);
        }
        try {
            Node result = (Node)r.xml(JAlbumSite.getInstance().getSkinLikesUrl(), (AbstractContent)RobustResty.form(data)).get("/reply/result", Node.class);
            boolean oldLikes = this.likes;
            XPath xpath = XPathFactory.newInstance().newXPath();
            if ("ok".equals(result.getTextContent())) {
                this.likes = "true".equals(xpath.evaluate("@likes", result, XPathConstants.STRING));
                Double lc = (Double)xpath.evaluate("@likesCount", result, XPathConstants.NUMBER);
                if (lc != null) {
                    if (this.likesCount == null || lc.intValue() != this.likesCount.intValue()) {
                        this.firePropertyChange("likesCount", this.likesCount, lc);
                    }
                    this.likesCount = lc.intValue();
                }
            }
            this.likeButton.setSelected(this.likes);
            this.updateVisuals();
            if (this.likes != oldLikes) {
                this.firePropertyChange("likes", oldLikes, this.likes);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

