/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import se.datadosen.jalbum.JAlbumColor;

public class JSiteButton
extends JButton {
    protected boolean showLabel = true;
    protected boolean mouseOver = false;
    protected boolean mousePressed = false;
    private boolean borderPainted = true;
    private int borderRadius = 4;
    private boolean uiSet = false;
    private ButtonUI ui = new BasicButtonUI();

    public JSiteButton() {
        this.init();
    }

    public JSiteButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JSiteButton(Action a) {
        super(a);
        this.init();
    }

    public JSiteButton(Action a, boolean showLabel) {
        this.showLabel = showLabel;
        this.setAction(a);
        this.init();
    }

    public JSiteButton(String text) {
        this.init();
        super.setText(text);
    }

    public JSiteButton(Icon icon) {
        super(icon);
        this.init();
    }

    @Override
    public void updateUI() {
        this.setUI(this.ui);
        this.setFont((Font)UIManager.get("Button.font"));
        this.setBackground(JAlbumColor.albumHover);
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    @Override
    public void setUI(ButtonUI newUI) {
        if (!this.uiSet) {
            super.setUI(newUI);
            this.uiSet = true;
        }
    }

    @Override
    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    @Override
    public void setBorderPainted(boolean b) {
        this.borderPainted = b;
        this.repaint();
    }

    private void init() {
        this.updateUI();
        super.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        this.setContentAreaFilled(false);
        super.setBorderPainted(false);
        this.setFocusable(false);
        this.setOpaque(false);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JSiteButton.this.mouseOver = false;
                JSiteButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JSiteButton.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JSiteButton.this.mousePressed = false;
                JSiteButton.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JSiteButton.this.mouseOver = true;
                JSiteButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JSiteButton.this.mouseOver = false;
                JSiteButton.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.isEnabled()) {
            g.setColor(this.mousePressed ? JAlbumColor.darken(this.getBackground(), 10) : this.getBackground());
        } else {
            g.setColor(JAlbumColor.textInactiveText);
        }
        if (this.mouseOver && this.isEnabled()) {
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.borderRadius * 2, this.borderRadius * 2);
        } else if (this.borderPainted) {
            g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.borderRadius * 2, this.borderRadius * 2);
        }
        super.paintComponent(g);
    }

    public int getBorderRadius() {
        return this.borderRadius;
    }

    public void setBorderRadius(int borderRadius) {
        this.borderRadius = borderRadius;
    }

    @Override
    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }
}

