/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import se.datadosen.component.ToggleAction;
import se.datadosen.jalbum.JAlbumColor;

public class JRoundedToggleButton
extends JToggleButton {
    private JLabel label;

    public JRoundedToggleButton(ToggleAction a) {
        super(a);
        this.setEnabled(a.isEnabled());
        this.init();
        a.addPropertyChangeListener(evt -> this.synkLabelColor());
        this.synkLabelColor();
        a.addPropertyChangeListener(evt -> {
            if ("Name".equals(evt.getPropertyName())) {
                this.label.setText((String)evt.getNewValue());
            } else if ("enabled".equals(evt.getPropertyName())) {
                this.setEnabled((Boolean)evt.getNewValue());
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
    }

    private void synkLabelColor() {
        this.label.setForeground(this.isSelected() ? JAlbumColor.textHighlightText : JAlbumColor.textText);
    }

    private void init() {
        this.label = new JLabel(this.getText());
        this.label.setOpaque(false);
        this.label.setEnabled(this.isEnabled());
        this.add(this.label);
        this.setBorderPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(1, 6, 2, 6));
    }

    @Override
    protected void paintComponent(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isSelected()) {
            g.setColor(JAlbumColor.textHighlight);
            g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.getHeight(), this.getHeight());
        }
    }
}

