/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;

public class JProjectChooser
extends JFileChooser {
    private static final int ICON_SIZE = 300;
    private static final Image LOADING_IMAGE = new BufferedImage(300, 300, 2);
    private final Pattern imageFilePattern = Pattern.compile(".+?\\.(png|jpe?g|gif|tiff?)$", 2);
    private final Map imageCache = new WeakHashMap();

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JProjectChooser chooser = new JProjectChooser();
        chooser.showOpenDialog(null);
        System.exit(1);
    }

    public JProjectChooser() {
        this.setFileView(new ThumbnailView());
    }

    private class ThumbnailView
    extends FileView {
        private final ExecutorService executor = Executors.newCachedThreadPool();

        private ThumbnailView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File file) {
            if (!JProjectChooser.this.imageFilePattern.matcher(file.getName()).matches()) {
                return null;
            }
            Map map = JProjectChooser.this.imageCache;
            synchronized (map) {
                ImageIcon icon = (ImageIcon)JProjectChooser.this.imageCache.get(file);
                if (icon == null) {
                    icon = new ImageIcon(LOADING_IMAGE);
                    JProjectChooser.this.imageCache.put(file, icon);
                    this.executor.submit(new ThumbnailIconLoader(icon, file));
                }
                return icon;
            }
        }
    }

    private class ThumbnailIconLoader
    implements Runnable {
        private final ImageIcon icon;
        private final File file;

        public ThumbnailIconLoader(ImageIcon i, File f) {
            this.icon = i;
            this.file = f;
        }

        @Override
        public void run() {
            ImageIcon newIcon = new ImageIcon(this.file.getAbsolutePath());
            Image img = newIcon.getImage().getScaledInstance(300, 300, 4);
            this.icon.setImage(img);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JProjectChooser.this.repaint();
                }
            });
        }
    }
}

