/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javafx.scene.media.AudioClip;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.FileChooser;
import se.datadosen.dnd.JFileDropPanel;
import se.datadosen.jalbum.Icons;
import se.datadosen.util.Item;
import se.datadosen.util.PersistentList;

public class JPlaylist
extends JFileDropPanel
implements PersistentList {
    private Class cl = this.getClass();
    private Icon addIcon = Icons.small("add2");
    private Icon deleteIcon = Icons.small("delete2");
    private Icon upIcon = Icons.small("arrow_up_blue");
    private Icon downIcon = Icons.small("arrow_down_blue");
    private Icon playIcon = Icons.small("media_play_green");
    private Icon previousIcon = Icons.small("media_step_back");
    private Icon nextIcon = Icons.small("media_step_forward");
    private Icon stopIcon = Icons.small("media_stop");
    private FileChooser fileChooser;
    private DefaultListModel filesModel = new DefaultListModel();
    private AudioClip player;
    private FileNameExtensionFilter fileFilter = new FileNameExtensionFilter("Music files", "mp3", "m4a", "wav");
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane scroller = new JScrollPane();
    String[] data = new String[]{"one", "two", "three", "four"};
    JList fileList = new JList(this.filesModel);
    JButton addButton = new JButton();
    JButton deleteButton = new JButton();
    JButton upButton = new JButton();
    JButton downButton = new JButton();
    JButton playButton = new JButton();
    JButton previousButton = new JButton();
    JButton nextButton = new JButton();
    JButton pauseButton = new JButton();
    JButton stopButton = new JButton();
    JToolBar buttonBar = new JToolBar();

    private FileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = ChooserFactory.createFilesChooser(SwingUtilities.getWindowAncestor(this));
            this.fileChooser.setFileFilter(this.fileFilter);
            this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        return this.fileChooser;
    }

    boolean isPlaying() {
        return this.player != null && this.player.isPlaying();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter ff) {
        if (ff instanceof FileNameExtensionFilter) {
            this.fileFilter = (FileNameExtensionFilter)ff;
            this.getFileChooser().setFileFilter(this.fileFilter);
        }
    }

    public void setCurrentDirectory(File dir) {
        this.getFileChooser().setCurrentDirectory(dir);
    }

    public File getSelectedFile() {
        Item item = (Item)this.fileList.getSelectedValue();
        if (item != null) {
            return (File)item.value;
        }
        return (File)((Item)this.filesModel.get((int)0)).value;
    }

    public File[] getFileList() {
        File[] files = new File[this.filesModel.size()];
        Enumeration en = this.filesModel.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            files[i] = (File)item.value;
            ++i;
        }
        return files;
    }

    public void clearFileList() {
        this.filesModel.removeAllElements();
    }

    public void addFileList(List<File> newFiles) {
        this.addFileList(newFiles.toArray(new File[newFiles.size()]));
    }

    public void addFileList(File[] newFiles) {
        for (File newFile : newFiles) {
            Item item = new Item(newFile, newFile.getName());
            this.filesModel.addElement(item);
        }
        if (this.fileList.getSelectedIndex() == -1) {
            this.fileList.setSelectedIndex(0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fileList.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
        this.previousButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.playButton.setEnabled(enabled);
        this.stopButton.setEnabled(enabled);
        this.pauseButton.setEnabled(enabled);
    }

    public JPlaylist() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JPlaylist(File[] files) {
        this();
        this.addFileList(files);
    }

    public ListModel getModel() {
        return this.fileList.getModel();
    }

    public void addButton(JButton toolbarButton) {
        this.buttonBar.add(toolbarButton);
    }

    private void jbInit() throws Exception {
        this.fileList.setCellRenderer(new SmartListCellRenderer());
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JPlaylist.this.playButton_actionPerformed(null);
                }
            }
        });
        this.fileList.setSelectionMode(0);
        this.setLayout(this.borderLayout1);
        this.addButton.setIcon(this.addIcon);
        this.addButton.addActionListener(this::addButton_actionPerformed);
        this.deleteButton.setIcon(this.deleteIcon);
        this.deleteButton.addActionListener(this::deleteButton_actionPerformed);
        this.upButton.setIcon(this.upIcon);
        this.upButton.addActionListener(this::upButton_actionPerformed);
        this.downButton.setIcon(this.downIcon);
        this.downButton.addActionListener(this::downButton_actionPerformed);
        this.playButton.setIcon(this.playIcon);
        this.playButton.addActionListener(this::playButton_actionPerformed);
        this.stopButton.setIcon(this.stopIcon);
        this.stopButton.addActionListener(this::stopButton_actionPerformed);
        this.previousButton.setIcon(this.previousIcon);
        this.previousButton.addActionListener(this::previousButton_actionPerformed);
        this.nextButton.setIcon(this.nextIcon);
        this.nextButton.addActionListener(this::nextButton_actionPerformed);
        this.buttonBar.setFloatable(false);
        this.buttonBar.setOpaque(false);
        this.buttonBar.setBorderPainted(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                JPlaylist.this.this_componentHidden(e);
            }
        });
        this.addHierarchyListener(he -> {
            if ((he.getChangeFlags() & 1L) != 0L && this.getParent() == null) {
                this.stopButton_actionPerformed(null);
            }
        });
        this.add((Component)this.scroller, "Center");
        this.add((Component)this.buttonBar, "North");
        this.buttonBar.add(this.addButton);
        this.buttonBar.add(this.deleteButton);
        this.buttonBar.addSeparator();
        this.buttonBar.add(this.upButton);
        this.buttonBar.add(this.downButton);
        this.buttonBar.addSeparator();
        this.buttonBar.add(this.previousButton);
        this.buttonBar.add(this.playButton);
        this.buttonBar.add(this.stopButton);
        this.buttonBar.add(this.nextButton);
        this.scroller.getViewport().add(this.fileList);
        this.addFileDropListener(e -> this.addFileList(e.getFiles()));
        this.fileList.setFixedCellWidth(this.buttonBar.getPreferredSize().width);
    }

    private void addButton_actionPerformed(ActionEvent e) {
        new Thread(() -> {
            int result = this.getFileChooser().showOpenDialog(this);
            if (result == 0) {
                File[] newFiles = this.fileChooser.getSelectedFiles();
                this.addFileList(newFiles);
            }
        }, "File chooser thread").start();
    }

    private void deleteButton_actionPerformed(ActionEvent e) {
        int selIndex = this.fileList.getSelectedIndex();
        Item toRemove = (Item)this.fileList.getSelectedValue();
        if (toRemove != null) {
            this.filesModel.removeElement(toRemove);
            if (selIndex == 0) {
                selIndex = 1;
            }
            this.fileList.setSelectedIndex(selIndex - 1);
        }
    }

    private void upButton_actionPerformed(ActionEvent e) {
        int selectedIndex = this.fileList.getSelectedIndex();
        if (selectedIndex != -1 && selectedIndex > 0) {
            Item item = (Item)this.filesModel.getElementAt(selectedIndex);
            this.filesModel.removeElement(item);
            this.filesModel.insertElementAt(item, selectedIndex - 1);
            this.fileList.setSelectedIndex(selectedIndex - 1);
        }
    }

    private void downButton_actionPerformed(ActionEvent e) {
        int selectedIndex = this.fileList.getSelectedIndex();
        if (selectedIndex != -1 && selectedIndex < this.filesModel.getSize() - 1) {
            Item item = (Item)this.filesModel.getElementAt(selectedIndex);
            this.filesModel.removeElement(item);
            this.filesModel.insertElementAt(item, selectedIndex + 1);
            this.fileList.setSelectedIndex(selectedIndex + 1);
        }
    }

    private void playButton_actionPerformed(ActionEvent e) {
        File f = this.getSelectedFile();
        if (f != null && f.exists()) {
            if (this.player != null) {
                this.player.stop();
            }
            this.player = new AudioClip(f.toURI().toString());
            this.player.play();
        }
    }

    private void stopButton_actionPerformed(ActionEvent e) {
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
    }

    private void previousButton_actionPerformed(ActionEvent e) {
        int index = this.fileList.getSelectedIndex();
        if (index != -1) {
            if (index > 0) {
                this.fileList.setSelectedIndex(index - 1);
            } else {
                this.fileList.setSelectedIndex(this.fileList.getModel().getSize() - 1);
            }
        }
        if (this.isPlaying()) {
            this.play();
        }
    }

    private void nextButton_actionPerformed(ActionEvent e) {
        int index = this.fileList.getSelectedIndex();
        if (index != -1) {
            if (index < this.fileList.getModel().getSize() - 1) {
                this.fileList.setSelectedIndex(index + 1);
            } else {
                this.fileList.setSelectedIndex(0);
            }
        }
        if (this.isPlaying()) {
            this.play();
        }
    }

    public void play() {
        this.playButton_actionPerformed(null);
    }

    public void stop() {
        this.stopButton_actionPerformed(null);
    }

    private ListModel DefaultListModel() {
        return null;
    }

    @Override
    public List<String> getContent() {
        LinkedList<String> content = new LinkedList<String>();
        Enumeration en = this.filesModel.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            content.add(((File)item.value).getAbsolutePath());
            ++i;
        }
        return content;
    }

    @Override
    public void setContent(List<String> content) {
        this.clearFileList();
        File[] files = new File[content.size()];
        for (int i = 0; i < content.size(); ++i) {
            files[i] = new File(content.get(i));
        }
        this.addFileList(files);
    }

    public void this_componentHidden(ComponentEvent e) {
        this.stopButton_actionPerformed(null);
    }

    class SmartListCellRenderer
    extends DefaultListCellRenderer {
        SmartListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            if (value instanceof Item) {
                this.setToolTipText(((Item)value).value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }
}

