/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class JPlainButton
extends JButton {
    protected boolean showLabel = true;
    private int margin = 3;
    private ButtonUI ui = new BasicButtonUI();

    public JPlainButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JPlainButton(Action a) {
        super(a);
        this.init();
    }

    public JPlainButton(Action a, boolean showLabel) {
        this.showLabel = showLabel;
        this.setAction(a);
        this.init();
    }

    public JPlainButton(Action a, boolean showLabel, int margin) {
        this.showLabel = showLabel;
        this.setAction(a);
        this.margin = margin;
        this.init();
    }

    public JPlainButton(String text) {
        super(text);
        this.init();
    }

    public JPlainButton(Icon icon) {
        super(icon);
        this.init();
    }

    public JPlainButton(Icon icon, int margin) {
        super(icon);
        this.margin = margin;
        this.init();
    }

    public JPlainButton(Icon icon, Icon rolloverIcon) {
        super(icon);
        this.init();
        this.setRolloverEnabled(true);
        this.setRolloverIcon(rolloverIcon);
    }

    public JPlainButton() {
        this.init();
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    @Override
    public void updateUI() {
        this.setUI(this.ui);
        this.setFont((Font)UIManager.get("Button.font"));
    }

    @Override
    public void setBorder(Border border) {
    }

    public void setRealBorder(Border border) {
        super.setBorder(border);
    }

    private void init() {
        this.updateUI();
        super.setBorder(BorderFactory.createEmptyBorder(this.margin, this.margin, this.margin, this.margin));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusable(false);
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        if (defaultIcon != null) {
            this.setRolloverEnabled(true);
            if (defaultIcon instanceof ImageIcon) {
                Icon rolloverIcon;
                Action action = this.getAction();
                if (action != null && (rolloverIcon = (Icon)action.getValue("rolloverIcon")) != null) {
                    this.setRolloverIcon(rolloverIcon);
                    return;
                }
                this.setRolloverIcon(JPlainButton.brighten((ImageIcon)defaultIcon, 1.2f));
            }
        } else {
            this.setRolloverEnabled(false);
        }
    }

    @Override
    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }

    private static ImageIcon brighten(ImageIcon icon, float value) {
        BufferedImage buff = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = buff.createGraphics();
        g.drawImage(icon.getImage(), 0, 0, null);
        g.dispose();
        Kernel kernel = new Kernel(1, 1, new float[]{value});
        ConvolveOp op = new ConvolveOp(kernel);
        buff = op.filter(buff, null);
        return new ImageIcon(buff);
    }
}

