/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import se.datadosen.jalbum.JAlbum;

public class JNumberField
extends JTextField {
    private boolean allowNegative = false;
    private boolean allowDecimals = false;

    public JNumberField() {
        this.init();
    }

    public JNumberField(String text) {
        super(text);
        this.init();
    }

    public JNumberField(int columns) {
        super(columns);
        this.init();
    }

    public JNumberField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public JNumberField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public JNumberField setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
        return this;
    }

    public boolean isAllowDecimals() {
        return this.allowDecimals;
    }

    public JNumberField setAllowDecimals(boolean allowDecimals) {
        this.allowDecimals = allowDecimals;
        return this;
    }

    private void init() {
        AbstractDocument doc = (AbstractDocument)this.getDocument();
        doc.setDocumentFilter(new NumberFilter());
        this.setHorizontalAlignment(4);
    }

    private class NumberFilter
    extends DocumentFilter {
        private NumberFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attr) throws BadLocationException {
            if (text == null) {
                text = "";
            }
            StringBuilder newText = new StringBuilder();
            newText.append(JNumberField.this.getDocument().getText(0, JNumberField.this.getDocument().getLength()));
            newText.replace(offset, offset + length, text);
            if (this.test(newText.toString())) {
                fb.replace(offset, length, text, attr);
            } else {
                JAlbum.logger.fine("JNumberField: Trying to insert illegal string: \"" + newText.toString() + "\" allowsNegative: " + JNumberField.this.allowNegative + " allowsDecimals: " + JNumberField.this.allowDecimals);
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private boolean test(String text) {
            if (text.isEmpty()) {
                return true;
            }
            if (!JNumberField.this.allowNegative && text.contains("-")) {
                return false;
            }
            try {
                if (JNumberField.this.allowDecimals) {
                    Double.parseDouble(text);
                } else {
                    Integer.parseInt(text);
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

