/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.datadosen.util.LambdaAction;

public class JModalPanel<T extends JFrame>
extends JPanel {
    protected final T window;
    private Component lastFocusOwner;

    private JLayeredPane layeredPane() {
        return ((JFrame)this.window).getLayeredPane();
    }

    public JModalPanel(T window) {
        this.window = window;
        this.setBounds(this.layeredPane().getBounds());
        ((JFrame)window).getLayeredPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JModalPanel.this.setBounds(JModalPanel.this.layeredPane().getBounds());
            }
        });
        this.setBackground(new Color(0, 0, 0, 128));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(80, 0, 0, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Component deepest = SwingUtilities.getDeepestComponentAt(JModalPanel.this, e.getX(), e.getY());
                if (deepest == JModalPanel.this) {
                    JModalPanel.this.close();
                }
            }
        });
        this.registerKeyboardAction(new LambdaAction(() -> this.close()), "close", KeyStroke.getKeyStroke(27, 0), 2);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        FocusManager mgr = FocusManager.getCurrentManager();
        if (visible) {
            this.lastFocusOwner = mgr.getFocusOwner();
        } else if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocusInWindow();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void activate() {
        this.layeredPane().remove(this);
        this.layeredPane().add((Component)this, JLayeredPane.POPUP_LAYER);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.layeredPane().remove(this);
    }
}

