/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import se.datadosen.component.MapClip;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;

public class JMapTable
extends JTable
implements ClipboardOwner {
    static Icon cutIcon = Icons.small("cut");
    static Icon copyIcon = Icons.small("copy");
    static Icon pasteIcon = Icons.small("paste");
    static Icon removeSelectionIcon = Icons.small("close");
    static Icon insertRowIcon = Icons.small("insert-row");
    private Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private boolean editable = true;
    private ArrayList<Map.Entry> items = new ArrayList();
    private MapModel theModel = new MapModel();
    private Color oddColor;
    private boolean sortKeys = true;
    Action cutAction = new AbstractAction(Msg.get("edit.cut"), cutIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = JMapTable.this.getSelectedRows();
            if (rows.length > 0) {
                ArrayList<Map.Entry> clip = JMapTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
                JMapTable.this.clipboard.setContents(new MapClip(clip), JMapTable.this);
                JMapTable.this.handlePasteEnabling();
            }
        }
    };
    Action copyAction = new AbstractAction(Msg.get("edit.copy"), copyIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = JMapTable.this.getSelectedRows();
            if (rows.length > 0) {
                ArrayList<Map.Entry> clip = JMapTable.this.theModel.getRows(rows[0], rows[rows.length - 1]);
                JMapTable.this.clipboard.setContents(new MapClip(clip), JMapTable.this);
                JMapTable.this.handlePasteEnabling();
            }
        }
    };
    Action pasteAction = new AbstractAction(Msg.get("edit.paste"), pasteIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            Transferable t = JMapTable.this.clipboard.getContents(JMapTable.this);
            try {
                int lastRow;
                ArrayList content = t.isDataFlavorSupported(MapClip.mapFlavor) ? (ArrayList)t.getTransferData(MapClip.mapFlavor) : this.parseStringFromClipboard(t);
                int[] rows = JMapTable.this.getSelectedRows();
                int firstRow = rows.length > 0 ? rows[0] : 0;
                int n = lastRow = rows.length > 0 ? rows[rows.length - 1] : 0;
                if (lastRow > firstRow) {
                    JMapTable.this.theModel.deleteRows(firstRow, lastRow);
                }
                JMapTable.this.theModel.insertRows(firstRow, content);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }

        private ArrayList<Map.Entry> parseStringFromClipboard(Transferable t) throws UnsupportedFlavorException, IOException {
            String line;
            ArrayList<Map.Entry> rows = new ArrayList<Map.Entry>();
            String content = (String)t.getTransferData(DataFlavor.stringFlavor);
            BufferedReader reader = new BufferedReader(new StringReader(content));
            char[] delims = new char[]{'=', '\t', ',', ';', ':'};
            while ((line = reader.readLine()) != null) {
                String key = line;
                String value = "";
                int indexOfEquals = JMapTable.this.indexOf(line, delims);
                if (indexOfEquals >= 0) {
                    key = line.substring(0, indexOfEquals);
                    value = line.substring(indexOfEquals + 1);
                }
                key = key.trim();
                value = value.trim();
                rows.add(new Entry(key, value));
            }
            return rows;
        }
    };
    Action insertAction = new AbstractAction(Msg.get("edit.insertRow"), insertRowIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = JMapTable.this.getSelectedRows();
            if (rows.length > 0) {
                ArrayList<Map.Entry> newRows = new ArrayList<Map.Entry>();
                newRows.add(new Entry("", ""));
                JMapTable.this.theModel.insertRows(rows[0], newRows);
                JMapTable.this.selectionModel.setSelectionInterval(rows[0], rows[0]);
            }
        }
    };
    Action deleteAction = new AbstractAction(Msg.get("edit.delete"), removeSelectionIcon){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = JMapTable.this.getSelectedRows();
            if (rows.length > 0) {
                JMapTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
            }
        }
    };

    public JMapTable() {
        Color c = JAlbumColor.textHighlight;
        this.oddColor = new Color(0, 0, 64, 8);
        super.setModel(new DefaultTableModel());
        super.setRowSelectionAllowed(false);
        this.setSelectionMode(1);
        this.setRowSelectionAllowed(true);
        JPopupMenu popup = new JPopupMenu();
        this.handlePasteEnabling();
        popup.add(this.cutAction);
        popup.add(this.copyAction);
        popup.add(this.pasteAction);
        popup.add(this.insertAction);
        popup.add(this.deleteAction);
        this.setComponentPopupMenu(popup);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int[] rows;
                if (e.getKeyCode() == 127 && (rows = JMapTable.this.getSelectedRows()).length > 0) {
                    JMapTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public boolean isSortKeys() {
        return this.sortKeys;
    }

    public void setSortKeys(boolean sortKeys) {
        this.sortKeys = sortKeys;
    }

    private int indexOf(String s, char[] delims) {
        int i = -1;
        for (char delim : delims) {
            i = s.indexOf(delim);
            if (i < 0) continue;
            return i;
        }
        return i;
    }

    private void handlePasteEnabling() {
        boolean supported;
        block3: {
            supported = false;
            try {
                DataFlavor[] flavors;
                for (DataFlavor flavor : flavors = this.clipboard.getAvailableDataFlavors()) {
                    if (!flavor.equals(MapClip.mapFlavor) && !flavor.equals(DataFlavor.stringFlavor)) continue;
                    supported = true;
                }
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                if (!JAlbum.logger.isLoggable(Level.FINE)) break block3;
                ex.printStackTrace(System.err);
            }
        }
        this.pasteAction.setEnabled(supported && this.isEnabled());
        this.insertAction.setEnabled(this.isEnabled());
    }

    public JMapTable(String nameLabel, String valueLabel) {
        this();
        this.setHeaderNames(nameLabel, valueLabel);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
        if (this.isCellSelected(rowIndex, colIndex)) {
            c.setBackground(JAlbumColor.textHighlight);
            c.setForeground(JAlbumColor.textHighlightText);
        } else {
            c.setForeground(JAlbumColor.textText);
            if (rowIndex % 2 == 1) {
                c.setBackground(this.oddColor);
            } else {
                c.setBackground(this.getBackground());
            }
        }
        return c;
    }

    public void setCellEditable(boolean editable) {
        this.editable = editable;
    }

    public void setHeaderNames(String nameLabel, String valueLabel) {
        this.theModel = new MapModel();
        this.theModel.colNames[0] = nameLabel;
        this.theModel.colNames[1] = valueLabel;
        super.setModel(this.theModel);
    }

    public void clear() {
        int size = this.items.size();
        this.items.clear();
        this.theModel.fireTableRowsDeleted(1, size);
    }

    public LinkedHashMap getMap() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        LinkedHashMap theMap = new LinkedHashMap();
        for (Map.Entry item : this.items) {
            if (item.getKey().toString().isEmpty()) continue;
            theMap.put(item.getKey(), item.getValue());
        }
        return theMap;
    }

    public void putAll(Map theMap) {
        Iterator it = theMap.entrySet().iterator();
        this.theModel.fireTableRowsDeleted(1, this.items.size());
        while (it.hasNext()) {
            this.items.add(it.next());
        }
        Map.Entry[] entries = this.items.toArray(new Map.Entry[this.items.size()]);
        if (this.sortKeys) {
            Arrays.sort(entries, (o1, o2) -> o1.getKey().toString().compareTo(o2.getKey().toString()));
        }
        this.items.clear();
        this.items.addAll(Arrays.asList(entries));
        this.theModel.fireTableRowsInserted(1, this.items.size());
        this.theModel.fireTableDataChanged();
    }

    public void put(Object key, Object value) {
        LinkedHashMap m = this.getMap();
        m.put(key, value);
        this.clear();
        this.putAll(m);
        this.theModel.fireTableDataChanged();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.handlePasteEnabling();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isEnabled()) {
            Color inactive = JAlbumColor.control;
            Color dim = new Color(inactive.getRed(), inactive.getGreen(), inactive.getBlue(), 128);
            g.setColor(dim);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    class MapModel
    extends AbstractTableModel {
        public String[] colNames = new String[]{"Name", "Value"};

        MapModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return JMapTable.this.editable;
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames[col];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return JMapTable.this.items.size() + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= JMapTable.this.items.size()) {
                return "";
            }
            Map.Entry item = JMapTable.this.items.get(row);
            return col == 0 ? item.getKey() : item.getValue();
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (row >= JMapTable.this.items.size()) {
                Entry item = col == 0 ? new Entry(aValue, "") : new Entry("", aValue);
                JMapTable.this.items.add(item);
            } else {
                Map.Entry oldItem = JMapTable.this.items.get(row);
                Entry item = col == 0 ? new Entry(aValue, oldItem.getValue()) : new Entry(oldItem.getKey(), aValue);
                JMapTable.this.items.set(row, item);
            }
            this.fireTableCellUpdated(row, col);
        }

        public void insertRows(int index, Collection<Map.Entry> rows) {
            JMapTable.this.items.addAll(index, rows);
            this.fireTableRowsInserted(index, index + rows.size());
        }

        public ArrayList<Map.Entry> deleteRows(int firstRow, int lastRow) {
            ArrayList<Map.Entry> rows = new ArrayList<Map.Entry>();
            if (lastRow >= JMapTable.this.items.size()) {
                lastRow = JMapTable.this.items.size() - 1;
            }
            for (int i = lastRow; i >= firstRow; --i) {
                rows.add(JMapTable.this.items.remove(i));
            }
            this.fireTableRowsDeleted(firstRow, lastRow);
            return rows;
        }

        public ArrayList<Map.Entry> getRows(int firstRow, int lastRow) {
            ArrayList<Map.Entry> rows = new ArrayList<Map.Entry>();
            if (lastRow >= JMapTable.this.items.size()) {
                lastRow = JMapTable.this.items.size() - 1;
            }
            for (int i = lastRow; i >= firstRow; --i) {
                rows.add(JMapTable.this.items.get(i));
            }
            return rows;
        }
    }

    class Entry
    implements Map.Entry {
        Object key;
        Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object other) {
            return this.key.equals(((Entry)other).key);
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.key != null ? this.key.hashCode() : 0);
            return hash;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object parm1) {
            this.value = parm1;
            return this;
        }
    }
}

