/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JIconTextField
extends JTextField {
    private Icon icon;
    private Insets dummyInsets;

    public JIconTextField(int columns) {
        super(columns);
        this.init();
    }

    public JIconTextField() {
        this.init();
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.icon != null) {
            int iconWidth = this.icon.getIconWidth();
            int iconHeight = this.icon.getIconHeight();
            int y = (this.getHeight() - iconHeight) / 2;
            this.icon.paintIcon(this, g, this.getWidth() - iconWidth - this.dummyInsets.right, y);
        }
    }

    private void init() {
        this.icon = null;
        Border border = UIManager.getBorder("TextField.border");
        if (border == null) {
            border = this.getBorder();
        }
        JTextField dummy = new JTextField();
        this.dummyInsets = border.getBorderInsets(dummy);
    }
}

