/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import se.datadosen.util.LaF;

public class JHtmlPane
extends JTextPane {
    private String text = "";

    public JHtmlPane() {
        this.init();
    }

    public JHtmlPane(String htmlText) {
        this.init();
        this.setHtmlText(htmlText);
    }

    public JHtmlPane(String htmlText, int relFontSize) {
        this.init();
        this.setHtmlText(htmlText, relFontSize);
    }

    public void setHtmlText(String htmlText) {
        this.setHtmlText(htmlText, 1);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.text = t;
    }

    public void setHtmlText(String htmlText, int relFontSize) {
        String in = "<html><body><font face=\"sansserif\" size=" + (3 + relFontSize) + ">" + htmlText + "</font></body></html>";
        this.setText(in);
    }

    private void init() {
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setFocusable(false);
        this.setContentType("text/html");
        this.setOpaque(false);
        this.setEditable(false);
        if (LaF.isDark()) {
            HTMLEditorKit kit = new HTMLEditorKit();
            StyleSheet defaultSheet = kit.getStyleSheet();
            StyleSheet modSheet = new StyleSheet();
            modSheet.addStyleSheet(defaultSheet);
            modSheet.addRule("A {color:#589df6}");
            kit.setStyleSheet(modSheet);
            this.setEditorKit(kit);
        }
    }

    public int hashCode() {
        return this.text != null ? this.text.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JHtmlPane other = (JHtmlPane)obj;
        return this.text.equals(other.text);
    }

    @Override
    public String toString() {
        return this.text;
    }
}

