/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import net.jalbum.util.Animator;
import se.datadosen.component.DeferredSVGIcon;
import se.datadosen.util.Platform;

public class JGlassButton
extends JButton {
    protected boolean mouseOver = false;
    protected boolean mousePressed = false;
    private int borderRadius = 5;
    private boolean uiSet = false;
    private float alpha = 1.0f;
    private float borderOpacity = 0.6f;
    private boolean discrete = false;

    public JGlassButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JGlassButton(Action a) {
        super(a);
        this.init();
    }

    public JGlassButton(String text) {
        super(text);
        this.init();
    }

    public JGlassButton(Icon icon) {
        super(icon);
        this.init();
    }

    public JGlassButton() {
        this.init();
    }

    @Override
    public void updateUI() {
        this.setUI(GlassButtonUI.createUI(this));
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        if (defaultIcon instanceof DeferredSVGIcon) {
            DeferredSVGIcon unalteredIcon = ((DeferredSVGIcon)((Object)defaultIcon)).cloneMe();
            unalteredIcon.setAdaptColors(false);
            super.setIcon((Icon)((Object)unalteredIcon));
        } else {
            super.setIcon(defaultIcon);
        }
    }

    private void init() {
        super.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusable(false);
        this.setOpaque(false);
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() && visible) {
            return;
        }
        if (visible) {
            this.alpha = 0.0f;
        }
        super.setVisible(visible);
        if (visible) {
            Animator.getInstance().playFor(250, ctrl -> {
                if (!this.isVisible()) {
                    ctrl.abort();
                    return;
                }
                this.alpha = ctrl.getCurrentTimeNormalized();
                this.repaint();
            });
        }
    }

    @Override
    protected void paintComponent(Graphics gin) {
        Graphics2D g = (Graphics2D)gin.create();
        Composite comp = g.getComposite();
        float parentAlpha = 1.0f;
        if (comp instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)comp;
            parentAlpha = ac.getAlpha();
        }
        if (this.discrete && !this.mouseOver && !this.mousePressed) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (Platform.isMac()) {
            g.translate(0.5, 0.5);
        }
        g.setColor(this.getBackground());
        g.setColor(this.mousePressed ? this.getBackground().darker() : this.getBackground());
        float mouseOverOpacity = Math.min(this.borderOpacity + 0.12f, 1.0f);
        if (!this.isEnabled()) {
            mouseOverOpacity = this.borderOpacity;
        } else if (this.mousePressed) {
            mouseOverOpacity = 1.0f;
        }
        float borderAlpha = this.mouseOver && !this.discrete ? mouseOverOpacity : this.borderOpacity;
        float a = parentAlpha * this.alpha * borderAlpha;
        if (!this.isEnabled()) {
            a /= 2.0f;
        }
        AlphaComposite composite = AlphaComposite.getInstance(3, a);
        g.setComposite(composite);
        if (!this.discrete || !this.mouseOver && !this.mousePressed) {
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.borderRadius * 2, this.borderRadius * 2);
        }
        g.translate(-1, 0);
        a = parentAlpha * this.alpha;
        if (!this.isEnabled()) {
            a /= 2.0f;
        }
        composite = composite.derive(a);
        g.setComposite(composite);
        super.paintComponent(g);
        g.dispose();
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public void setDiscrete(boolean discrete) {
        this.discrete = discrete;
    }

    public int getBorderRadius() {
        return this.borderRadius;
    }

    public void setBorderRadius(int borderRadius) {
        this.borderRadius = borderRadius;
    }

    public float getBorderOpacity() {
        return this.borderOpacity;
    }

    public void setBorderOpacity(float borderOpacity) {
        this.borderOpacity = borderOpacity;
    }

    private static class GlassButtonUI
    extends BasicButtonUI {
        private static GlassButtonUI ui;

        private GlassButtonUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            if (ui == null) {
                ui = new GlassButtonUI();
            }
            return ui;
        }

        @Override
        protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            FontMetrics fm = g.getFontMetrics();
            g.setColor(b.getForeground());
            g.drawString(text, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        }

        @Override
        protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            Icon icon = b.getIcon();
            Icon tmpIcon = null;
            if (icon == null) {
                return;
            }
            Icon selectedIcon = null;
            if (model.isSelected() && (selectedIcon = b.getSelectedIcon()) != null) {
                icon = selectedIcon;
            }
            if (model.isPressed() && model.isArmed()) {
                tmpIcon = b.getPressedIcon();
                if (tmpIcon != null) {
                    this.clearTextShiftOffset();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected() && (tmpIcon = b.getRolloverSelectedIcon()) == null) {
                    tmpIcon = selectedIcon;
                }
                if (tmpIcon == null) {
                    tmpIcon = b.getRolloverIcon();
                }
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
            if (model.isPressed() && model.isArmed()) {
                icon.paintIcon(c, g, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset());
            } else {
                icon.paintIcon(c, g, iconRect.x, iconRect.y);
            }
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JGlassButton.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JGlassButton.this.mousePressed = true;
            JGlassButton.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JGlassButton.this.mousePressed = false;
            JGlassButton.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JGlassButton.this.mouseOver = true;
            JGlassButton.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JGlassButton.this.mouseOver = false;
            JGlassButton.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JGlassButton.this.mouseOver = true;
            JGlassButton.this.repaint();
        }
    }
}

