/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import se.datadosen.jalbum.JAlbumUtilities;

public class JFontComboBox
extends JComboBox<String> {
    public JFontComboBox() {
        super(new FontModel());
        this.init();
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (!this.getFontModel().names.contains((String)anObject)) {
            this.addItem((String)anObject);
        }
        super.setSelectedItem(anObject);
    }

    private FontModel getFontModel() {
        return (FontModel)this.getModel();
    }

    private void init() {
        this.setMaximumRowCount(20);
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (label != null && value != null) {
                    this.setForeground(label.getForeground());
                    this.setBackground(label.getBackground());
                    this.setText(label.getText());
                    this.setToolTipText(label.getText());
                }
                return this;
            }

            @Override
            protected void paintComponent(Graphics g2d) {
                super.paintComponent(g2d);
                Graphics2D g = (Graphics2D)g2d.create();
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setColor(this.getBackground());
                Insets in = this.getInsets();
                g.fillRect(in.left, in.top, this.getWidth() - in.left - in.right, this.getHeight() - in.top - in.bottom);
                g.setColor(this.getForeground());
                Font f = new Font(this.getText(), 0, 14);
                g.setFont(f);
                FontMetrics fm = g.getFontMetrics(f);
                LineMetrics lm = fm.getLineMetrics(this.getText(), g2d);
                g.drawString(this.getText(), (float)in.left, (float)in.top + lm.getAscent());
                g.dispose();
            }
        });
    }

    private static class FontModel
    extends AbstractListModel<String>
    implements MutableComboBoxModel<String> {
        private Set<String> names = new TreeSet<String>();
        private String[] namesArray;
        private String selectedObject;
        private boolean loadingFonts = true;

        private FontModel() {
            this.init();
        }

        private void init() {
            Thread fontAdderThread = new Thread("Font adder"){

                @Override
                public void run() {
                    this.addItems(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
                    loadingFonts = false;
                    if (selectedObject == null) {
                        SwingUtilities.invokeLater(() -> {
                            if (selectedObject == null) {
                                this.setSelectedItem("SansSerif");
                            }
                        });
                    }
                }
            };
            fontAdderThread.setDaemon(true);
            fontAdderThread.setPriority(1);
            fontAdderThread.start();
        }

        private void addItems(String[] items) {
            TreeSet<String> newSet = new TreeSet<String>(this.names);
            newSet.addAll(Arrays.asList(items));
            String[] array = new String[newSet.size()];
            int i = 0;
            for (String item : newSet) {
                array[i++] = item;
            }
            JAlbumUtilities.runOnAWT(() -> {
                this.namesArray = array;
                this.names = newSet;
                this.fireIntervalAdded(this, 0, this.names.size() - 1);
            });
        }

        public boolean isLoadingFonts() {
            return this.loadingFonts;
        }

        @Override
        public int getSize() {
            return this.names.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.namesArray[index];
        }

        @Override
        public void addElement(String item) {
            this.addItems(new String[]{item});
        }

        @Override
        public void removeElement(Object obj) {
        }

        @Override
        public void insertElementAt(String item, int index) {
        }

        @Override
        public void removeElementAt(int index) {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (!this.names.contains((String)anObject)) {
                this.addElement((String)anObject);
            }
            if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
                this.selectedObject = (String)anObject;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }
    }
}

