/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Platform;

public class JErrorDialog
extends JSmartDialog {
    private JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
    private String message;
    private Throwable theError;
    private JPanel contentPanel = new JPanel(new BorderLayout());
    private JPanel centerPanel = new JPanel(new RiverLayout());
    private JCollapsiblePanel errorDetailsPanel = new JCollapsiblePanel(Msg.get("skinError.detailsPanel"), new BorderLayout());
    private JTextArea codeArea = null;
    private Action copyToClipboardAction = new AbstractAction(Msg.get("ui.copyToClipboard")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(JErrorDialog.this.codeArea.getText()), null);
        }
    };
    private Action closeAction = new AbstractAction(Msg.get("ok")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JErrorDialog.this.setVisible(false);
        }
    };

    public JErrorDialog(Component owner, Throwable theError) {
        this(owner, theError.toString(), null, theError, Dialog.ModalityType.APPLICATION_MODAL);
    }

    public JErrorDialog(Component owner, String message, Throwable theError) {
        this(owner, message, null, theError, Dialog.ModalityType.APPLICATION_MODAL);
    }

    public JErrorDialog(Component owner, String message, String title, Throwable theError, Dialog.ModalityType mt) {
        super(JErrorDialog.windowAncestor(owner), title != null ? title : Msg.get("ui.errorOccured"), mt);
        this.theError = theError;
        this.message = message;
        this.init();
    }

    private static Window windowAncestor(Component comp) {
        return comp instanceof Window ? (Window)comp : SwingUtilities.getWindowAncestor(comp);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        try {
            this.theError.printStackTrace(err);
            err.close();
            this.codeArea = new JSmartTextArea(sw.toString(), 20, 120);
            this.codeArea.setEditable(false);
            this.codeArea.setLineWrap(true);
            this.codeArea.setWrapStyleWord(true);
            this.codeArea.setFont(new Font("Courier new", 0, 12));
            JScrollPane sp = new JScrollPane(this.codeArea);
            this.errorDetailsPanel.add(sp);
            this.errorDetailsPanel.addPropertyChangeListener("expanded", evt -> {
                this.pack();
                Rectangle screen = this.getGraphicsConfiguration().getBounds();
                Rectangle bounds = this.getBounds();
                if (bounds.x + bounds.width > screen.width) {
                    bounds.x = screen.width - bounds.width;
                }
                if (bounds.y + bounds.height > screen.height) {
                    bounds.y = screen.height - bounds.height;
                }
                this.setLocation(bounds.getLocation());
            });
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        this.centerPanel.add("br", new JLabel(this.message));
        this.centerPanel.add("p hfill vfill", this.errorDetailsPanel);
        JPanel iconPanel = new JPanel();
        if (Platform.isMac()) {
            iconPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        }
        iconPanel.add(this.iconLabel);
        this.contentPanel.add((Component)iconPanel, "Before");
        this.contentPanel.add((Component)this.centerPanel, "Center");
        this.add((Component)this.contentPanel, "Center");
        this.addAction(this.copyToClipboardAction);
        this.registerActions(this.closeAction);
        this.pack();
    }
}

