/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import se.datadosen.component.DeferredSVGIcon;

public class JBasicToggleButton
extends JToggleButton {
    public JBasicToggleButton() {
    }

    public JBasicToggleButton(Icon icon) {
        super(icon);
    }

    public JBasicToggleButton(Icon icon, boolean selected) {
        super(icon, selected);
    }

    public JBasicToggleButton(String text) {
        super(text);
    }

    public JBasicToggleButton(String text, boolean selected) {
        super(text, selected);
    }

    public JBasicToggleButton(Action a) {
        super(a);
    }

    public JBasicToggleButton(String text, Icon icon) {
        super(text, icon);
    }

    public JBasicToggleButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
    }

    @Override
    public void updateUI() {
        this.setUI(BasicToggleButtonUI2.create());
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        g.setColor(UIManager.getColor("textHighlight"));
        Insets in = b.getInsets();
        g.fillRect(in.left, in.top, b.getWidth() - in.left - in.right, b.getHeight() - in.top - in.bottom);
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        if (defaultIcon instanceof DeferredSVGIcon) {
            DeferredSVGIcon icon = (DeferredSVGIcon)((Object)defaultIcon);
            DeferredSVGIcon selectedIcon = ((DeferredSVGIcon)((Object)defaultIcon)).cloneMe();
            selectedIcon.setAdaptColors(false);
            this.setSelectedIcon((Icon)((Object)selectedIcon));
        }
    }

    private static class BasicToggleButtonUI2
    extends BasicToggleButtonUI {
        private static BasicToggleButtonUI2 ui;

        private BasicToggleButtonUI2() {
        }

        public static BasicToggleButtonUI2 create() {
            if (ui == null) {
                ui = new BasicToggleButtonUI2();
            }
            return ui;
        }

        @Override
        protected void paintButtonPressed(Graphics g, AbstractButton b) {
            ((JBasicToggleButton)b).paintButtonPressed(g, b);
        }

        @Override
        protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
            Color foreground = b.getForeground();
            if (b.isSelected() || b.getModel().isArmed()) {
                b.setForeground(UIManager.getColor("textHighlightText"));
            }
            super.paintText(g, b, textRect, text);
            b.setForeground(foreground);
        }
    }
}

