/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JArrangeCheckBoxList
extends JTable {
    TableCellRenderer defaultRenderer;
    MyDragListener tableDragListener;

    public JArrangeCheckBoxList(JCheckBox[] listData) {
        this.init(listData);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        pref.width += 26;
        return pref;
    }

    public static JArrangeCheckBoxList getDemoList() {
        JCheckBox apples = new JCheckBox("Apples");
        JCheckBox pears = new JCheckBox("Pears");
        JCheckBox bananas = new JCheckBox("Bananas");
        JArrangeCheckBoxList list = new JArrangeCheckBoxList(new JCheckBox[]{apples, pears, bananas});
        return list;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("testing");
        f.setDefaultCloseOperation(3);
        f.add(JArrangeCheckBoxList.getDemoList());
        JButton button = new JButton("Print state");
        f.add((Component)button, "South");
        f.setSize(120, 200);
        f.validate();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private void init(JCheckBox[] listData) {
        this.setShowGrid(false);
        this.setRowHeight(this.getRowHeight() + 4);
        DefaultTableModel model = new DefaultTableModel(0, 1){};
        for (JCheckBox item : listData) {
            model.addRow(new Object[]{item});
            new MyDragListener(item);
        }
        this.setModel(model);
        TableColumn col = this.getColumnModel().getColumn(0);
        this.setSelectionMode(0);
        this.defaultRenderer = col.getCellRenderer();
        col.setCellRenderer(new CheckBoxRenderer());
        col.setCellEditor(new CheckboxEditor());
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setTransferHandler(new MyListDropHandler(this));
        this.tableDragListener = new MyDragListener(this);
    }

    public JCheckBox[] getValues() {
        TableModel model = this.getModel();
        JCheckBox[] values = new JCheckBox[model.getRowCount()];
        for (int row = 0; row < model.getRowCount(); ++row) {
            values[row] = (JCheckBox)model.getValueAt(row, 0);
        }
        return values;
    }

    public int getSelectedIndex() {
        return this.selectionModel.getMinSelectionIndex();
    }

    class MyDragListener
    implements DragSourceListener,
    DragGestureListener {
        DragSource ds = DragSource.getDefaultDragSource();

        public MyDragListener(Component comp) {
            DragGestureRecognizer dgr = this.ds.createDefaultDragGestureRecognizer(comp, 2, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            System.out.println("Drag gesture recognized");
            StringSelection transferable = new StringSelection(Integer.toString(JArrangeCheckBoxList.this.getSelectedIndex()));
            TableCellEditor editor = JArrangeCheckBoxList.this.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
                return;
            }
            this.ds.startDrag(dge, DragSource.DefaultMoveDrop, transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final int KNOB_INDENT = 20;

        CheckBoxRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JCheckBox cb = (JCheckBox)value;
            this.setText(cb.getText());
            this.setSelected(cb.isSelected());
            this.setBackground(isSelected ? UIManager.getColor("textHighlight") : UIManager.getColor("text"));
            this.setForeground(isSelected ? UIManager.getColor("textHighlightText") : UIManager.getColor("textText"));
            return this;
        }

        @Override
        protected void paintComponent(Graphics g2d) {
            super.paintComponent(g2d);
            Graphics2D g = (Graphics2D)g2d;
            g.setColor(SystemColor.textInactiveText);
            int nLines = 3;
            int spacing = 2;
            int knobHeight = nLines * spacing;
            int knobY = (this.getHeight() - knobHeight) / 2;
            for (int i = 0; i < 3; ++i) {
                g.drawLine(this.getWidth() - 20, knobY + spacing * i, this.getWidth() - 14, knobY + spacing * i);
            }
        }
    }

    class CheckboxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ItemListener {
        JCheckBox editorCB;
        JCheckBox modelCB;

        CheckboxEditor() {
            this.editorCB = new CheckBoxRenderer();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.modelCB = (JCheckBox)value;
            this.editorCB.setText(this.modelCB.getText());
            this.editorCB.setSelected(this.modelCB.isSelected());
            this.editorCB.addItemListener(this);
            this.editorCB.setBackground(isSelected ? UIManager.getColor("textHighlight") : UIManager.getColor("text"));
            this.editorCB.setForeground(isSelected ? UIManager.getColor("textHighlightText") : UIManager.getColor("textText"));
            return this.editorCB;
        }

        @Override
        public Object getCellEditorValue() {
            this.modelCB.setSelected(this.editorCB.isSelected());
            return this.modelCB;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.editorCB.removeItemListener(this);
            this.stopCellEditing();
        }
    }

    class MyListDropHandler
    extends TransferHandler {
        JArrangeCheckBoxList list;

        public MyListDropHandler(JArrangeCheckBoxList list) {
            this.list = list;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
            return dl.getRow() != -1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            String indexString;
            if (!this.canImport(support)) {
                return false;
            }
            Transferable transferable = support.getTransferable();
            try {
                indexString = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                System.out.println(e);
                return false;
            }
            int index = Integer.parseInt(indexString);
            JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
            int dropTargetIndex = dl.getRow();
            if (dropTargetIndex == index + 1 || dropTargetIndex == index) {
                return false;
            }
            DefaultTableModel model = (DefaultTableModel)JArrangeCheckBoxList.this.getModel();
            if (dropTargetIndex > index) {
                --dropTargetIndex;
            }
            model.moveRow(index, index, dropTargetIndex);
            JArrangeCheckBoxList.this.selectionModel.setLeadSelectionIndex(dropTargetIndex);
            return true;
        }
    }
}

