/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Msg;

public class FindAndReplace {
    static final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    private JFindDialog findDialog;
    private JTextArea textArea;
    private Consumer<String> logger;
    public final Action findAction = new AbstractAction(Msg.get("fr.find") + "..."){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, menuShortcutKeyMask));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindAndReplace.this.findDialog.setMode(Mode.FIND);
            FindAndReplace.this.findDialog.setVisible(true);
        }
    };
    public final Action replaceAction = new AbstractAction(Msg.get("fr.replace") + "..."){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, menuShortcutKeyMask));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindAndReplace.this.findDialog.setMode(Mode.REPLACE);
            FindAndReplace.this.findDialog.setVisible(true);
        }
    };
    public final Action findNextAction = new AbstractAction(Msg.get("fr.findNext")){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FindAndReplace.this.findDialog.toFind.getText().length() == 0) {
                FindAndReplace.this.findAction.actionPerformed(e);
            } else {
                SearchResult result;
                boolean found = false;
                boolean up = FindAndReplace.this.findDialog.up.isSelected();
                int oldCaretPosition = FindAndReplace.this.textArea.getCaretPosition();
                SearchContext sc = new SearchContext();
                sc.setSearchFor(FindAndReplace.this.findDialog.toFind.getText());
                sc.setMatchCase(FindAndReplace.this.findDialog.matchCase.isSelected());
                sc.setSearchForward(FindAndReplace.this.findDialog.down.isSelected());
                sc.setWholeWord(FindAndReplace.this.findDialog.wholeWords.isSelected());
                sc.setRegularExpression(FindAndReplace.this.findDialog.regExp.isSelected());
                if (!(FindAndReplace.this.textArea instanceof RTextArea)) {
                    sc.setMarkAll(false);
                }
                if ((result = SearchEngine.find((JTextArea)FindAndReplace.this.textArea, (SearchContext)sc)).wasFound()) {
                    return;
                }
                FindAndReplace.this.textArea.setCaretPosition(oldCaretPosition);
                if (!found) {
                    Toolkit.getDefaultToolkit().beep();
                    FindAndReplace.this.status(Msg.get("fr.notFoundInfo"));
                }
            }
        }
    };
    Action replaceNextAction = new AbstractAction(Msg.get("fr.replaceNext")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FindAndReplace.this.findDialog.toFind.getText().length() == 0) {
                FindAndReplace.this.findAction.actionPerformed(e);
            } else {
                boolean found = false;
                boolean up = FindAndReplace.this.findDialog.up.isSelected();
                int oldCaretPosition = FindAndReplace.this.textArea.getCaretPosition();
                SearchContext sc = new SearchContext();
                sc.setSearchFor(FindAndReplace.this.findDialog.toFind.getText());
                sc.setReplaceWith(FindAndReplace.this.findDialog.replaceWith.getText());
                sc.setMatchCase(FindAndReplace.this.findDialog.matchCase.isSelected());
                sc.setSearchForward(FindAndReplace.this.findDialog.down.isSelected());
                sc.setWholeWord(FindAndReplace.this.findDialog.wholeWords.isSelected());
                sc.setRegularExpression(FindAndReplace.this.findDialog.regExp.isSelected());
                SearchResult result = SearchEngine.replace((RTextArea)((RTextArea)FindAndReplace.this.textArea), (SearchContext)sc);
                if (result.wasFound()) {
                    return;
                }
                FindAndReplace.this.textArea.setCaretPosition(oldCaretPosition);
                if (!found) {
                    Toolkit.getDefaultToolkit().beep();
                    FindAndReplace.this.status(Msg.get("fr.notFoundInfo"));
                }
            }
        }
    };
    Action replaceAllAction = new AbstractAction(Msg.get("fr.replaceAll")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FindAndReplace.this.findDialog.toFind.getText().length() == 0) {
                return;
            }
            int total = 0;
            SearchContext sc = new SearchContext();
            sc.setSearchFor(FindAndReplace.this.findDialog.toFind.getText());
            sc.setReplaceWith(FindAndReplace.this.findDialog.replaceWith.getText());
            sc.setMatchCase(FindAndReplace.this.findDialog.matchCase.isSelected());
            sc.setWholeWord(FindAndReplace.this.findDialog.wholeWords.isSelected());
            sc.setRegularExpression(FindAndReplace.this.findDialog.regExp.isSelected());
            SearchResult result = SearchEngine.replaceAll((RTextArea)((RTextArea)FindAndReplace.this.textArea), (SearchContext)sc);
            FindAndReplace.this.status(Msg.get("fr.replacedInfo", total += result.getCount(), FindAndReplace.this.findDialog.toFind.getText()));
        }
    };

    public FindAndReplace(Window window, JTextArea textArea) {
        this.findDialog = new JFindDialog(window);
        this.textArea = textArea;
        InputMap im = textArea.getInputMap();
        im.put(KeyStroke.getKeyStroke(70, menuShortcutKeyMask), "find");
        this.replaceAction.setEnabled(textArea instanceof RTextArea && textArea.isEditable());
        im.put(KeyStroke.getKeyStroke(82, menuShortcutKeyMask), "replace");
        im.put(KeyStroke.getKeyStroke(114, 0), "findNext");
        ActionMap am = textArea.getActionMap();
        am.put("find", this.findAction);
        am.put("findNext", this.findNextAction);
        am.put("replace", this.replaceAction);
    }

    public void onStatus(Consumer<String> logger) {
        this.logger = logger;
    }

    public void status(String msg) {
        if (this.logger != null) {
            this.logger.accept(msg);
        }
    }

    public class JFindDialog
    extends JDialog {
        private Window owner;
        JTextField toFind;
        JLabel toReplaceLabel;
        JTextField replaceWith;
        JCheckBox matchCase;
        JCheckBox wholeWords;
        JCheckBox regExp;
        JRadioButton up;
        JRadioButton down;
        JButton replaceNextButton;
        JButton replaceAllButton;
        Action closeAction;

        public JFindDialog(Window owner) {
            super(owner, Msg.get("fr.find"), Dialog.ModalityType.MODELESS);
            this.toFind = new JTextField(15);
            this.toReplaceLabel = new JLabel(Msg.get("fr.replaceWith") + ":");
            this.replaceWith = new JTextField(15);
            this.matchCase = new JCheckBox(Msg.get("fr.matchCase"));
            this.wholeWords = new JCheckBox(Msg.get("fr.wholeWords"));
            this.regExp = new JCheckBox(Msg.get("fr.regularExpression"));
            this.up = new JRadioButton(Msg.get("fr.up"));
            this.down = new JRadioButton(Msg.get("fr.down"), true);
            this.closeAction = new AbstractAction(Msg.get("close")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFindDialog.this.setVisible(false);
                }
            };
            this.owner = owner;
            this.init();
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            this.toFind.requestFocusInWindow();
            this.toFind.selectAll();
        }

        private void init() {
            KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
            JLayeredPane pane = this.getLayeredPane();
            String actionName = "close-dialog";
            pane.getInputMap(2).put(esc, actionName);
            pane.getActionMap().put(actionName, this.closeAction);
            this.toFind.registerKeyboardAction(this.closeAction, esc, 0);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.up);
            bg.add(this.down);
            JButton findNextButton = new JButton(FindAndReplace.this.findNextAction);
            this.getRootPane().setDefaultButton(findNextButton);
            this.replaceNextButton = new JButton(FindAndReplace.this.replaceNextAction);
            this.replaceAllButton = new JButton(FindAndReplace.this.replaceAllAction);
            this.setLayout(new BorderLayout());
            JPanel c = new JPanel();
            c.setLayout(new RiverLayout());
            c.add(new JLabel(Msg.get("fr.findWhat") + ":"));
            c.add("tab hfill", this.toFind);
            c.add("br", this.toReplaceLabel);
            c.add("tab hfill", this.replaceWith);
            JPanel cbPanel = new JPanel();
            cbPanel.setLayout(new GridLayout(0, 1));
            cbPanel.add(this.matchCase);
            cbPanel.add(this.wholeWords);
            cbPanel.add(this.regExp);
            c.add("br", cbPanel);
            ControlPanel directionPanel = new ControlPanel(Msg.get("fr.direction"));
            directionPanel.add(this.up);
            directionPanel.add(this.down);
            c.add(directionPanel);
            JPanel actionPanel = new JPanel();
            actionPanel.setLayout(new RiverLayout(4, 2));
            actionPanel.add("hfill", findNextButton);
            actionPanel.add("br hfill", this.replaceNextButton);
            actionPanel.add("br hfill", this.replaceAllButton);
            actionPanel.add("br hfill", new JButton(this.closeAction));
            JPanel content = new JPanel();
            content.setLayout(new BorderLayout());
            content.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
            content.add((Component)c, "Center");
            content.add((Component)actionPanel, "After");
            this.getContentPane().add((Component)content, "Center");
            this.setMode(Mode.FIND);
        }

        public void setMode(Mode mode) {
            boolean replaceMode = mode == Mode.REPLACE;
            this.setTitle(replaceMode ? Msg.get("fr.replace") : Msg.get("fr.find"));
            this.toReplaceLabel.setVisible(replaceMode);
            this.replaceWith.setVisible(replaceMode);
            this.replaceNextButton.setVisible(replaceMode);
            this.replaceAllButton.setVisible(replaceMode);
            this.pack();
        }

        class ControlPanel
        extends JPanel {
            public ControlPanel(String title) {
                this.setLayout(new RiverLayout());
                this.setBorder(BorderFactory.createTitledBorder(title));
            }
        }
    }

    static enum Mode {
        FIND,
        REPLACE;

    }
}

