/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class DimensionFormatter
extends JFormattedTextField.AbstractFormatter {
    @Override
    public Object stringToValue(String text) throws ParseException {
        try {
            text = text.replace('X', 'x');
            text = text.replace('*', 'x');
            text = text.replace(',', 'x');
            String[] tokens = text.split("x");
            Dimension dim = new Dimension(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]));
            return dim;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
            throw new ParseException("Format needs to be widthxheight", 0);
        }
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        Dimension dim = (Dimension)value;
        if (dim == null) {
            dim = new Dimension(0, 0);
        }
        return dim.width + "x" + dim.height;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("");
        JFormattedTextField tf = new JFormattedTextField(new DimensionFormatter());
        JComboBox<Object> fruits = new JComboBox<Object>(new Object[]{"200x200", "300x300", "400x400"});
        fruits.setEditable(true);
        fruits.setEditor(new DimensionComboBoxEditor());
        fruits.addActionListener(e -> System.out.println("ActionEvent: " + String.valueOf(e)));
        tf.setColumns(10);
        f.getContentPane().setLayout(new FlowLayout());
        f.add(fruits);
        f.add(new JTextField("another"));
        JButton check = new JButton("Check");
        check.addActionListener(e -> {
            System.out.println("Selected fruit: " + String.valueOf(fruits.getSelectedItem()));
            fruits.setSelectedItem(((JTextField)fruits.getEditor().getEditorComponent()).getText());
            System.out.println(((JTextField)fruits.getEditor().getEditorComponent()).getText());
        });
        f.add(check);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private static class DimensionComboBoxEditor
    extends BasicComboBoxEditor {
        private DimensionComboBoxEditor() {
        }

        @Override
        public Object getItem() {
            JFormattedTextField f = (JFormattedTextField)this.editor;
            try {
                return f.getFormatter().valueToString(f.getFormatter().stringToValue(this.editor.getText()));
            }
            catch (ParseException ex) {
                return super.getItem();
            }
        }

        @Override
        protected JTextField createEditorComponent() {
            JFormattedTextField editor = new JFormattedTextField(new DimensionFormatter());
            editor.setColumns(9);
            return editor;
        }
    }
}

