/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.MissingResourceException;
import se.datadosen.io.ReplacingReader;
import se.datadosen.util.LaF;

public class DeferredSVGIcon
extends SVGIcon
implements Cloneable {
    private Class resourceLoader;
    private String name;
    private boolean adaptColors = true;
    private boolean invertColors = false;

    public int getIconWidth() {
        int width = super.getIconWidth();
        if (width == 0) {
            this.ensureLoaded();
        }
        return super.getIconWidth();
    }

    public int getIconHeight() {
        int height = super.getIconHeight();
        if (height == 0) {
            this.ensureLoaded();
        }
        return super.getIconHeight();
    }

    public boolean isAdaptColors() {
        return this.adaptColors;
    }

    public void setAdaptColors(boolean adaptColors) {
        this.adaptColors = adaptColors;
    }

    public boolean isInvertColors() {
        return this.invertColors;
    }

    public void setInvertColors(boolean invertColors) {
        this.invertColors = invertColors;
    }

    public DeferredSVGIcon(Class resourceLoader, String name) {
        this.resourceLoader = resourceLoader;
        this.name = name;
    }

    public DeferredSVGIcon cloneMe() {
        try {
            DeferredSVGIcon clone = (DeferredSVGIcon)super.clone();
            clone.setSvgURI(null);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void paintIcon(Component comp, Graphics gg, int x, int y) {
        this.ensureLoaded();
        super.paintIcon(comp, gg, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded() {
        if (this.getSvgURI() == null) {
            try {
                URI uri;
                SVGUniverse universe = SVGCache.getSVGUniverse();
                InputStream is = this.resourceLoader.getResourceAsStream(this.name);
                if (is == null) {
                    throw new MissingResourceException("Can't locate icon \"" + this.name + "\"", this.resourceLoader.getName(), this.name);
                }
                Reader reader = new InputStreamReader(is, "UTF-8");
                if (this.invertColors || LaF.isDark() && this.adaptColors) {
                    reader = new ReplacingReader(reader).replace("#333333", "#DDDDDD").replace("#333", "#DDD").replace("#DDDDDD", "#333333").replace("#DDD", "#333").replace("#000000", "#FFFFFF").replace("#000", "#FFF").replace("#FFFFFF", "#000000").replace("#FFF", "#000").replace("#165FB1", "#589df6");
                }
                SVGUniverse sVGUniverse = universe;
                synchronized (sVGUniverse) {
                    uri = universe.loadSVG(reader, this.resourceLoader.getName() + this.name + (this.adaptColors ? "-adapted" : ""));
                }
                ((Reader)reader).close();
                this.setSvgURI(uri);
            }
            catch (IOException ex) {
                throw new MissingResourceException("Missing icon: " + this.name, this.resourceLoader.getName(), this.name);
            }
        }
    }

    public String toString() {
        return "DeferredSVGIcon: " + this.name;
    }
}

