/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import se.datadosen.jalbum.JAlbumColor;

public class CutCornersBorder
implements Border {
    private static final int A = 20;
    private static final int B = 7;
    private static final int roundness = 10;
    private boolean left;
    private boolean right;

    public CutCornersBorder(boolean left, boolean right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public void paintBorder(Component c, Graphics gg, int x, int y, int w, int h) {
        Graphics2D g = (Graphics2D)gg;
        g.setColor(JAlbumColor.window);
        int cw = w + (!this.left ? 20 : 0) + (!this.right ? 20 : 0);
        for (int i = 1; i < 10; ++i) {
            g.drawRoundRect(x + (this.left ? 0 : -21), -1, cw, h, i, i);
        }
        g.setColor(new Color(0, 0, 0, 17));
        g.drawRoundRect(x + (this.left ? 1 : -20), 1, cw - 2, h - 2, 10, 10);
        g.setColor(new Color(0, 0, 0, 60));
        g.drawRoundRect(x + (this.left ? 0 : -20), 0, cw - 1, h - 1, 10, 10);
        int x0 = x + (this.left ? 5 : 0);
        int x1 = x + (1 + w - (this.right ? 7 : 0));
        g.setColor(new Color(255, 0, 0, 222));
        this.drawLine(g, x0 - 1, 0, x1 + 1, 0, new Color(0, 0, 0, 16));
        this.drawLine(g, x0 + 0, 0, x1 - 0, 0, new Color(0, 0, 0, 40));
        this.drawLine(g, x0 - 1, 1, x1 + 1, 1, new Color(0, 0, 0, 65));
        this.drawLine(g, x0 - 2, 2, x1 + 2, 2, new Color(0, 0, 0, 20));
        g.setColor(new Color(0, 0, 0, 64));
        if (this.left) {
            g.drawLine(x0 - 2, 1, x0 - 4, 3);
        }
        if (this.right) {
            g.drawLine(x1 + 2, 1, x1 + 4, 3);
        }
        g.setColor(new Color(255, 255, 255, 64));
        g.drawLine(x0 - 1, h - 1, x1 + 1, h - 1);
    }

    private void drawLine(Graphics g, int x0, int y0, int x1, int y1, Color c) {
        g.setColor(c);
        g.drawLine(x0, y0, x1, y1);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(3, this.left ? 4 : 0, 1, this.right ? 4 : 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

