/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;
import se.datadosen.util.LaF;
import se.datadosen.util.Platform;

public class CurvedLineBorder
implements Border {
    private int roundness;
    private Color lineColor = UIManager.getColor("Separator.foreground");
    private Color backgroundColor = null;

    public CurvedLineBorder() {
        if (Platform.isMac()) {
            this.roundness = 11;
            if (LaF.isDark()) {
                // empty if block
            }
        } else {
            this.roundness = 8;
        }
    }

    public CurvedLineBorder(Color lineColor) {
        this();
        this.lineColor = lineColor;
    }

    public CurvedLineBorder(Color lineColor, Color backgroundColor) {
        this();
        this.lineColor = lineColor;
        this.lineColor = lineColor;
    }

    @Override
    public void paintBorder(Component c, Graphics gg, int x, int y, int w, int h) {
        Graphics2D g = (Graphics2D)gg;
        if (this.backgroundColor != null) {
            g.setColor(this.backgroundColor);
            g.fillRoundRect(x, y, w - 1, h - 1, this.roundness, this.roundness);
        }
        g.setColor(this.lineColor);
        g.drawRoundRect(x, y, w - 1, h - 1, this.roundness, this.roundness);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return Platform.isMac() ? new Insets(1, 1, 1, 1) : new Insets(1, 1, 1, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

