/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.border.Border;

public class ComicSpeechBubbleBorder
implements Border {
    private int outlineThickness = 2;
    private Color outlineColor = Color.decode("#111111");
    int r = 16;
    int tw = 22;
    int th = 22;
    boolean tipToRight = false;

    public ComicSpeechBubbleBorder() {
    }

    public ComicSpeechBubbleBorder(boolean tipToRight) {
        this.tipToRight = tipToRight;
    }

    public ComicSpeechBubbleBorder(boolean tipToRight, int outlineThickness, Color outlineColor) {
        this.tipToRight = tipToRight;
        this.outlineThickness = outlineThickness;
        this.outlineColor = outlineColor;
    }

    public boolean isTipToRight() {
        return this.tipToRight;
    }

    public void setTipToRight(boolean tipToRight) {
        this.tipToRight = tipToRight;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHints(qualityHints);
        g2d.setPaint(c.getBackground());
        AffineTransform backup = g2d.getTransform();
        int w = width - this.outlineThickness;
        int h = height - this.outlineThickness;
        g2d.translate(this.outlineThickness / 2, this.outlineThickness / 2);
        if (this.tipToRight) {
            g2d.translate(w, 0);
            g2d.scale(-1.0, 1.0);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(this.tw / 2, this.th);
        path.curveTo(this.tw / 2, this.th, this.tw / 2, this.th / 2, 0.0f, 0.0f);
        path.curveTo(0.0f, 0.0f, 2 * this.tw / 3, 0.0f, this.tw, this.th / 2);
        path.curveTo(this.tw, this.th / 2, this.tw, 0.0f, this.tw * 2, 0.0f);
        path.lineTo(w - this.r, 0.0f);
        path.curveTo(w - this.r, 0.0f, w, 0.0f, w, this.r);
        path.lineTo(w, h - this.r);
        path.curveTo(w, h - this.r, w, h, w - this.r, h);
        path.lineTo(this.tw / 2 + this.r, h);
        path.curveTo(this.tw / 2 + this.r, h, this.tw / 2, h, this.tw / 2, h - this.r);
        path.lineTo(this.tw / 2, this.th);
        path.closePath();
        g2d.fill(path);
        if (this.outlineThickness > 0) {
            g2d.setPaint(this.outlineColor);
            g2d.setStroke(new BasicStroke(this.outlineThickness));
            g2d.draw(path);
        }
        g2d.setTransform(backup);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int m = 2 * this.r / 3;
        if (this.tipToRight) {
            return new Insets(m, m, m, this.tw + m);
        }
        return new Insets(m, this.tw + m, m, m);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

