/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import se.datadosen.jalbum.FileNameDocument;

public class AutoSelectingTreeCellEditor
extends DefaultTreeCellEditor {
    public boolean ignoreFocusLost = false;
    public boolean rootEditable = false;
    private boolean cancelled;

    public AutoSelectingTreeCellEditor(JTree p0, DefaultTreeCellRenderer p1) {
        super(p0, p1);
        DefaultCellEditor editor = (DefaultCellEditor)this.realEditor;
        editor.getComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Component src = e.getComponent();
                if (src != null && src instanceof JTextComponent) {
                    JTextComponent textField = (JTextComponent)src;
                    if (!(textField.getDocument() instanceof FileNameDocument)) {
                        String content = textField.getText();
                        textField.setDocument(new FileNameDocument());
                        textField.setText(content);
                    }
                    textField.setText(textField.getText());
                    textField.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!AutoSelectingTreeCellEditor.this.ignoreFocusLost && !AutoSelectingTreeCellEditor.this.cancelled && AutoSelectingTreeCellEditor.this.editingComponent == null) {
                    AutoSelectingTreeCellEditor.this.stopCellEditing();
                    AutoSelectingTreeCellEditor.this.cancelled = false;
                }
            }
        });
        editor.getComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    AutoSelectingTreeCellEditor.this.cancelled = true;
                    AutoSelectingTreeCellEditor.this.cancelCellEditing();
                }
            }
        });
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        TreePath path;
        if (event != null && event.getSource() instanceof JTree && event instanceof MouseEvent && ((path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY())) == null || path.getPathCount() == 1 && !this.rootEditable)) {
            return false;
        }
        return super.isCellEditable(event);
    }

    @Override
    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.renderer != null) {
            JLabel label = (JLabel)this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            this.editingIcon = label.getIcon();
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }
}

