/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.views;

import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import net.jalbum.views.AbstractView;
import se.datadosen.component.ControlPanel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.structure.RecentlyAddedTransformer;

public class RecentlyAddedView
extends AbstractView<RecentlyAddedTransformer> {
    private static final ImageIcon icon = (ImageIcon)Icons.get("view recent", 192);
    private transient JAlbumExplorer context;

    public RecentlyAddedView() {
        super(new RecentlyAddedTransformer());
    }

    @Override
    public JComponent getUserInterfaceComponent(ViewAlbumObject viewObject, JAlbumExplorer context) {
        this.context = context;
        return new UI();
    }

    @Override
    public String getName() {
        return Msg.get("view.recentlyAdded");
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    private class UI
    extends ControlPanel {
        JComboBox<RecentlyAddedTransformer.ThresholdType> typeCombo = new JComboBox<RecentlyAddedTransformer.ThresholdType>(RecentlyAddedTransformer.ThresholdType.values());
        JSpinner daysSpinner = new JSpinner(new SpinnerNumberModel(30, 0, 999999, 1));
        JSpinner dateSpinner = new JSpinner(new SpinnerDateModel(new Date(), null, null, 5));
        JLabel sizeLabel = new JLabel();
        Action checkSizeAction = new AbstractAction(Msg.get("ui.checkSize")){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.setEnabled(false);
                UI.this.sizeLabel.setText(Msg.get("ui.calculatingSize") + "...");
                UI.this.sizeLabel.setVisible(true);
                CompletableFuture.supplyAsync(() -> ((RecentlyAddedTransformer)RecentlyAddedView.this.transformer).transform(RecentlyAddedView.this.viewSource).getChildren().size()).thenAcceptAsync(result -> JAlbumUtilities.runOnAWT(() -> {
                    this.setEnabled(true);
                    UI.this.sizeLabel.setText(Msg.get("ui.nMatchingObjects", result));
                }));
            }
        };

        public UI() {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.getDefault());
            JSpinner.DateEditor editor = new JSpinner.DateEditor(this.dateSpinner, df.toPattern());
            this.dateSpinner.setEditor(editor);
            this.typeCombo.addItemListener(il -> {
                this.update();
                this.uiChanged(il.getSource());
            });
            this.daysSpinner.addChangeListener(cl -> this.uiChanged(cl.getSource()));
            this.dateSpinner.addChangeListener(cl -> this.uiChanged(cl.getSource()));
            this.add("br", new JLabel(Msg.get("ui.type")));
            this.add("tab", this.typeCombo);
            this.add(this.daysSpinner);
            this.add(this.dateSpinner);
            this.add("p tab", new JButton(this.checkSizeAction));
            this.add("hfill", this.sizeLabel);
            this.typeCombo.setSelectedItem((Object)((RecentlyAddedTransformer)RecentlyAddedView.this.transformer).getType());
            this.daysSpinner.setValue(((RecentlyAddedTransformer)RecentlyAddedView.this.transformer).getDays());
            this.update();
        }

        private void uiChanged(Object source) {
            this.sizeLabel.setVisible(false);
            if (source == this.typeCombo) {
                ((RecentlyAddedTransformer)RecentlyAddedView.this.transformer).setType((RecentlyAddedTransformer.ThresholdType)((Object)this.typeCombo.getSelectedItem()));
            } else if (source == this.daysSpinner) {
                ((RecentlyAddedTransformer)RecentlyAddedView.this.transformer).setDays((Integer)this.daysSpinner.getValue());
            } else if (source == this.dateSpinner && this.dateSpinner.isEnabled()) {
                ((RecentlyAddedTransformer)RecentlyAddedView.this.transformer).setDate(((Date)this.dateSpinner.getValue()).getTime());
            }
            if (RecentlyAddedView.this.onLeaveEdit != null) {
                RecentlyAddedView.this.onLeaveEdit.run();
            }
        }

        private void update() {
            switch ((RecentlyAddedTransformer.ThresholdType)((Object)this.typeCombo.getSelectedItem())) {
                case SINCE_N_DAYS: {
                    this.dateSpinner.setVisible(false);
                    this.daysSpinner.setVisible(true);
                    break;
                }
                case SINCE_DATE: {
                    long d = ((RecentlyAddedTransformer)RecentlyAddedView.this.transformer).getDate();
                    if (d == 0L) {
                        d = RecentlyAddedView.this.context.getRootFolder().getProperties().get("createdDate", new Date().getTime());
                    }
                    this.dateSpinner.setValue(new Date(d));
                    this.dateSpinner.setEnabled(true);
                    this.dateSpinner.setVisible(true);
                    this.daysSpinner.setVisible(false);
                    break;
                }
                case SINCE_LAST_PUBLISHED: {
                    this.dateSpinner.setValue(new Date(RecentlyAddedView.this.context.getRootFolder().getProperties().get("lastPublishedDate", 0L)));
                    this.dateSpinner.setVisible(true);
                    this.dateSpinner.setEnabled(false);
                    this.daysSpinner.setVisible(false);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }
}

