/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.views;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.jalbum.views.View;
import net.miginfocom.swing.MigLayout;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.structure.Transformer;

abstract class AbstractView<T extends Transformer>
implements View {
    protected transient Runnable onLeaveEdit;
    protected T transformer;
    protected transient T oldTransformer;
    protected transient AlbumObject viewSource;
    private transient AlbumObject viewObject;

    AbstractView(T transformer) {
        this.transformer = transformer;
    }

    protected void onLeaveEdit(Runnable r) {
        this.onLeaveEdit = r;
    }

    @Override
    public T getTransformer() {
        return this.transformer;
    }

    public void setTransformer(T transformer) {
        this.transformer = transformer;
    }

    @Override
    public void saveTo(AlbumObject ao) {
        if (this.onLeaveEdit != null) {
            this.onLeaveEdit.run();
        }
        AlbumObjectProperties props = ao.getProperties();
        props.put("view", this);
        props.save();
    }

    @Override
    public JComponent getUserInterface(ViewAlbumObject viewObject, JAlbumExplorer context) {
        this.oldTransformer = this.transformer.copy();
        this.viewSource = viewObject != null ? viewObject.getViewSource() : context.getCurrentFolder();
        this.viewObject = viewObject;
        return new UI(viewObject, context);
    }

    protected JComponent getUserInterfaceComponent(ViewAlbumObject viewObject, JAlbumExplorer context) {
        return new JPanel();
    }

    private class UI
    extends JPanel
    implements EditListener {
        JLabel sourceLabel;

        public UI(ViewAlbumObject viewObject, JAlbumExplorer context) {
            this.sourceLabel = new JLabel(Msg.get("info.source") + ": " + String.valueOf(AbstractView.this.viewSource));
            this.sourceLabel.setToolTipText(Msg.get("info.sourceToolTip"));
            this.setBorder(new TitledBorder(this.getName()));
            this.setLayout((LayoutManager)new MigLayout("wrap", "[grow]", "[grow][]"));
            this.add((Component)AbstractView.this.getUserInterfaceComponent(viewObject, context), "grow");
            this.add((Component)this.sourceLabel, "grow");
        }

        private void save() {
            AbstractView.this.viewObject.getProperties().save();
            AbstractView.this.viewObject.invalidate();
            AbstractView.this.viewObject.updateRepresentingIcon();
        }

        @Override
        public void setAlbumObject(AlbumObject ao) {
            if (ao == null) {
                if (AbstractView.this.onLeaveEdit != null) {
                    AbstractView.this.onLeaveEdit.run();
                }
                if (!AbstractView.this.transformer.equals(AbstractView.this.oldTransformer)) {
                    System.out.println("Saving");
                    this.save();
                    Object oldTrans = AbstractView.this.oldTransformer.copy();
                    Object newTrans = AbstractView.this.transformer.copy();
                    AbstractView.this.viewObject.getFactory().getUndoNotifier().undoableEditHappened(this, Msg.get("ui.editView"), () -> {
                        AbstractView.this.setTransformer(oldTrans);
                        System.out.println("Undoing to " + String.valueOf(oldTrans));
                        this.save();
                    }, () -> {
                        AbstractView.this.setTransformer(newTrans);
                        System.out.println("Redoing to " + String.valueOf(newTrans));
                        this.save();
                    });
                }
            }
        }
    }
}

