/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class WorkerPool {
    private final ForkJoinPool pool;

    public WorkerPool(int parallelism) {
        this.pool = new ForkJoinPool(parallelism, new MyWorkerThreadFactory(), null, false);
    }

    public <T, R> R process(Collection<T> coll, Function<Stream<T>, R> func) {
        return this.process(coll.parallelStream(), func);
    }

    public <T, R> R process(Stream<T> stream, Function<Stream<T>, R> func) {
        Future fut = this.pool.submit(() -> func.apply(stream));
        try {
            return (R)((ForkJoinTask)fut).get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    public <T> void process(Collection<T> coll, Consumer<Stream<T>> consumer) {
        this.process(coll.parallelStream(), consumer);
    }

    public <T> void process(Stream<T> stream, Consumer<Stream<T>> consumer) {
        Future fut = this.pool.submit(() -> consumer.accept(stream));
        try {
            ((ForkJoinTask)fut).get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    private static class MyWorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private MyWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new MyWorkerThread(pool);
        }
    }

    private static class MyWorkerThread
    extends ForkJoinWorkerThread {
        protected MyWorkerThread(ForkJoinPool pool) {
            super(pool);
        }
    }
}

