/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.util;

import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.datadosen.jalbum.AlbumObjectProperties;

public class QuickProperties {
    private File file;
    private JsonObject props = new JsonObject();
    private JsonObject lastProps = new JsonObject();

    public QuickProperties(File f) {
        this.file = f;
        this.load();
    }

    public boolean isTrue(String key) {
        Object o = this.props.get((Object)key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public Object get(String key) {
        return this.props.get((Object)key);
    }

    public <T> T get(String key, T def) {
        return (T)this.props.getOrDefault((Object)key, def);
    }

    public Object put(String key, Object value) {
        return this.props.put((Object)key, value);
    }

    public Object putNotEmpty(String key, Object value) {
        if (value != null) {
            return this.put(key, value);
        }
        return null;
    }

    public void moveFrom(String key, AlbumObjectProperties source) {
        Object val = source.get(key);
        if (val != null) {
            this.put(key, val);
            source.remove(key);
        }
    }

    public Object remove(String key) {
        return this.props.remove((Object)key);
    }

    public boolean containsKey(String key) {
        return this.props.containsKey((Object)key);
    }

    public Set<String> keySet() {
        return this.props.keySet();
    }

    private boolean load() {
        boolean bl;
        FileReader reader = new FileReader(this.file, Charset.forName("UTF8"));
        try {
            this.props = (JsonObject)Jsoner.deserialize((Reader)reader);
            this.lastProps = (JsonObject)this.props.clone();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                return false;
            }
            catch (JsonException | IOException ex) {
                Logger.getLogger(QuickProperties.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public boolean isChanged() {
        return !this.props.equals((Object)this.lastProps);
    }

    public void flush() {
        try {
            if (this.isChanged()) {
                this.store(false);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(QuickProperties.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void store(boolean preserveLastModified) throws IOException {
        long lastModified = preserveLastModified ? this.file.lastModified() : 0L;
        try (FileWriter writer = new FileWriter(this.file, Charset.forName("UTF8"));){
            Jsoner.serialize((Object)this.props, (Writer)writer);
            if (preserveLastModified && lastModified > 0L) {
                this.file.setLastModified(lastModified);
            }
        }
        this.lastProps = (JsonObject)this.props.clone();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        return "QuickProperties: " + String.valueOf(this.props);
    }
}

